<?php $__env->startSection('content'); ?>

    <div class="card table-responsive">
        <div class="card-header">
            <form action="<?php echo e(route('price.list.view')); ?>" method="get">
                <?php if($sellingCount > 1): ?>
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    <?php if($sellingCount > 1): ?>
                                        <select name="location" id="location" class="form-control" style="text-align: center"
                                            required>
                                            <option disabled selected>-- Choose Location --</option>
                                            <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($selling->location_id); ?>">
                                                    -- <?php echo e($selling->location->name); ?> --
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php else: ?>
                                        <input type="hidden" name="location" id="location" class="form-control"
                                            value="<?php echo e($sellings[0]->location_id); ?>">

                                        <input type="text" name="area-copy" id="area-copy" class="form-control"
                                            value="<?php echo e($sellings[0]->location->name); ?>" style="text-align: center" readonly>
                                    <?php endif; ?>
                                </td>

                                <td> <button type="submit" id="search" class="btn btn-primary">Search</button></td>
                            </tr>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p><a href="<?php echo e(route('custom.pricelist')); ?>" class="btn btn-success">-- Custom price list --</a>
                    </p>
                <?php endif; ?>
            </form>
        </div>

        <div class="card-body table-responsive">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm border rounded"
                    style="text-align: center; min-width: 1100px;" id="customer">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 3%">#</th>
                            <th>Product</th>
                            <th>Buying<br><small>(per base unit)</small></th>
                            <th>Selling<br><small>(per unit)</small></th>
                            <th>Profit<br><small>(per unit)</small></th>
                            <th>Margin</th>
                            <th>Location</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $productUnits = App\Models\Unit::all();
                            $unitsByProduct = collect();
                            if (count($products) > 0) {
                                $productIds = $products->pluck('id');
                                $unitsByProduct = App\Models\UnitAssigned::with('unit')
                                    ->whereIn('product_id', $productIds)
                                    ->whereNotNull('unit_id')
                                    ->where('selling', '!=', 0)
                                    ->orderBy('unit_cont', 'asc')
                                    ->get()
                                    ->groupBy('product_id');
                            }
                        ?>

                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $units = $unitsByProduct[$product->id] ?? collect();
                                $hasNegativeProfitMargin = $units->contains(function ($unit) use ($product) {
                                    $profitMargin =
                                        ($unit->selling - $product->buying * $unit->unit_cont) / ($unit->selling ?: 1);
                                    return $unit->selling != 0 && $profitMargin <= 0;
                                });
                            ?>
                            <tr class="<?php echo e($hasNegativeProfitMargin ? 'table-warning' : ''); ?>">
                                <td><?php echo e($loop->iteration); ?></td>
                                <td class="fw-bold text-primary text-left"><?php echo e($product->product); ?></td>
                                <td>
                                    <?php echo e(number_format($product->buying)); ?> @ <span
                                        class="badge bg-light text-dark"><?php echo e($units[0]->unit->name ?? ''); ?></span>
                                </td>
                                <td>
                                    <?php $__empty_2 = true; $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <?php if($units[0]->unit): ?>
                                            <span class="-primary text-dark mb-1">
                                                <?php echo e($unit->unit->name); ?>: <?php echo e(number_format($unit->selling)); ?>

                                            </span><br>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php $__empty_2 = true; $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <?php if($unit->unit): ?>
                                            <span class="badge bg-success text-light mb-1">
                                                <?php echo e($unit->unit->name); ?>:
                                                <?php echo e(number_format($unit->selling - $product->buying * $unit->unit_cont)); ?>

                                            </span><br>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php $__empty_2 = true; $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <?php
                                            $profitMargin =
                                                ($unit->selling - $product->buying * $unit->unit_cont) /
                                                ($unit->selling ?: 1);
                                        ?>
                                        <span
                                            class="badge <?php echo e($profitMargin <= 0 ? 'bg-danger' : 'bg-primary'); ?> text-light mb-1">
                                            <?php echo e($unit->unit->name ?? ''); ?>:
                                            <?php echo e($unit->selling != 0 ? round($profitMargin * 100) . '%' : 'N/A'); ?>

                                        </span><br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-secondary"><?php echo e($product->location->name ?? 'N/A'); ?></span>
                                </td>
                                <td>
                                    <!-- Button trigger modal -->
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#edit-<?php echo e($product->id); ?>">
                                        <i class="fa-solid fa-pen-to-square"></i> Edit unit
                                    </button>
                                    <!-- Modal -->
                                    <form action="<?php echo e(route('units.update', $product->id)); ?>" method="get"
                                        class="was-validated d-inline">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal fade" id="edit-<?php echo e($product->id); ?>" tabindex="-1" role="dialog"
                                            aria-labelledby="myModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-primary text-white">
                                                        <h5 class="modal-title" id="myModalLabel">
                                                            Edit Units for: <span
                                                                class="fw-bold"><?php echo e($product->product); ?></span>
                                                        </h5>
                                                        <button type="button" class="close text-white" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body table-responsive">
                                                        <table class="table table-bordered table-hover">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th>Unit</th>
                                                                    <th>Cont</th>
                                                                    <th>Buying</th>
                                                                    <th>Price</th>
                                                                    <th>
                                                                        <button type="button"
                                                                            class="btn btn-primary addunit"
                                                                            id="<?php echo e($product->id); ?>"><i
                                                                                class="fas fa-plus"></i></button>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <div id="newRow">
                                                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php if($unit->unit): ?>
                                                                            <tr>
                                                                                <td style="width: 35%">
                                                                                    <select name="unit[]"
                                                                                        id="unit<?php echo e($loop->index); ?>"
                                                                                        class="form-control">
                                                                                        <option selected
                                                                                            value="<?php echo e($unit->unit_id); ?>">
                                                                                            -- <?php echo e($unit->unit->name); ?> --
                                                                                        </option>
                                                                                        <?php $__currentLoopData = $productUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kipimo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <option
                                                                                                value="<?php echo e($kipimo->id); ?>">
                                                                                                -- <?php echo e($kipimo->name); ?> --
                                                                                            </option>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                    </select>
                                                                                </td>
                                                                                <td>
                                                                                    <input type="number" name="cont[]"
                                                                                        id="cont<?php echo e($loop->index); ?>"
                                                                                        placeholder="Unit content"
                                                                                        value="<?php echo e($unit->unit_cont); ?>"
                                                                                        class="form-control" min="1"
                                                                                        required>
                                                                                </td>
                                                                                <td>
                                                                                    <input type="number" name="buy[]"
                                                                                        id="buy<?php echo e($loop->index); ?>"
                                                                                        placeholder="Buying price"
                                                                                        value="<?php echo e($product->buying * $unit->unit_cont); ?>"
                                                                                        class="form-control" min="0"
                                                                                        required>
                                                                                </td>
                                                                                <td>
                                                                                    <input type="number" name="price[]"
                                                                                        id="price<?php echo e($loop->index); ?>"
                                                                                        placeholder="Selling price"
                                                                                        value="<?php echo e($unit->selling); ?>"
                                                                                        class="form-control"
                                                                                        min="0" required>
                                                                                </td>
                                                                                <td>
                                                                                    <button type="button"
                                                                                        class="btn btn-danger remove-row">
                                                                                        <i class="fas fa-trash-alt"></i>
                                                                                    </button>
                                                                                </td>
                                                                            </tr>
                                                                        <?php endif; ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <div class="btn-group" role="group" aria-label="Unit Actions">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">
                                                                <i class="fa-solid fa-xmark"></i> Close
                                                            </button>
                                                            <button type="submit" class="btn btn-primary">
                                                                <i class="fa-solid fa-paper-plane"></i> Save changes
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Data Found</h5>
                                        <p class="text-muted mb-0">You haven't selected location yet.<br>
                                            <span class="small">Click <strong>Choose Location</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                    <tfoot class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Product</th>
                            <th>Buying</th>
                            <th>Selling</th>
                            <th>Profit</th>
                            <th>Margin</th>
                            <th>Location</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <script>
            $(document).ready(function() {
                $("#customer").DataTable({
                    "pageLength": 100,
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

                // Use event delegation for the '.addunit' button
                $(document).on('click', '.addunit', function() {
                    let productId = $(this).attr('id'); // Get the product ID
                    let index = 10; // Initialize the index variable
                    let newRow = `
                    <tr>
                        <td style="width: 35%">
                            <select name="unit[]" id="unit${index}" class="form-control unit">
                                <option selected disabled value="">-- Select Unit --</option>
                                <?php $__currentLoopData = $productUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kipimo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($kipimo->id); ?>">-- <?php echo e($kipimo->name); ?> --</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td><input type="number" name="cont[]" id="cont${index}" placeholder="Unit content" value="" class="form-control cont"></td>
                        <td><input type="number" name="buy[]" id="buy${index}" placeholder="Buying price" value="" class="form-control buy"></td>
                        <td><input type="number" name="price[]" id="price${index}" placeholder="Selling price" value="" class="form-control price"></td>
                        <td><button type="button" class="btn btn-outline-danger remove-row"><i class="fas fa-trash-alt"></i></button></td>
                    </tr>
                `;

                    $(this).closest('tr').after(newRow);

                    // Update the index variable
                    index++;
                });

                // Use event delegation for the '.remove-row' button
                $(document).on('click', '.remove-row', function() {
                    $(this).closest('tr').remove();
                });
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/price-list.blade.php ENDPATH**/ ?>