<?php $__env->startSection('content'); ?>
    
    <div class="content">
        <input type="hidden" value="<?php echo e(Auth::user()->role); ?>" id="user">
        <div class="card table-responsive">
            <div class="card-header">
                <div class="row">
                    <div class="col">
                        Post sales.
                    </div>

                    
                </div>
            </div>

            <div class="card-body">
                <div class="mb-4">
                    <div class="row align-items-center">
                        <div class="col-md-7 mb-2 mb-md-0">
                            <div class="input-group">
                                <span class="input-group-text bg-primary text-white">
                                    <i class="fas fa-barcode"></i>
                                </span>
                                <input type="search" id="search" class="form-control search"
                                    placeholder="Enter product name or barcode...">
                            </div>
                            <div id="list"
                                style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                                class="bg-white border border-primary">
                                <ol id="results" class="list-group list-group-flush"></ol>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <?php if($sellingCount > 1): ?>
                                <div class="input-group shadow-sm">
                                    <span class="input-group-text bg-info text-white">
                                        <i class="fas fa-store"></i>
                                    </span>
                                    <select name="area" id="area" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected>-- Choose Location --</option>
                                        <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($selling->location_id); ?>">-- <?php echo e($selling->location->name); ?> --
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="area" id="area" class="form-control"
                                    value="<?php echo e($sellings[0]->location_id); ?>">
                                <div class="input-group shadow-sm">
                                    <span class="input-group-text bg-info text-white">
                                        <i class="fas fa-store"></i>
                                    </span>
                                    <input type="text" name="area-copy" id="area-copy" class="form-control"
                                        value="<?php echo e($sellings[0]->location->name); ?>" style="text-align: center" readonly>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <br>

                <form action="<?php echo e(route('store.sales', ['status' => $status])); ?>" onsubmit="showSpinner()" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-9">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover align-middle shadow-sm"
                                    style="background: #fff;">
                                    <thead class="table-secondary text-center align-middle">
                                        <tr>
                                            <th style="width: 20%">Product</th>
                                            <th style="width:10%">Unit</th>
                                            <th style="width:12%">Price</th>
                                            <th style="width: 20%">Qty</th>
                                            <th style="width:12%">Amount</th>
                                            <th style="width:12%">Discount</th>
                                            <th style="width:5%">Action</th>
                                        </tr>
                                    </thead>
                                    <?php
                                        $iteration = 200;
                                    ?>
                                    <tbody id="tbody">
                                        
                                    </tbody>

                                    <?php if(session()->has('profomaItems')): ?>
                                        <tbody id="tbody1">
                                            <?php $__currentLoopData = session('profomaItems'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    # Increment iteration
                                                    $iteration++;

                                                    # Compute profit
                                                    $profit =
                                                        ($detail['price'] - $detail->product->buying) *
                                                        ($detail['cont'] * $detail['qty']);

                                                    # Get each product unit
                                                    $units = App\Models\UnitAssigned::where(
                                                        'product_id',
                                                        $detail->product_id,
                                                    )
                                                        ->with('unit')
                                                        ->get();
                                                ?>

                                                <tr id="tr<?php echo e($iteration); ?>">
                                                    <td style="text-align: center;">
                                                        <input type="hidden" name="id[]"
                                                            value="<?php echo e($detail['product_id']); ?>" id="id<?php echo e($iteration); ?>"
                                                            class="form-control id" readonly>
                                                        <input type="hidden" name="area[]"
                                                            value="<?php echo e($detail['location_id']); ?>"
                                                            id="area<?php echo e($iteration); ?>" class="form-control area"
                                                            readonly>
                                                        <input type="hidden" name="productQty[]"
                                                            value="<?php echo e($detail['productQty'] ?? ''); ?>"
                                                            id="productQty<?php echo e($iteration); ?>"
                                                            class="form-control productQty" readonly>
                                                        <?php echo e($detail->product->product); ?>

                                                    </td>

                                                    <td>
                                                        <select class="form-control unit" style="text-align: center"
                                                            name="unit[]" id="unit<?php echo e($iteration); ?>">
                                                            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($detail->unit->id); ?>"
                                                                    <?php if($detail['unit_id'] == $detail->unit->id): echo 'selected'; endif; ?>><?php echo e($detail->unit->name); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <input type="hidden" value="<?php echo e($detail['cont']); ?>" name="cont[]"
                                                            id="cont<?php echo e($iteration); ?>" class="form-control cont"
                                                            style="text-align: center">
                                                    </td>

                                                    <td>
                                                        <input type="text" name="price[]"
                                                            value="<?php echo e(number_format($detail['price'])); ?>"
                                                            id="price<?php echo e($iteration); ?>" class="form-control price"
                                                            style="text-align: center">
                                                        <input type="hidden" name="buying[]"
                                                            value="<?php echo e(number_format($detail->product->buying)); ?>"
                                                            id="buying<?php echo e($iteration); ?>" class="form-control buying"
                                                            style="text-align: center" readonly>
                                                    </td>

                                                    <td style="display:flex">
                                                        <button type="button"
                                                            class="btn btn-outline-warning btn-block decrement"
                                                            id="<?php echo e($iteration); ?>"><i
                                                                class="fas fa-minus"></i></button>
                                                        <input type="text" value="<?php echo e($detail['qty']); ?>"
                                                            name="qty[]" id="qty<?php echo e($iteration); ?>"
                                                            class="form-control qty" style="text-align: center;" required>
                                                        <button type="button"
                                                            class="btn btn-outline-success btn-block increment"
                                                            id="increment<?php echo e($iteration); ?>"><i
                                                                class="fas fa-plus"></i></button>
                                                    </td>

                                                    <td>
                                                        <input type="text" name="amount[]"
                                                            value="<?php echo e(number_format($detail['amount'])); ?>"
                                                            id="amount<?php echo e($iteration); ?>" class="form-control amount"
                                                            style="text-align: center" readonly>
                                                    </td>

                                                    <td>
                                                        <input type="text" style="text-align: center" name="disc[]"
                                                            placeholder="<?php echo e(number_format($profit)); ?>"
                                                            value="<?php echo e($detail['disc'] ?? ''); ?>"
                                                            id="disc<?php echo e($iteration); ?>" class="form-control discount">
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-outline-danger removeRow"
                                                            id="<?php echo e($iteration); ?>"><i
                                                                class="fas fa-trash-alt"></i></button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    <?php endif; ?>

                                    <?php if(session()->has('soldItems')): ?>
                                        <tbody id="tbody1">
                                            <?php $__currentLoopData = session('soldItems'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    # Increment iteration
                                                    $iteration++;

                                                    # Compute profit
                                                    $profit =
                                                        ($item['price'] - $item->product->buying) *
                                                        ($item['cont'] * $item['qty']);

                                                    # Get each product unit
                                                    $units = App\Models\UnitAssigned::where(
                                                        'product_id',
                                                        $item->product_id,
                                                    )
                                                        ->with('unit')
                                                        ->get();
                                                ?>

                                                <tr id="tr<?php echo e($iteration); ?>">
                                                    <td class="text-center fw-semibold">
                                                        <input type="hidden" name="id[]"
                                                            value="<?php echo e($item['product_id']); ?>" id="id<?php echo e($iteration); ?>"
                                                            class="form-control id" readonly>
                                                        <input type="hidden" name="area[]"
                                                            value="<?php echo e($item['location_id']); ?>"
                                                            id="area<?php echo e($iteration); ?>" class="form-control area"
                                                            readonly>
                                                        <?php echo e($item->product->product); ?>

                                                    </td>
                                                    <td>
                                                        <select class="form-control unit text-center" name="unit[]"
                                                            id="unit<?php echo e($iteration); ?>">
                                                            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($unit->unit->id); ?>"
                                                                    <?php echo e($item['unit_id'] == $unit->unit->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($unit->unit->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <input type="hidden" value="1" name="cont[]"
                                                            id="cont<?php echo e($iteration); ?>"
                                                            class="form-control cont text-center">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="price[]"
                                                            value="<?php echo e(number_format($item['price'])); ?>"
                                                            id="price<?php echo e($iteration); ?>"
                                                            class="form-control price text-center">

                                                        <input type="hidden" name="buying[]"
                                                            value="<?php echo e(number_format($item->product->buying, 2)); ?>"
                                                            id="buying<?php echo e($iteration); ?>"
                                                            class="form-control buying text-center" readonly>
                                                    </td>
                                                    <td class="d-flex align-items-center gap-1 justify-content-center">
                                                        <button type="button" class="btn btn-outline-warning decrement"
                                                            id="<?php echo e($iteration); ?>"><i
                                                                class="fas fa-minus"></i></button>
                                                        <input type="number" value="<?php echo e($item['qty']); ?>" name="qty[]"
                                                            id="qty<?php echo e($iteration); ?>"
                                                            class="form-control qty text-center" style="max-width: 70px;"
                                                            required>
                                                        <button type="button" class="btn btn-outline-success increment"
                                                            id="increment<?php echo e($iteration); ?>"><i
                                                                class="fas fa-plus"></i></button>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="amount[]"
                                                            value="<?php echo e(number_format($item['amount'])); ?>"
                                                            id="amount<?php echo e($iteration); ?>"
                                                            class="form-control amount text-center" readonly>

                                                    </td>
                                                    <td>
                                                        <input type="number" name="disc[]"
                                                            placeholder="<?php echo e($profit); ?>" value=""
                                                            id="disc<?php echo e($iteration); ?>"
                                                            class="form-control discount text-center">
                                                    </td>
                                                    <td class="text-center">
                                                        <button type="button" class="btn btn-outline-danger removeRow"
                                                            id="<?php echo e($iteration); ?>"><i
                                                                class="fa fa-trash-alt"></i></button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    <?php endif; ?>
                                </table>
                            </div>
                        </div>

                        <div class="col was-validated">
                            <input type="date" name="date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control"
                                style="text-align: center">

                            <input type="text" name="total" id="total" class="form-control"
                                style="text-align: center" placeholder="Total"
                                value="<?php echo e(number_format(optional(session('profomaData') ?: session('salesDetails'))['total'] ?? 0, 2)); ?>"
                                readonly>

                            <input type="text" name="discount" id="discount" class="form-control"
                                style="text-align: center" placeholder="Discount"
                                value="<?php echo e(number_format(optional(session('salesDetails'))['discount'] ?? 0, 2)); ?>"
                                readonly>

                            <input type="text" name="net" id="net" class="form-control"
                                style="text-align: center" placeholder="Net"
                                value="<?php echo e(number_format(optional(session('profomaData') ?: session('salesDetails'))['total'] ?? 0, 2)); ?>"
                                readonly>

                            <select name="type" id="type" required class="form-control"
                                style="text-align: center">
                                <option disabled selected value="">-- Choose Type --
                                <option value="cash">-- Cash --</option>
                                <option value="credit">-- Credit --</option>
                                </option>
                            </select>

                            <input type="text" name="paid" id="paid" class="form-control"
                                style="text-align: center" placeholder="Paid" required>

                            <input type="text" name="due" id="due" class="form-control"
                                style="text-align: center" placeholder="Due balance" value="" readonly>

                            <select name="account" id="account" class="form-control" style="text-align: center"
                                required></select>

                            <div id="mteja">
                                <input type="text" id="customer" name="customer" class="form-control customer"
                                    placeholder="Enter Customer Name..." style="text-align: center">
                                <div id="customer-list" style="display:none">
                                    <ol id="customers"></ol>
                                </div>

                                <input type="text" id="phone" name="phone" class="form-control phone"
                                    placeholder="Enter Customer Contacts" style="text-align: center">

                                <input type="text" id="address" name="address" class="form-control phone"
                                    placeholder="Enter Customer Adress" style="text-align: center">
                            </div>

                            

                            <input type="hidden" name="location" id="location" class="form-control"
                                style="text-align: center">

                            <input type="hidden" name="locationstatus" id="locationstatus" class="form-control"
                                style="text-align: center">

                            <br>
                            <button class="btn btn-info btn-block" id="submitBtn"><i
                                    class="fas fa-paper-plane fa-lg"></i> Confirm</button>
                            <a href="<?php echo e(route('cancel.sales', ['id' => 0, 'status' => 'sale'])); ?>"
                                class="btn btn-danger btn-block" id="cancel"><i class="fas fa-times fa-lg"></i>
                                Cancel</a>
                            <button type="button" id="hold" class="btn btn-secondary btn-block"><i
                                    class="fas fa-hand fa-lg"></i> Hold</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $("#hold").on("click", function() {
                window.open("<?php echo e(route('sale.index', ['id' => 0, 'status' => 'hold'])); ?>");
            });

            // Retrieve the latest entry with the key 'index' from PHP and pass it to JavaScript
            //var latestIndex = <?php echo json_encode(session()->get('sold_items', [])[count(session()->get('sold_items', [])) - 1]['index'] ?? null); ?>;
            // Use the 'latestIndex' variable in JavaScript

            //Global variables
            //if (latestIndex === null) {
            //     var index = 0;
            // } else {
            //     var index = Number(latestIndex) + Number(1);
            // }

            var index = 0;
            var query;
            var location;
            var ajaxResponse;
            var productId;
            var paid;
            var net;
            var total;
            var discount;
            var price;
            var qty;
            var units;
            var unit;
            var unitprice;
            var id;
            var customer;
            var account;
            var object;
            var massage = "No suggesstions..."

            // Create a new Intl.NumberFormat object
            var formatter = new Intl.NumberFormat();

            var sellingCount = <?php echo e($sellingCount); ?>; // Access the PHP variable in JavaScript

            if (sellingCount > 1) { // If there are multiple selling locations
                $("#area").focus();
                $("#area").on("change", function() {
                    location = $(this).val();
                    locationStatus(location); // Call locationStatus function.
                    locationAccounts(location); // Call locationAccount function
                    $("#location").val(location); // Pass locationId to location element.
                });
            } else { // If there's one selling one selling location
                $("#search").focus();
                location = $("#area").val();
                locationStatus(location); // Call locationStatus function.
                locationAccounts(location); // Call locationAccount function
                $("#location").val(location); // Pass locationId to location element.
            }

            function locationStatus(location) {
                $.ajax({
                    url: "<?php echo e(route('location.status')); ?>",
                    method: "get",
                    data: {
                        'location': location
                    },
                    success: function(data) {
                        console.log(data);
                        $("#locationstatus").val(data[0]);
                        $("#location").val(location);

                        if (data[0] == "static") {
                            $("#mteja").fadeIn("slow");
                            $("#salesman").fadeOut("slow");
                        } else {
                            $("#mteja").fadeOut("slow");
                            $("#salesman").fadeIn("slow");
                            $("#salesman").val(data[1]);
                        }
                    }
                });
            }

            function locationAccounts(location) {
                $.ajax({
                    url: "<?php echo e(route('get.location.accounts')); ?>",
                    method: "get",
                    data: {
                        'locationId': location
                    },
                    success: function(response) {
                        var selectElement = $('#account');
                        // Clear any existing options
                        selectElement.empty();
                        // Add the default option if needed
                        selectElement.append(
                            '<option disabled selected value="">-- Account --</option>');
                        selectElement.append(
                            '<option value="0">-- Customer Advance --</option>');
                        // Iterate over the response data and add options
                        $.each(response, function(index, item) {
                            selectElement.append('<option value="' + item.id +
                                '">-- ' +
                                item.type + ' - ' + item.name + ' --</option>');
                        });
                    }
                });
            }

            // Initiate variable
            let isFunctionRunning = false;
            let lastKeyTime = 0;
            let barcodeBuffer = "";

            // Unified SEARCH + BARCODE SCAN function
            function searchProduct(query, isBarcode = false) {
                if (isFunctionRunning) return;

                isFunctionRunning = true;
                let locationId = location;
                let message = "No suggestions..";

                $.ajax({
                    url: "<?php echo e(route('get.location.product')); ?>",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query, // if barcode, ignore query
                        barcode: isBarcode ? query : null, // if barcode, send barcode
                        locationId: locationId
                    },
                    success: function(response) {
                        ajaxResponse = response;
                        console.log("Ajax Response:", ajaxResponse);
                        $("#results").empty();

                        if (!query) {
                            isFunctionRunning = false;
                            return;
                        }

                        // ✅ Barcode scan result (expect 1 product only)
                        if (isBarcode && response.length === 1) {
                            addProductToTable(response[0]);
                            $("#search").val("").focus();
                            $("#list").fadeOut("slow");
                            return;
                        }

                        // ✅ Manual typing, no results
                        if (!isBarcode && response.length === 0) {
                            $("#list").fadeIn("slow");
                            $("#results").append(
                                `<li><button type="button" class="btn btn-outline-secondary form-control items">${message}</button></li>`
                            );
                            setTimeout(() => {
                                $("#list").fadeOut("slow", () => {
                                    $("#results").empty();
                                });
                            }, 2000);
                            return;
                        }

                        // ✅ Manual typing, show suggestions
                        if (!isBarcode) {
                            response.forEach((product, index) => {
                                $("#list").fadeIn("slow");

                                if (product.batches && product.batches.length > 0) {
                                    let batchHtml = `
                            <li class="d-flex align-items-center mb-2">
                                <span class="flex-grow-1 me-2">
                                    ${product.product}
                                </span>
                                <select class="form-control batch-select flex-shrink-0" data-index="${index}" style="width: 25%;">
                                    <option value="" disabled selected>-- Select Batch --</option>
                                    ${product.batches.map(batch => `
                                                                                                                                                                                        <option value="${batch.batch_no}" 
                                                                                                                                                                                                data-qty="${batch.qty}" 
                                                                                                                                                                                                data-exp="${batch.exp}">
                                                                                                                                                                                            Batch No: ${batch.batch_no} | Exp: ${batch.exp} | Stock: ${batch.qty} ${product.unit[0].name}
                                                                                                                                                                                        </option>
                                                                                                                                                                                    `).join('')}
                                </select>
                            </li>`;
                                    $("#results").append(batchHtml);
                                } else {
                                    let qtyDisplay = product.totalQty ?? 0;
                                    let unitName = product.unit?.[0]?.name ?? "";
                                    $("#results").append(`
                            <li class="product-item" data-index="${index}">
                                <button type="button" class="btn btn-outline-secondary form-control items">
                                    ${product.product} | Stock: ${qtyDisplay} ${unitName}
                                </button>
                            </li>`);
                                }
                            });
                        }
                    },
                    complete: function() {
                        isFunctionRunning = false;
                    }
                });
            }

            // 🔹 Manual typing search (keyup)
            $("#search").on("keyup", function(e) {
                let query = $(this).val();

                // 🚫 Don’t run normal search if Enter was pressed (barcode will handle that)
                if (e.which === 13) return;

                // 🚫 Ignore if scanner is typing very fast (barcode in progress)
                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) {
                    return;
                }
                lastKeyTime = currentTime;

                if (query.length > 0) {
                    searchProduct(query, false); // normal search
                }
            });

            // 🔹 Barcode scan detection (Enter key)
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                // Build barcode buffer if fast input
                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                // Enter key signals end of barcode
                if (e.key === "Enter") {
                    e.preventDefault();
                    let barcode = $(this).val().trim();

                    if (barcode !== "") {
                        searchProduct(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            // When batch button is clicked -> toggle dropdown
            $(document).on("click", ".batch-btn", function() {
                let index = $(this).data("index");
                $(`.batch-select[data-index="${index}"]`).toggleClass("d-none").focus();
            });

            // When batch is selected
            $(document).on("change", ".batch-select", function() {
                let index = $(this).data("index");
                let selected = $(this).find("option:selected");

                if (selected.val()) {
                    let batchData = {
                        batch_no: selected.val(),
                        qty: selected.data("qty"),
                        exp: selected.data("exp")
                    };

                    // 🚫 Check qty before adding
                    if (batchData.qty <= 0) {
                        Swal.fire({
                            icon: "warning",
                            title: "Out of Stock",
                            text: "This batch has no available quantity.",
                            confirmButtonText: "OK",
                            confirmButtonColor: "#d33"
                        });
                        // Reset dropdown back to placeholder
                        $(this).val("").addClass("d-none");
                        return;
                    }

                    addProductToTable(ajaxResponse[index], batchData);

                    // Reset dropdown back to placeholder
                    $(this).val("").addClass("d-none");
                }
            });

            // When product without batch is clicked
            $(document).on("click", ".product-item", function() {
                let index = $(this).data("index");
                let product = ajaxResponse[index];

                // 🚫 Check qty before adding
                if ((product.totalQty ?? 0) <= 0) {
                    Swal.fire({
                        icon: "warning",
                        title: "Out of Stock",
                        text: "This product has no available quantity.",
                        confirmButtonText: "OK",
                        confirmButtonColor: "#d33"
                    });
                    return;
                }

                addProductToTable(product);
            });

            function addProductToTable(product, batchData = null) {
                let categoryName = product.category ?? 'product';
                let availableQty = batchData ? batchData.qty : product.totalQty ?? 0;
                let batchNo = batchData ? batchData.batch_no : '';
                let expDate = batchData ? batchData.exp : '';

                // Hidden inputs for batch info
                let batchHidden =
                    `<input type="hidden" name="batch_no[]" value="${batchNo}" id="batch_no${index}" class="batch_no">`;
                let expHidden =
                    `<input type="hidden" name="exp[]" value="${expDate}" id="exp${index}" class="exp">`;

                // Units dropdown
                let units = '';
                for (let i = 0; i < product.unit.length; i++) {
                    units += `<option value="${product.unit[i].id}">${product.unit[i].name}</option>`;
                }

                let unitPrice = product.unit?.[0]?.selling ?? 0;
                let profit = unitPrice - (product.buying ?? 0);
                unitPrice = formatter.format(unitPrice);
                profit = formatter.format(profit);

                let tr = `
        <tr id="tr${index}">
            <td style="text-align: center;">
                <input type="hidden" name="id[]" value="${product.id}" id="id${index}" class="form-control id" readonly>
                <input type="hidden" name="area[]" value="${product.location_id}" id="area${index}" class="form-control area" readonly>
                <input type="hidden" name="buying[]" value="${product.buying}" id="buying${index}" class="form-control buying" readonly>
                <input type="hidden" name="productQty[]" value="${availableQty}" id="productQty${index}" class="form-control productQty" readonly>
                <input type="hidden" name="category[]" value="${categoryName}" id="category${index}" class="form-control category" readonly>
                ${batchHidden}
                ${expHidden}
                ${product.product}${batchNo ? ' | Batch# ' + batchNo : ''}
            </td>
            <td>
                <select class="form-control unit" name="unit[]" id="unit${index}">
                    ${units}
                </select>
                <input type="hidden" value="1" name="cont[]" id="cont${index}" class="form-control cont" style="text-align: center">
            </td>
            <td>
                <input type="text" name="price[]" value="${unitPrice}" id="price${index}" class="form-control price" style="text-align: center">
            </td>
            <td style="display:flex">
                <button type="button" class="btn btn-outline-warning btn-block decrement" id="decrement${index}"><i class="fas fa-minus"></i></button>
                <input type="text" value="1" name="qty[]" id="qty${index}" class="form-control qty" style="text-align: center;" required>
                <button type="button" class="btn btn-outline-success btn-block increment" id="increment${index}"><i class="fas fa-plus"></i></button>
            </td>
            <td>
                <input type="text" name="amount[]" value="${unitPrice}" id="amount${index}" class="form-control amount" style="text-align: center" readonly>
            </td>
            <td>
                <input type="text" style="text-align: center" name="disc[]" placeholder="${profit}" value="" id="disc${index}" class="form-control discount">
            </td>
            <td>
                <button type="button" class="btn btn-outline-danger removeRow" id="${index}">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </td>
        </tr>
    `;

                $("#tbody").after(tr); // ✅ append INSIDE tbody
                index++;
                total(); // recalc totals
                $("#search").val("").focus();
                $("#list").fadeOut("slow");
            }


            // UPDATE productQty[] when batch selected
            $(document).on('change', '.batch-select', function() {
                const selectedQty = $(this).find('option:selected').data('qty');
                $(this).closest('tr').find('.productQty').val(selectedQty);
            });

            $(document).on("click", ".removeRow", function() {
                var id = $(this).prop("id");
                $("#tr" + id).remove();

                total(); // Call total function.

                $("#search").val("");
                $("#search").focus();
            });

            $(document).on("click", ".increment", function() {
                let id = $(this).attr("id").replace("increment", "");
                let qtyInput = $("#qty" + id);
                let productQtyInput = $("#productQty" + id);
                let categoryCheck = $("#category" + id).val();
                let qty = parseFloat(qtyInput.val());
                let productQty = parseFloat(productQtyInput.val());
                console.log(categoryCheck);

                // Only call the warning if category is NOT 'Service'
                if (categoryCheck != 'Service') {
                    if (showLimitedCapacityWarning(qty, productQty, id)) {
                        return; // Stop further execution if limit is exceeded
                    }
                }

                // Increment qty if limit not exceeded
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            function showLimitedCapacityWarning(qty, productQty, id) {
                if (qty >= productQty) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Limited capacity warning',
                        text: 'Exceeded available quantity!',
                        showCloseButton: true
                    });

                    // Reset quantity to max available
                    let qtyInput = $("#qty" + id);
                    qtyInput.val(productQty);

                    // Update price, amount, and discount for the row
                    let priceInput = $("#price" + id);
                    let amountInput = $("#amount" + id);
                    let discInput = $("#disc" + id);

                    let unitPrice = parseFloat(priceInput.val().replace(/,/g, '')) || 0;
                    let discount = parseFloat(discInput.val().replace(/,/g, '')) || 0;

                    amountInput.val(formatter.format((unitPrice - discount) * productQty));

                    return true; // stop further execution
                }
                return false;
            }

            $(document).on("click", ".decrement", function() {
                let id = $(this).prop("id").replace("decrement", "");
                let qtyInput = $("#qty" + id);
                let qty = parseFloat(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                let qtyInput = $("#qty" + id);
                let qty = parseFloat(qtyInput.val());
                let buyingInput = $("#buying" + id);
                let priceInput = $("#price" + id);
                let cont = $("#cont" + id).val();

                let price = parseFloat(priceInput.val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let buying = parseFloat(buyingInput.val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                console.log([qty, cont, price, buying]);

                let amountInput = $("#amount" + id);
                let amount = qty * price;

                amountInput.val(formatter.format(amount)); // Format the value using the format() method

                $("#disc" + id).prop("placeholder", formatter.format(price * qty - (buying * cont *
                    qty))); // Format the value using the format() method

                total(); // Call the total function

                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("keyup", ".qty", function() {
                let qtyInput = $(this);
                let qty = parseFloat(qtyInput.val());
                let id = qtyInput.prop("id").replace("qty", "");
                let categoryCheck = $("#category" + id).val();

                // Assuming available quantity is stored in an element with ID "productQty" + id
                let productQty = parseFloat($("#productQty" + id).val());

                // Only call the warning if category is NOT 'service'
                if (categoryCheck != 'Service') {
                    // Call the warning function to check if qty exceeds productQty
                    if (showLimitedCapacityWarning(qty, productQty, qtyInput)) {
                        return; // Stop further execution if limit is exceeded
                    }
                }
                let price = parseFloat($("#price" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let cont = $("#cont" + id).val();
                let amount = price * qty;

                $("#amount" + id).val(formatter.format(amount));
                $("#disc" + id).prop("placeholder", formatter.format(price * qty - (buying * cont *
                    qty))); // Format the value using the format() method

                total();
            });

            function total() {
                let amount = 0;
                let grandtotal = 0;

                let selectElement = $('#type');
                // Clear any existing options
                selectElement.empty();
                // Add the default option if needed
                selectElement.append(
                    '<option disabled selected value="">-- Choose Type --</option>');
                selectElement.append(
                    '<option value="cash">-- Cash --</option>');
                selectElement.append(
                    '<option value="credit">-- Credit --</option>');

                $("#paid").val(0); // Set the paid value to 0

                // Calculate the total amount by adding up all the amounts in each row of the sale table
                $(".amount").each(function() {
                    amount += parseFloat($(this).val().replace(/,/g, ''),
                        10); // Remove commas and parse as base 10
                });

                amount = formatter.format(amount); // Format the value using the format() method);

                $("#total").val(amount); // Put the total in the total field

                let discount = $("#discount").val() ? parseFloat($("#discount").val().replace(/,/g, '')) :
                    0; // Set the discount value to 0 if it doesn't exist
                let paid = parseFloat($("#paid").val().replace(/,/g, '')); // Get the value of the paid field
                let netTotal = parseFloat(amount.replace(/,/g, ''), 10) - discount; // Calculate the net total

                $("#net").val(formatter.format(netTotal)); // Put the net total in the net field
                $("#due").val(formatter.format(netTotal - paid)); // Put the due in the due field

                saveSalesToLocalStorage(); // Call the function to save sales to local storage
            }

            $("#type").on("change", function() {
                let change = $(this).val();

                // Unselect the selected account
                account = $("#account").val('');
                $("#customer").val('');
                $("#phone").val('');
                $("#address").val('');

                if (change === "cash") {
                    let net = $("#net").val();
                    $("#paid").val(net);
                    $("#due").val(0);
                    $("#account").prop("required", true).fadeIn("slow");
                    $("#customer").prop("required", false);
                    $("#phone").prop("required", false);
                    $("#address").prop("required", false);
                } else if (change === "credit") {
                    let net = $("#net").val();
                    $("#paid").val(0);
                    $("#due").val(net);
                    $("#account").prop("required", false).fadeOut("slow");
                    $("#customer").prop("required", true);
                    $("#phone").prop("required", true);
                    $("#address").prop("required", true);
                }
            });

            $("#account").on("change", function() {
                account = $(this).val();
                if (account == 0) {
                    $("#customer").prop("required", true);
                } else {
                    $("#customer").prop("required", false);
                }
            });

            $("#paid").on("keyup blur", function() {
                // Parse paid amount, remove commas
                let paid = $(this).val() ? parseFloat($(this).val().replace(/,/g, '')) : 0;

                // Update the #paid input with formatted value
                $(this).val(formatter.format(paid));

                // Parse net total
                let net = parseFloat($("#net").val().replace(/,/g, '')) || 0;

                // Calculate due
                let due = net - paid;

                // Toggle account field requirement and visibility
                if (paid > 0) {
                    $("#account").prop("required", true).fadeIn("slow");
                } else {
                    $("#account").prop("required", false).fadeOut("slow");
                }

                // Toggle customer, phone, and address requirement
                if (due !== 0) {
                    $("#customer, #phone, #address").prop("required", true);
                } else {
                    $("#customer, #phone, #address").prop("required", false);
                }

                // Update #due input with formatted value
                $("#due").val(formatter.format(due));
            });

            $(document).on("keyup", ".discount", function() {

                let id = $(this).prop("id").replace("disc", ""); // Remove "price" from the ID

                let disc = $(this).val() ? parseFloat($(this).val().replace(/,/g, ''), 10) :
                    0; // Remove commas and parse as base 10

                $("#disc" + id).val(formatter.format(disc)); // Remove commas and parse as base 10

                discount();
            });

            $(document).on("change", ".unit", function() {
                let unitId = $(this).val();
                let id = $(this).prop("id").replace("unit", "");
                let productId = $("#id" + id).val();
                let qty = $("#qty" + id).val();
                let locationId = $("#location").val();

                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let selling = parseFloat($("#price" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                console.log(productId);

                let row = {
                    index: id,
                    id: $("#id" + id).val(),
                    name: $("#product" + id).val(),
                    unit: '',
                    selected_unit: $("#unit" + id).val(),
                    cont: $("#cont" + id).val(),
                    price: $("#price" + id).val(),
                    qty: $("#qty" + id).val(),
                    disc: $("#disc" + id).val(),
                    amount: $("#amount" + id).val(),
                    total: $("#total").val(),
                }

                let saleDetails = {
                    total: $("#total").val(),
                    discount: $("#discount").val(),
                    net: $("#net").val(),
                    due: $("#due").val(),
                    location: $("#location").val(),
                    locationstatus: $("#locationstatus").val(),
                }

                $.ajax({
                    url: "<?php echo e(route('unit.details')); ?>",
                    method: "get",
                    data: {
                        'unitId': unitId,
                        'productId': productId,
                        'locationId': locationId,
                        'row': row,
                        'details': saleDetails,
                    },

                    success: function(data) {
                        console.log(data.unit_cont);
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(formatter.format(data
                            .selling)); // Remove commas and parse as base 10
                        $("#disc" + id).prop("placeholder", formatter.format(data.selling *
                            qty - (buying * data.unit_cont * qty)
                        )); // Remove commas and parse as base 10
                        $("#amount" + id).val(formatter.format(data.selling *
                            qty)); // Remove commas and parse as base 10
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("keyup", ".price", function() {
                let id = $(this).prop("id").replace("price", ""); // Remove "price" from the ID

                let price = $(this).val() ? parseFloat($(this).val().replace(/,/g, ''), 10) :
                    0; // Remove commas and parse as base 10

                $("#price" + id).val(formatter.format(price)); // Remove commas and parse as base 10

                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                let qty = $("#qty" + id).val();
                let cont = $("#cont" + id).val();

                $("#amount" + id).val(formatter.format(price * qty)); // Remove commas and parse as base 10
                $("#disc" + id).prop("placeholder", formatter.format(price * qty - (buying * cont *
                    qty))); // Remove commas and parse as base 10

                total();
            });

            function discount() {

                let discount = 0;

                $(".discount").each(function() {
                    discount += $(this).val() ? parseFloat($(this).val().replace(/,/g, ''), 10) :
                        0; // Remove commas and parse as base 10
                });

                discount = formatter.format(discount); // Format the value using the format() method);

                $("#discount").val(discount); // Put the discount in the discount field

                total();
            }

            $("#customer").on("keyup", function() {
                let ujumbe = "No suggestions...";
                let query = $(this).val();

                if (query == "") {
                    $("#phone").val("");
                }

                $.ajax({
                    url: "<?php echo e(route('get.customer')); ?>",
                    method: "get",
                    data: {
                        'query': query
                    },
                    success: function(response) {
                        console.log(response);
                        $("#customers").empty();

                        // If somthing is typed.
                        if (query != "") {
                            // If ajax response returns nothing.
                            if (response.length === 0) {
                                $("#customer-list").fadeIn("slow");
                                $("#customers").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');

                                // Hide after 2 seconds
                                setTimeout(function() {
                                    $("#customer-list").fadeOut("slow", function() {
                                        $("#customers")
                                            .empty(); // Optional: clear the message
                                    });
                                }, 2000);
                            }
                            // If ajax response returns sothing.
                            for (var i = 0; i < response.length; i++) {
                                $("#customer-list").fadeIn("slow");
                                $("#customers").append(
                                    '<li><button type="button" class="form-control customernames btn btn-outline-secondary" id="' +
                                    response[i].id + '" phone="' + response[i].phone +
                                    '" address="' + response[i].address + '">' +
                                    response[i].name + '</button></li>');
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".customernames", function() {
                let customerId = $(this).attr('id');
                let customerPhone = $(this).attr('phone');
                let customerAddress = $(this).attr('address');
                let customerName = $(this).html();
                let amount = $("#net").val();
                $("#customer-list").fadeOut("slow");

                if (account == 0) {
                    // Call the function and handle the result
                    checkCustomerAdvance(customerId, amount).then((proceed) => {
                        if (proceed) {
                            $("#customer").val(customerName);
                            $("#phone").val(customerPhone);
                            $("#address").val(customerAddress);
                        }
                    });
                } else {
                    $("#customer").val(customerName);
                    $("#phone").val(customerPhone);
                    $("#address").val(customerAddress);
                }
            });

            function checkCustomerAdvance(customerId, amount) {
                return new Promise((resolve) => {
                    $.ajax({
                        url: "<?php echo e(route('customer.advance.checker')); ?>",
                        method: "get",
                        data: {
                            'customerId': customerId,
                            'amount': amount,
                        },
                        success: function(response) {
                            if (response.hasOwnProperty('response') && response.response ===
                                true) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Insufficient Advance Balance!',
                                    text: "Customer Advance Balance is lower than the amount you are trying to sale.",
                                    showConfirmButton: true,
                                });

                                $("#customer").val('');
                                $("#customer").prop("required", true);

                                resolve(false); // Do not proceed
                            } else {
                                resolve(true); // Proceed with the operation
                            }
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: "An error occurred while checking the advance balance.",
                                showConfirmButton: true,
                            });
                            resolve(false); // Do not proceed
                        }
                    });
                });
            }

            // Save sales to localStorage
            function saveSalesToLocalStorage() {
                let salesData = {};

                // Save table rows
                let rows = [];
                $("#tbody tr").each(function() {
                    let rowId = $(this).attr("id").replace("tr", "");
                    let row = {
                        id: $("#id" + rowId).val(),
                        productName: $(this).text().trim(), // Capture product name from row
                        unit: $("#unit" + rowId).val(),
                        units: $("#unit" + rowId + " option").map(function() {
                            return {
                                id: this.value,
                                name: $(this).text()
                            };
                        }).get(),
                        cont: $("#cont" + rowId).val(),
                        price: $("#price" + rowId).val(),
                        qty: $("#qty" + rowId).val(),
                        amount: $("#amount" + rowId).val(),
                        disc: $("#disc" + rowId).val(),
                        batch_no: $("#batch_no" + rowId).val() || "",
                        exp: $("#exp" + rowId).val() || "",
                        buying: $("#buying" + rowId).val() || 0,
                        category: $("#category" + rowId).val() || "product"
                    };
                    rows.push(row);
                });
                salesData.rows = rows;

                // Save other form data
                salesData.customer = $("#customer").val();
                salesData.phone = $("#phone").val();
                salesData.address = $("#address").val();
                salesData.type = $("#type").val();
                salesData.paid = $("#paid").val();
                salesData.due = $("#due").val();
                salesData.account = $("#account").val();
                salesData.location = $("#location").val();
                salesData.locationstatus = $("#locationstatus").val();
                salesData.total = $("#total").val();
                salesData.discount = $("#discount").val();
                salesData.net = $("#net").val();

                localStorage.setItem("salesData", JSON.stringify(salesData));
                console.log("Sales data saved to localStorage");
            }

            // Restore sales from localStorage
            function restoreSalesFromLocalStorage() {
                let salesData = localStorage.getItem("salesData");
                if (!salesData) return;

                salesData = JSON.parse(salesData);

                // Restore table rows
                if (salesData.rows && salesData.rows.length > 0) {
                    salesData.rows.forEach(row => {
                        // Add the product row
                        addProductToTable({
                            id: row.id,
                            product: row.productName || "Unknown Product",
                            unit: row.units && row.units.length > 0 ? row.units : [{
                                id: row.unit,
                                name: ""
                            }],
                            buying: parseFloat(row.buying) || 0,
                            location_id: salesData.location,
                            totalQty: parseFloat(row.qty) || 0,
                            category: row.category || "product"
                        }, {
                            batch_no: row.batch_no || "",
                            qty: parseFloat(row.qty) || 0,
                            exp: row.exp || ""
                        });

                        let index = $("tbody tr").last().attr("id").replace("tr", "");

                        // Restore unit, qty, price, amount
                        $("#unit" + index).val(row.unit || $("#unit" + index).val());
                        $("#qty" + index).val(row.qty || 1);
                        $("#price" + index).val(row.price || "0");
                        $("#amount" + index).val(row.amount || "0");

                        // Restore discount
                        if (row.disc && row.disc !== "") {
                            $("#disc" + index).val(row.disc); // Use stored discount
                        } else {
                            // If no discount stored, calculate placeholder: (price - buying * cont) * qty
                            let qty = parseFloat($("#qty" + index).val()) || 1;
                            let price = parseFloat($("#price" + index).val().replace(/,/g, '')) || 0;
                            let buying = parseFloat(row.buying) || 0;
                            let cont = parseFloat(row.cont || 1); // default to 1 if missing
                            let calculatedDiscount = (price - buying * cont) * qty;
                            $("#disc" + index).prop("placeholder", calculatedDiscount.toLocaleString());
                        }
                    });
                }

                // Restore customer info
                $("#customer").val(salesData.customer || "");
                $("#phone").val(salesData.phone || "");
                $("#address").val(salesData.address || "");

                // Restore payment info
                $("#type").val(salesData.type || "");
                $("#paid").val(salesData.paid || "0");
                $("#due").val(salesData.due || "0");
                $("#account").val(salesData.account || "");
                $("#location").val(salesData.location || "");
                $("#locationstatus").val(salesData.locationstatus || "");

                // Restore totals
                $("#total").val(salesData.total || "0");
                $("#discount").val(salesData.discount || "0");
                $("#net").val(salesData.net || "0");

                total(); // Recalculate totals
                console.log("Sales data restored from localStorage");
            }

            let salesData = localStorage.getItem("salesData");
            console.log(JSON.parse(salesData));

            // Call restore on page load
            restoreSalesFromLocalStorage();

            // Save when input changes
            $(document).on("change keyup blur", " #search #customer, #phone, #address, #paid, #type, #account",
                function() {
                    saveSalesToLocalStorage();
                });

            // Submit button clears localStorage
            $("#submitBtn").on("click", function() {
                localStorage.removeItem("salesData");
            });

            // Cancel button clears localStorage
            $("#cancel").on("click", function() { // Cancel button
                localStorage.removeItem("salesData");
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/sale.blade.php ENDPATH**/ ?>