<?php $__env->startSection('content'); ?>

    <div class="card table-responsive col-md-10 offset-md-1 p-3">
        <div class="card-header">
            <table>
                <tbody>
                    <tr>
                        <td>
                            <a href="<?php echo e(asset('dist\Products.xls')); ?>" class="btn btn-outline-info"><i
                                    class="fas fa-file-excel fa-lg"></i> First Time stock upload</a>
                        </td>

                        <td>
                            <form action="<?php echo e(route('upload.product.excel')); ?>" onsubmit="showSpinner()" method="post"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-8">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" id="inputGroupFileAddon01">
                                                            <i class="fas fa-file-excel fa-lg"></i>
                                                        </span>
                                                    </div>
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="file"
                                                            name="file" aria-describedby="inputGroupFileAddon01"
                                                            onchange="changeFileFileName(this.files)" required>
                                                        <label class="custom-file-label" for="file">Choose Excel</label>
                                                    </div>
                                                </div>
                                                <script>
                                                    function changeFileFileName(files) {
                                                        var fileLabel = document.querySelector('[for="file"]');
                                                        fileLabel.textContent = files.length > 1 ? (files.length + ' files selected') : files[0].name;
                                                    }
                                                </script>
                                            </div>
                                        </div>

                                        <div class="col"><button type="submit" class="btn btn-outline-success"><i
                                                    class="fas fa-upload fa-lg"></i> Upload Execl</button></div>
                                    </div>
                                </div>
                            </form>
                        </td>

                        <td>
                            <a href="<?php echo e(route('download.rejected.stock.excel')); ?>" class="btn btn-outline-warning"><i
                                    class="fas fa-file-excel fa-lg"></i> Rejected
                                stock</a>
                        </td>

                        <td>
                            <a href="<?php echo e(route('delete.duplicate.products')); ?>" class="btn btn-outline-danger"><i
                                    class="fas fa-trash-alt fa-lg"></i> Delete
                                rejected</a>
                        </td>
                    </tr>
                </tbody>
            </table>

        </div>

        <form action="<?php echo e(route('product.store')); ?>" onsubmit="showSpinner()" method="post" enctype="multipart/form-data"
            class="was-validated">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>

            <div class="card-body px-5">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <?php if($sellingCount > 1): ?>
                            <select name="location" id="location" class="form-control" style="text-align: center" required>
                                <option disabled selected value="">-- Choose Location --</option>
                                <?php $__currentLoopData = $sellings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($selling->location_id); ?>">-- <?php echo e($selling->location->name); ?> --
                                    </option>
                                    <?php $__currentLoopData = $selling->storage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($storage->location_id); ?>">
                                            -- <?php echo e($storage->location->name); ?> --</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php else: ?>
                            <select name="location" id="location" class="form-control" style="text-align: center" required>
                                <option disabled selected value="">-- Choose Location --</option>
                                <option value="<?php echo e($sellings[0]->location_id); ?>">
                                    -- <?php echo e($sellings[0]->location->name); ?> --
                                </option>
                                <?php $__currentLoopData = $sellings[0]->storage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $storage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($storage->location_id); ?>">
                                        -- <?php echo e($storage->location->name); ?> --</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-3">
                        <input type="text" name="product" id="product" class="form-control" placeholder="Product name"
                            style="text-align: center" required>
                    </div>
                    <div class="col-md-3">
                        <input type="text" name="batch" id="batch" class="form-control" placeholder="Batch.No"
                            style="text-align: center" readonly>
                    </div>
                    <div class="col-md-3">
                        <input type="number" name="buying" id="buying" class="form-control" placeholder="Buying price"
                            style="text-align: center" required>
                    </div>
                </div>

                <div class="row mb-3 col-md-12 units-area">
                    <div class="row col-md-12 mb-3">
                        <div class="col-md-4">
                            <select name="unit[]" id="unit0" class="form-control unit" style="text-align: center"
                                required>
                                <option disabled selected value="">--Select Unit --</option>
                                <?php $__currentLoopData = App\Models\Unit::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($unit->id); ?>">-- <?php echo e($unit->name); ?> --</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <input type="number" name="content[]" id="cont0" class="form-control cont"
                                placeholder="content" style="text-align: center" required>
                        </div>
                        <div class="col-md-4">
                            <input type="number" name="selling[]" id="price0" class="form-control selling"
                                placeholder="Selling price" style="text-align: center" required>
                        </div>
                        <button type="button" class="btn btn-outline-info" style="height:35px;width:35px;"
                            id="addRow"><i class="fas fa-plus"></i></button>
                    </div>
                </div>

                <div class="row col-md-12 mb-3">
                    <div class="col-md-4">
                        <select name="minunit" id="minunit" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Minimum Unit --</option>
                            <?php $__currentLoopData = App\Models\unit::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $minunit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($minunit->id); ?>">-- <?php echo e($minunit->name); ?> --</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <input type="number" name="mincont" id="mincont" class="form-control"
                            placeholder="minimum content" style="text-align: center" required readonly>
                    </div>
                    <div class="col-md-4">
                        <input type="number" name="minqty" id="minqty" class="form-control"
                            placeholder="minimum qty" style="text-align: center" required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <input type="text" name="qty" id="qty" class="form-control"
                            placeholder="Available Qty" style="text-align: center" required>
                    </div>
                    <div class="col-md-4">
                        <input type="date" name="exp" id="exp" class="form-control"
                            style="text-align: center">
                    </div>
                    <div class="col-md-4">
                        <select name="expnot" id="expnot" class="form-control" style="text-align: center">
                            <option disabled selected value="">-- Notification --</option>
                            <option value="1">-- 1 month --</option>
                            <option value="2">-- 2 month --</option>
                            <option value="3">-- 3 month --</option>
                        </select>
                    </div>
                </div>

                <div class="row  mb-3">
                    <div class="col-md-3">
                        <select name="category" id="category" class="form-control" style="text-align: center">
                            <option disabled selected value="" required>-- Select Category --</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>">
                                    <?php if($category->name === null): ?>
                                        -- Null --
                                    <?php else: ?>
                                        -- <?php echo e($category->name); ?> --
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <select name="supplier" id="supplier" class="form-control" style="text-align: center">
                            <option disabled selected value=""> -- Choose Supplier --</option>
                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($supplier->id); ?>">-- <?php echo e($supplier->name); ?> --</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <input type="text" name="barcode" id="bar" class="form-control" placeholder="Barcode"
                            style="text-align: center">
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="inputGroupFileAddon01">
                                        <i class="fa fa-image"></i>
                                    </span>
                                </div>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="image" name="image"
                                        aria-describedby="inputGroupFileAddon01"
                                        onchange="changeImageFileName(this.files)">
                                    <label class="custom-file-label" for="image">Choose Image</label>
                                </div>
                            </div>
                            <script>
                                function changeImageFileName(files) {
                                    var fileLabel = document.querySelector('[for="image"]');
                                    fileLabel.textContent = files.length > 1 ? (files.length + ' files selected') : files[0].name;
                                }
                            </script>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card-footer">
                <button class="btn btn-outline-info btn-block"><i class="fa fa-paper-plane fa-lg"></i> Register
                    Product</button>
            </div>
        </form>
    </div>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $("#location").on("change", function() {
                let locationId = $(this).val();

                if (!locationId) return; // skip if no value selected

                $.ajax({
                    url: "<?php echo e(route('check.batch.status')); ?>", // ✅ use route name
                    type: "POST",
                    data: {
                        _token: $('meta[name="csrf-token"]').attr("content"),
                        location_id: locationId
                    },
                    success: function(response) {
                        if (response.batch_no === 1) {
                            // Batch is required, clear value and remove readonly
                            $("#batch")
                                .attr("required", true)
                                .val('')
                                .removeAttr("readonly");
                        } else {
                            // Batch not required, remove required and readonly
                            $("#batch")
                                .removeAttr("required")
                                .attr("readonly", true)
                                .val(''); // optional: clear value
                        }
                    },
                    error: function(xhr) {
                        console.error("Error:", xhr.responseText);
                    }
                });
            });


            $("#category").focus();

            var index = 1;
            var field = 0;

            // add row
            $("#addRow").on("click", function(e) {

                e.preventDefault();

                var tr =

                    '<div class="row mb-3 col-md-12" >' +

                    '<div class="col-md-4">' +
                    '<select name="unit[]" id="unit" class="form-control unit" style="text-align: center" required>' +
                    '<option disabled selected value="">--Select Unit--</option>' +
                    '<?php $__currentLoopData = App\Models\Unit::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>' +
                    '<option value="<?php echo e($unit->id); ?>">-- <?php echo e($unit->name); ?> --</option>' +
                    '<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>' +
                    '</select>' +
                    '</div>' +

                    '<div class="col-md-3">' +
                    '<input type="number" name="content[]" id="" class="form-control cont" placeholder="content" style="text-align: center" required>' +
                    '</div>' +

                    '<div class="col-md-4">' +
                    '<input type="number" name="selling[]" id="" class="form-control selling" placeholder="Selling price" style="text-align: center" required>' +
                    '</div>' +

                    '<button type="button" class="btn btn-outline-danger" id="DeleteRow" style="height:35px!important;width:35px!important;"><i class="fas fa-trash-alt"></i></button>' +

                    '</div>';

                $(".units-area").append(tr);
                index++;
                field++;

            });

            $("body").on("click", "#DeleteRow", function() {
                $(this).parent(".row").remove();
            });

            $("#category").on("change", function() {
                var change = $(this).val();

                if (change == "Menu") {

                    $('#buying').prop('readonly', true);
                    $('#minunit').prop('disabled', true);
                    $('#mincont').prop('readonly', true);
                    $('#minqty').prop('readonly', true);
                    $('#qty').prop('readonly', true);
                    $('#exp').prop('readonly', true);
                    $('#expnot').prop('disabled', true);
                    $('#supplier').prop('readonly', true);
                    $('#bar').prop('readonly', true);

                    $('.unit').prop('readonly', false);
                    $('.cont').prop('readonly', false);
                    $('.selling').prop('readonly', false);

                    $('#addRow').fadeOut("slow");

                } else if (change == "Ingridients") {

                    $('#buying').prop('readonly', false);
                    $('#minunit').prop('disabled', false);
                    $('#mincont').prop('readonly', false);
                    $('#minqty').prop('readonly', false);
                    $('#qty').prop('readonly', false);
                    $('#exp').prop('readonly', false);
                    $('#expnot').prop('disabled', false);
                    $('#supplier').prop('readonly', false);

                    $('.unit').prop('disabled', false);
                    $('.cont').prop('readonly', false);
                    $('.selling').prop('readonly', true);
                    $('#bar').prop('readonly', true);

                    $('#addRow').fadeOut("slow");

                } else {
                    $('#buying').prop('readonly', false);
                    $('#minunit').prop('disabled', false);
                    $('#mincont').prop('readonly', false);
                    $('#minqty').prop('readonly', false);
                    $('#qty').prop('readonly', false);
                    $('#exp').prop('readonly', false);
                    $('#expnot').prop('disabled', false);
                    $('#supplier').prop('readonly', false);

                    $('.unit').prop('disabled', false);
                    $('.cont').prop('readonly', false);
                    $('.selling').prop('readonly', false);
                    $('#bar').prop('readonly', false);

                    $('#addRow').fadeIn("slow");
                }

            });

            $('#minunit').on('change', function() {
                var selectedMinUnit = $(this).val();
                var minContentField = $('#mincont');

                minContentField.val(''); // Clear previous value

                $('.unit').each(function() {
                    if ($(this).val() == selectedMinUnit) {
                        var correspondingContent = $(this).closest('.col-md-4').next().find('.cont')
                            .val();
                        minContentField.val(correspondingContent);
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/products.blade.php ENDPATH**/ ?>