<!DOCTYPE html>


<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"> <!-- Useful for AJAX requests -->
    <title><?php echo e(config('app.name')); ?></title>
    
    <link rel="stylesheet" href="<?php echo e(asset('fonts/font.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('dist/fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dist/fontawesome/css/fontawesome.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dist/fontawesome/css/fontawesome.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('dist/css/adminlte.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/sweetalert2/sweetalert2.min.css')); ?>">
    <!-- Toastr -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/toastr/toastr.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="<?php echo e(asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
    <!-- iCheck -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <!-- JQVMap -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/jqvmap/jqvmap.min.css')); ?>">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/daterangepicker/daterangepicker.css')); ?>">
    <!-- summernote -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/summernote/summernote-bs4.min.css')); ?>">
    <!-- FullCalendar CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fullcalendar/main.min.css')); ?>">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: white;
        }
    </style>
</head>



<body class="hold-transition sidebar-mini layout-fixed">

    <?php
        $businessName = null;
        $locationDetails = processLocationDetails();
        $userSellingLocation = $locationDetails['userSellingLocation'];
        $sellingCount = $locationDetails['sellingCount'];
        if ($userSellingLocation != 'all') {
            $profileData = App\Models\BusinessProfile::where('selling_id', $userSellingLocation)
                ->with('selling.location')
                ->first();
            $businessName = $profileData->selling->location->name ?? 'Business';
        } else {
            $mainData = App\Models\main::with('location')->first();
            $businessName = $mainData->location->name;
        }
    ?>
    <div class="wrapper">
        
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">

            <!-- Menu za juu kushoto -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <h4><a href="#" class="nav-link">
                            <strong> <?php echo e($businessName); ?> </strong>
                        </a></h4>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    
                    <div style="margin-left: 10px;">
                        <?php
                            $remainingTime = getFormattedLicenseRemainingTime();
                        ?>

                        <?php if($remainingTime && $remainingTime !== 'License expired'): ?>
                            <div class="d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>License Remaining:</strong> <?php echo e($remainingTime); ?>

                                </span>
                            </div>
                        <?php elseif($remainingTime === 'License expired'): ?>
                            <div class="alert alert-danger d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>HOSTING & LICENSE HAS EXPIRED!</strong>
                                </span>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>No license dat a found.</strong>
                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                </li>
            </ul>

            <!-- Menu za juu upande kulia ppur-->
            <ul class="navbar-nav ml-auto">

                <!-- Navbar Search -->
                <li class="nav-item">
                    <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                        <i class="fas fa-search"></i>
                    </a>
                    <div class="navbar-search-block">
                        <form class="form-inline">
                            <div class="input-group input-group-sm">
                                <input class="form-control form-control-navbar" type="search" placeholder="Search"
                                    aria-label="Search">
                                <div class="input-group-append">
                                    <button class="btn btn-navbar" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a href="#" class="nav-link"><i class="fa fa-phone fa-lg" aria-hidden="true"></i> (+255 757
                        290 359) For support</a>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                        class="nav-link">
                        <i class="fa fa-sign-out" aria-hidden="true"></i>
                        Logout
                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo e(csrf_field()); ?>

                    </form>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                        <i class="fas fa-expand-arrows-alt"></i>
                    </a>
                </li>
            </ul>

        </nav>
        

        
        <aside class="main-sidebar sidebar-dark-primary elevation-4">

            
            <a href="#" class="brand-link">
                <img src="<?php echo e(asset('dist/img/logo.ico')); ?>" alt="DukaMax Logo"
                    class="brand-image img-circle elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light">Duka | Max</span>
            </a>

            
            <div class="sidebar">

                
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="<?php echo e(asset('dist/img/user.jpg')); ?>" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="#" class="d-block"><?php echo e(auth()->user()->name ?? ''); ?></a>
                    </div>
                </div>

                
                <div class="form-inline">
                    <div class="input-group" data-widget="sidebar-search">
                        <input class="form-control form-control-sidebar" type="search" placeholder="Search"
                            aria-label="Search">
                        <div class="input-group-append">
                            <button class="btn btn-sidebar">
                                <i class="fas fa-search fa-fw"></i>
                            </button>
                        </div>
                    </div>
                </div>

                
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="true">

                        <li class="nav-item">
                            <a href="<?php echo e(route('home')); ?>" class="nav-link">
                                <i class="fa-solid fa-gauge"></i>
                                <p>
                                    Dashboard
                                </p>
                            </a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    <p>
                                        Sale
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('sale.index', ['id' => 0, 'status' => 'sale'])); ?>"
                                            class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Post sale</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('sales.return.view.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-arrow-rotate-left"></i>
                                            <p>Sales return</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('profoma.invoice.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Profoma invoice</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('sales.reciept')); ?>" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Reciepts & delivery</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-cart-arrow-down"></i>
                                    <p>
                                        Purchase
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('purchase.view', ['id' => 0, 'status' => 'purchase'])); ?>"
                                            class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Post purchase</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('purchase.return.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-arrow-rotate-right"></i>
                                            <p>Purchase return</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('supplier.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-people-group"></i>
                                            <p>Suppleir</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('purchase.order.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Purchase order</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('games')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-clipboard-list"></i>
                                    <p>
                                        Customer Order
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('customer.order.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Orders</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('post.expense.index', 1)); ?>" class="nav-link">
                                            <i class="fa-solid fa-dollar"></i>
                                            <p>Expense</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('customer.order.profit.and.loss')); ?>" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Order P & L</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('games')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('game.index')); ?>" class="nav-link">
                                    <i class="fa-solid fa-gamepad"></i>
                                    <p>Games</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expenses')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-dollar-sign"></i>
                                    <p>
                                        Expense
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('post.expense.index', 2)); ?>" class="nav-link">
                                            <i class="fa-solid fa-dollar-sign"></i>
                                            <p>Post Expense</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('expense.category.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-tags"></i>
                                            <p>Expense Category</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('vehicles')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-truck"></i>
                                    <p>
                                        Vehicle
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('vehicle.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-car"></i>
                                            <p>Vehicle</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('driver.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Drivers</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('salesmen.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Sales men</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('load.vehicle.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-truck-loading"></i>
                                            <p>Load vehicle</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('loaded.vehicle')); ?>" class="nav-link">
                                            <i class="fa-solid fa-truck"></i>
                                            <p>Loaded vehicles</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('unload.vehicle.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-truck-loading"></i>
                                            <p>Unload Vehicle</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-brands fa-shopify fa-lg"></i>
                                    <p>
                                        Stock
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('unit.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-ruler"></i>
                                            <p>Units</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('product.category.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-tags"></i>
                                            <p>Category</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('product.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-plus"></i>
                                            <p>New product</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('update.product.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-pencil"></i>
                                            <p>Update</p>
                                        </a>
                                    </li>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('delete.product.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-trash"></i>
                                                <p>Delete</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('damage_stock')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('damage.stock.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-heart-broken"></i>
                                                <p>Damages</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_transfer')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('stock.transfer.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-exchange"></i>
                                                <p>Transfer</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stocklist')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('stock.list.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-list"></i>
                                                <p>Stock list</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pricelist')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('price.list.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-list"></i>
                                                <p>Price list</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('service.index')); ?>" class="nav-link">
                                                <i class="fa-solid fa-wrench"></i>
                                                <p>Services</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_tacking')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('stock.tacking.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-clock"></i>
                                                <p>Stock tacking</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('requisitions')); ?>" class="nav-link">
                                            <i class="fa-solid fa-file-lines"></i>
                                            <p>Requisition</p>
                                        </a>
                                    </li>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('barcode')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('barcode.view')); ?>" class="nav-link">
                                                <i class="fa-solid fa-barcode"></i>
                                                <p>Barcode</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('stock.reset.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-rotate-right"></i>
                                            <p>Stock reset</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('kitchen')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa fa-bowl-food"></i>
                                    <p>
                                        Bar & resturant
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('waiters')): ?>
                                        <li class="nav-item">

                                            <a href="<?php echo e(route('waiters.index')); ?>" class="nav-link">
                                                <i class="fas fa-user-tie nav-icon"></i>
                                                <p>Waiters</p>
                                            </a>

                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tables')): ?>
                                        <li class="nav-item">

                                            <a href="<?php echo e(route('table.index')); ?>" class="nav-link">
                                                <i class="fas fa-table nav-icon"></i>
                                                <p>Table no</p>
                                            </a>

                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ingredients')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('ingredient.index')); ?>" class="nav-link">
                                                <i class="fas fa-pepper-hot nav-icon"></i>
                                                <p>Ingredients</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('menu.index')); ?>" class="nav-link">
                                            <i class="fas fa-hamburger nav-icon"></i>
                                            <p>Food</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('incomming.table.reservation')); ?>" class="nav-link">
                                            <i class="fas fa-calendar-check nav-icon"></i>
                                            <p>Reservation</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('drink.index')); ?>" class="nav-link">
                                            <i class="fas fa-champagne-glasses nav-icon"></i>
                                            <p>Drinks</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('place.oder.index', 'start')); ?>" class="nav-link">
                                            <i class="fas fa-shopping-cart nav-icon"></i>
                                            <p>Place oder</p>
                                        </a>
                                    </li>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cancel_bills')): ?>
                                        <li class="nav-item">

                                            <a href="<?php echo e(route('cancel.order.view')); ?>" class="nav-link">
                                                <i class="fas fa-window-close nav-icon"></i>
                                                <p>Cancel oder</p>
                                            </a>

                                        </li>
                                    <?php endif; ?>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('waiters.bill.view')); ?>" class="nav-link">
                                            <i class="fas fa-coins nav-icon"></i>
                                            <p>Waiters & Tables bills</p>
                                        </a>
                                    </li>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pay_bills')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('pay.bill.view')); ?>" class="nav-link">
                                                <i class="fas fa-file-invoice-dollar nav-icon"></i>
                                                <p>Pay bills</p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accomodation')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-hotel"></i>
                                    <p>
                                        Accomodation
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('rooms.index')); ?>" class="nav-link">
                                            <i class="fas fa-door-open nav-icon"></i>
                                            <p>Rooms</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('booking.index')); ?>" class="nav-link">
                                            <i class="fas fa-clipboard-list nav-icon"></i>
                                            <p>Booking</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('upcoming.bookings')); ?>" class="nav-link">
                                            <i class="fas fa-calendar-plus nav-icon"></i>
                                            <p>Upcomming bookings</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('inside.customers', 'start')); ?>" class="nav-link">
                                            <i class="fas fa-users nav-icon"></i>
                                            <p>In house geusts</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('events')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-calendar-days"></i>
                                    <p>
                                        Events management
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('event.index')); ?>" class="nav-link">
                                            <i class="fas fa-calendar-day nav-icon"></i>
                                            <p>Events</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('venue.index')); ?>" class="nav-link">
                                            <i class="fas fa-map-marker-alt nav-icon"></i>
                                            <p>Venue</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('venue.booking.index')); ?>" class="nav-link">
                                            <i class="fas fa-calendar-check nav-icon"></i>
                                            <p>Bookings</p>
                                        </a>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('upcoming.events')); ?>" class="nav-link">
                                            <i class="fas fa-calendar-plus nav-icon"></i>
                                            <p>Upcomming events</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="<?php echo e(route('inprogress.events')); ?>" class="nav-link">
                                            <i class="fas fa-hourglass-half nav-icon"></i>
                                            <p> In progeress events</p>
                                        </a>

                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('locations')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('location.index')); ?>" class="nav-link">
                                    <i class="fa-solid fa-location-crosshairs"></i>
                                    <p>Location</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('customer.index')); ?>" class="nav-link">
                                    <i class="fa-solid fa-user"></i>
                                    <p>Customer</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounts')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('account.index')); ?>" class="nav-link">
                                    <i class="fa-solid fa-money-check"></i>
                                    <p>Accounts</p>
                                </a>

                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets')): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('asset.index')); ?>" class="nav-link">
                                    <i class="fa-solid fa-chart-simple"></i>
                                    <p>Assets</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('loan')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-landmark"></i>
                                    <p>
                                        Loan
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('creditor.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Creditor</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('debtor.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Debtors</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('recieved.loan.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Loan Details </p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('production')): ?>
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-industry fa-lg"></i>
                                    <p>
                                        Production
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('production.order')); ?>" class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Place Order</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('production.order.progress', 1)); ?>" class="nav-link">
                                            <i class="fa-solid fa-clipboard-check"></i>
                                            <p>Order Progress</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('dispatch')); ?>" class="nav-link">
                                            <i class="fa-solid fa-truck"></i>
                                            <p>Dispatch</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item">

                            <a href="#" class="nav-link">
                                <i class="fa-solid fa-chart-column"></i>
                                <p>
                                    Reports
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('sales.report')); ?>" class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Sales</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('purchases.report.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Purchase</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expenses_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('expense.report.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-money-bill-wave"></i>
                                            <p>Expense</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('customer.debts.report')); ?>" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Customer Debts</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('supplier.debts.report')); ?>" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Supplier Debts</p>
                                    </a>
                                </li>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('stock.report')); ?>" class="nav-link">
                                            <i class="fa-solid fa-box"></i>
                                            <p>Stock</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('vehicle_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('vehicles.report')); ?>" class="nav-link">
                                            <i class="fa-solid fa-car"></i>
                                            <p>Vehicles</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('production.report')); ?>" class="nav-link">
                                        <i class="fa-solid fa-industry fa-lg"></i>
                                        <p>Production</p>
                                    </a>
                                </li>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cash_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('cash.movement.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-coins"></i>
                                            <p>Cash</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('income.report')); ?>" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Profit & Loss</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('income_report')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('accounting.overview')); ?>" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Balance Sheet</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('settlement.report')); ?>" class="nav-link">
                                        <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                        <p>Settlement Report</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="fa-solid fa-address-card"></i>
                                <p>
                                    My Business
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="<?php echo e(route('profile.view')); ?>" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Profile</p>
                                    </a>
                                </li>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ip_setting')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('ip.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-globe-europe"></i>
                                            <p>IP Setting</p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('subscription.index')); ?>" class="nav-link">
                                        <i class="fa-solid fa-calendar-plus"></i>
                                        <p>Renew Subscription</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="<?php echo e(route('pricing')); ?>" class="nav-link">
                                        <i class="fa-solid fa-money-bill-wave"></i>
                                        <p>Pricing</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Admin')): ?>
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-users"></i>
                                    <p>
                                        Users
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('users.view')); ?>" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>System Users</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="<?php echo e(route('user.role.index')); ?>" class="nav-link">
                                            <i class="fa-solid fa-circle-user"></i>
                                            <p>User Rolels</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        <?php endif; ?>

                    </ul>
                </nav>
                

            </div>
            
        </aside>

        
        <div class="content-wrapper">

            <?php echo $__env->make('patial.loading-spinner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            
            <div class="content-header">
                <center>
                    

                    
                    <div id="loading-indicator" class="spinner">
                        <div class="rect1"></div>
                        <div class="rect2"></div>
                        <div class="rect3"></div>
                        <div class="rect4"></div>
                        <div class="rect5"></div>
                    </div>
                </center>
            </div>
            

            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>

        </div>
        

        
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
            <div class="p-3">
                <h5>Title</h5>
                <p>Sidebar content</p>
            </div>
        </aside>
        

        
        <footer class="main-footer hide-on-print">
            <!-- To the right -->
            <div class="float-right d-none d-sm-inline">
                <span style="font-size: 1rem; color: #28a745; font-weight: 500;">
                    Crafted with <i class="fa fa-heart text-danger"></i> by
                    <span style="color: #007bff;">Burton</span>
                    <span class="badge bg-dark" style="font-size: 0.9rem;">#ITMan</span>
                    <a href="https://wa.me/+255786373296" class="badge bg-success" target="_blank"
                        style="margin-left: 8px; text-decoration: none;">
                        <i class="fab fa-whatsapp"></i> WhatsApp
                    </a>
                </span>
            </div>
            <!-- Default to the left -->
            <strong>Copyright &copy;
                <script>
                    document.write(new Date().getFullYear())
                </script> <a href="https://www.dukamax.online" target="_blank">dukamax.online</a>.
            </strong> All rights
            reserved.
        </footer>
    </div>
    

    

    
    <script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo e(asset('plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button)
    </script>
    
    <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- ChartJS -->
    <script src="<?php echo e(asset('plugins/chart.js/Chart.min.js')); ?>"></script>
    <!-- Sparkline -->
    <script src="<?php echo e(asset('plugins/sparklines/sparkline.js')); ?>"></script>
    <!-- JQVMap -->
    <script src="<?php echo e(asset('plugins/jqvmap/jquery.vmap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/jqvmap/maps/jquery.vmap.usa.js')); ?>"></script>
    <!-- jQuery Knob Chart -->
    <script src="<?php echo e(asset('plugins/jquery-knob/jquery.knob.min.js')); ?>"></script>
    <!-- daterangepicker -->
    <script src="<?php echo e(asset('plugins/moment/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/daterangepicker/daterangepicker.js')); ?>"></script>
    <!-- Tempusdominus Bootstrap 4 -->
    <script src="<?php echo e(asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>
    <!-- Summernote -->
    <script src="<?php echo e(asset('plugins/summernote/summernote-bs4.min.js')); ?>"></script>
    <!-- overlayScrollbars -->
    <script src="<?php echo e(asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>
    <!-- FullCalendar JS -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    
    <script src="<?php echo e(asset('plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
    <!-- Toastr -->
    <script src="<?php echo e(asset('plugins/toastr/toastr.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    
    <script src="<?php echo e(asset('dist/js/adminlte.min.js')); ?>"></script>

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>


    <script>
        function showSpinner() {
            // Show spinner to be called on form submission
            document.querySelector('.spinner').style.display = 'block';
        }

        window.addEventListener('load', function() {
            // hide the spinner after the page is loaded
            document.querySelector('.spinner').style.display = 'none';
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $("#data-table").DataTable();
    </script>


    <?php if(session()->has('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                html: `<div style="font-size:1.2rem; color:#155724; font-weight:500;">
                            <?php echo e(session()->get('success')); ?>

                        </div>`,
                background: '#e6ffed',
                showConfirmButton: false,
                timer: 2500,
                timerProgressBar: true,
                position: 'top-end',
                toast: true,
                customClass: {
                    popup: 'swal2-border-radius'
                }
            });
        </script>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Oops!',
                html: `<div style="font-size:1.2rem; color:#721c24; font-weight:500;">
                        <?php echo e(session()->get('error')); ?>

                    </div>`,
                background: '#ffeaea',
                showConfirmButton: false,
                timer: 4000,
                timerProgressBar: true,
                position: 'top-end',
                toast: true,
                customClass: {
                    popup: 'swal2-border-radius'
                }
            });
        </script>
    <?php endif; ?>

    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH D:\Laraval\dukamax\resources\views/layouts/master.blade.php ENDPATH**/ ?>