<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Dukamax POS</title>
    <link rel="stylesheet" href="<?php echo e(asset('dist/fontawesome/css/all.min.css')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Arial', sans-serif;
            background:
                linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)),
                url('<?php echo e(asset('dist/img/pos-background.jpg')); ?>') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            width: 100%;
            max-width: 400px;
        }

        .form-card {
            background: rgba(255, 255, 255, 0.3);
            /* semi-transparent white */
            backdrop-filter: blur(10px);
            /* glassmorphism effect */
            -webkit-backdrop-filter: blur(10px);
            /* Safari support */
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            text-align: center;
            color: #fff;
            /* white text for better contrast */
        }

        .form-card h2 {
            margin-bottom: 1rem;
            color: #333;
        }

        .logo {
            display: block;
            margin: 0 auto 1.2rem;
            width: 120px;
        }

        .input-group {
            position: relative;
            margin-bottom: 1.3rem;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #888;
        }

        .input-group input {
            width: 100%;
            padding: 0.75rem 0.75rem 0.75rem 40px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .input-group input:focus {
            border-color: #6a11cb;
            outline: none;
        }

        .btn {
            width: 100%;
            padding: 0.75rem;
            border: none;
            border-radius: 5px;
            background: #6a11cb;
            color: white;
            font-size: 1rem;
            cursor: pointer;
            transition: background 0.3s;
        }

        .btn:hover {
            background: #2575fc;
        }

        .footer {
            margin-top: 1.2rem;
            color: #555;
            font-size: 0.9rem;
        }

        .footer a {
            color: #6a11cb;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="form-card">
            <img src="<?php echo e(asset('dist/img/logo.ico')); ?>" alt="Logo" class="logo">
            <h2>Dukamax Business Software</h2>
            <p>Welcome back. Please log in to continue.</p><br>

            <form action="<?php echo e(route('login')); ?>" method="POST" class="was-validated">
                <?php echo csrf_field(); ?>

                <div class="input-group">
                    <i class="fas fa-user"></i>
                    <input type="text" name="username" id="username" placeholder="Username" required autofocus>
                </div>

                <div class="input-group">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="password" id="password" placeholder="Password" required>
                </div>

                <button type="submit" class="btn">
                    <i class="fas fa-sign-in-alt"></i> Login
                </button>

                <div class="footer">
                    <p>Don't have an account? <a href="#">Sign Up</a></p>
                </div>
            </form>
        </div>
    </div>
</body>

</html>
<?php /**PATH D:\Laraval\dukamax\resources\views/auth/custom-login.blade.php ENDPATH**/ ?>