<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card shadow">
            <div class="card-header bg-danger text-white">
                <h4 class="mb-0">📉 Products Below Minimum Level</h4>
            </div>
            <div class="card-body p-0">
                <?php if($minimumLevelProducts->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0 table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Current Qty</th>
                                    <th>Minimum Qty</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $minimumLevelProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($item->product->product ?? 'N/A'); ?></td>
                                        <td><span class="badge bg-danger"><?php echo e($item->qty); ?> <?php echo e($item->unit->name ?? 'N/A'); ?></span></td>
                                        <td><?php echo e($item->min_qty); ?></td>
                                        <td><?php echo e($item->product->location->name ?? 'N/A'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="p-3 mb-0">✅ All products are above their minimum stock levels.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Any additional JavaScript can go here
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/minimum-level-product.blade.php ENDPATH**/ ?>