<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group" aria-label="Unit Actions">
                <button type="button" id="deleteall" class="btn btn-danger btn-sm">
                    <i class="fa-solid fa-trash-alt"></i> Delete selected
                </button>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addunit">
                    <i class="fa-solid fa-plus"></i> Add unit
                </button>

                <!-- Modal -->
                <div class="modal fade" id="addunit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add unit</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="<?php echo e(Route('unit.store')); ?>" method="post" class="was-validated">
                                <?php echo csrf_field(); ?>

                                <div class="modal-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover shadow-sm rounded" id="table"
                                            style="background: #f8fafc;">
                                            <thead class="thead-dark text-center">
                                                <tr>
                                                    <th scope="col" style="width:5%; font-size: 1.1rem;">#</th>
                                                    <th scope="col" style="font-size: 1.1rem;">Unit</th>
                                                    <th scope="col" style="width:10%;">
                                                        <button type="button" class="btn btn-success btn-sm" id="addRow"
                                                            title="Add Row">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                                <!-- Dynamic rows will be appended here -->
                                            </tbody>
                                        </table>
                                    </div>
                                    <style>
                                        #table thead th {
                                            background: linear-gradient(90deg, #007bff 0%, #00c6ff 100%);
                                            color: #fff;
                                            border: none;
                                            letter-spacing: 1px;
                                        }

                                        #table tbody tr {
                                            transition: background 0.2s;
                                        }

                                        #table tbody tr:hover {
                                            background: #e9f7fe;
                                        }

                                        #table input[type="text"] {
                                            border-radius: 20px;
                                            border: 1px solid #b3d7ff;
                                            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.03);
                                            text-align: center;
                                            font-weight: 500;
                                        }

                                        #addRow {
                                            box-shadow: 0 2px 6px rgba(0, 123, 255, 0.15);
                                        }

                                        .removeRow {
                                            border-radius: 50%;
                                            transition: background 0.2s;
                                        }

                                        .removeRow:hover {
                                            background: #ffebee;
                                            color: #d32f2f;
                                        }
                                    </style>
                                </div>

                                <div class="modal-footer">
                                    <div class="btn-group" role="group" aria-label="Unit Actions">
                                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i
                                                class="fa fa-times"></i> Close</button>
                                        <button type="submit" class="btn btn-primary btn-sm"> <i
                                                class="fa fa-paper-plane"></i>
                                            Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <div class="table-responsive">
                <table class="table table-striped table-bordered align-middle shadow-sm" id="data-table">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width:5%; text-align: center; vertical-align: middle;">
                                <input type="checkbox" id="checkall" class="form-check-input m-0"
                                    style="display: block; margin: 0 auto;">
                            </th>
                            <th style="width: 5%; text-align: center; vertical-align: middle;">S/N</th>
                            <th style="text-align: center; vertical-align: middle;">Unit Name</th>
                            <th style="width: 25%; text-align: center; vertical-align: middle;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td style="text-align: center; vertical-align: middle;">
                                    <input type="checkbox" class="selected form-check-input m-0" id="<?php echo e($unit->id); ?>"
                                        style="display: block; margin: 0 auto;">
                                </td>
                                <td style="text-align: center; vertical-align: middle;">
                                    <span class="badge badge-secondary"><?php echo e($loop->iteration); ?></span>
                                </td>
                                <td style="text-align: center; vertical-align: middle;">
                                    <span class="font-weight-bold text-capitalize"><?php echo e($unit->name); ?></span>
                                </td>
                                <td style="text-align: center; vertical-align: middle;">
                                    <div class="btn-group" role="group">
                                        <!-- Delete Button -->
                                        <button class="btn btn-danger btn-sm delete" id="<?php echo e($unit->id); ?>">
                                            <i class="fa fa-trash-alt"></i>
                                            <span class="d-none d-md-inline">Delete</span>
                                            <form action="<?php echo e(route('unit.destroy', $unit->id)); ?>" method="GET"
                                                id="deleteform<?php echo e($unit->id); ?>">
                                            </form>
                                        </button>

                                        <!-- Edit Button -->
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-<?php echo e($unit->id); ?>">
                                            <i class="fa-solid fa-pen-to-square"></i>
                                            <span class="d-none d-md-inline">Edit</span>
                                        </button>

                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-<?php echo e($unit->id); ?>" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content border-0 shadow">
                                                    <div class="modal-header bg-primary text-white">
                                                        <h5 class="modal-title">Edit Unit</h5>
                                                        <button type="button" class="close text-white"
                                                            data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('unit.update', $unit->id)); ?>" method="post"
                                                        class="was-validated">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="unit-name-<?php echo e($unit->id); ?>">Unit
                                                                    Name</label>
                                                                <input type="text" name="name"
                                                                    id="unit-name-<?php echo e($unit->id); ?>"
                                                                    value="<?php echo e($unit->name); ?>" class="form-control"
                                                                    required>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-primary btn-block">
                                                                <i class="fa fa-paper-plane"></i> Save updates
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End Edit Modal -->
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Units Found</h5>
                                        <p class="text-muted mb-0">You haven't added any Units yet.<br>
                                            <span class="small">Click <strong>Register Unit</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <script type="text/javascript">
            $(document).ready(function() {
                var index = 1;

                // add row
                $("#addRow").on("click", function(e) {
                    e.preventDefault();

                    var tr = ` 
                                <tr id="tr${index}">
                                    <td class="text-center">${index}</td>
                                    <td>
                                    <input 
                                        type="text" 
                                        name="name[]" 
                                        class="form-control text-center" 
                                        placeholder="Enter unit name" 
                                        required
                                    >
                                    </td>
                                    <td class="text-center">
                                    <button 
                                        type="button" 
                                        id="${index}" 
                                        class="btn btn-danger removeRow"
                                    >
                                        <i class="fa fa-trash-alt"></i>
                                    </button>
                                    </td>
                                </tr> 
                            `;

                    $("#tbody").append(tr);
                    index++;

                    $(".removeRow").on("click", function() {

                        var id = $(this).attr("id");

                        $("#tr" + id).remove();
                    });

                });

                $("#checkall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".selected").prop('checked', true);
                    } else {
                        $(".selected").prop('checked', false);
                    }
                });

                $("#deleteall").on("click", function() {
                    var selected = [];
                    $(".selected:checked").each(function() {
                        selected.push($(this).attr("id"));
                    });

                    if (selected.length == 0) {

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Select atleast one item!!',
                        });

                    } else {

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "<?php echo e(route('units.bulk.delete')); ?>",
                                    method: "GET",
                                    data: {
                                        'ids': selected
                                    },
                                    success: function(data) {
                                        window.location.reload(true);
                                    }
                                });

                                $(document).ready(function() {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: 'Deleted successfully.',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                });
                            }
                        });

                    }

                });

                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });

            });
        </script>
    <?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/units.blade.php ENDPATH**/ ?>