<?php $__env->startSection('content'); ?>
    <style>
        .small-box {
            border-radius: 0.75rem;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            color: #fff !important;
            position: relative;
            overflow: hidden;
        }

        .small-box .inner {
            padding: 10px;
        }

        .small-box .icon {
            position: absolute;
            top: 10px;
            right: 15px;
            z-index: 0;
            font-size: 60px;
            opacity: 0.2;
        }

        .small-box-footer {
            background: rgba(0, 0, 0, 0.1);
            display: block;
            padding: 5px;
            border-radius: 0 0 0.75rem 0.75rem;
            color: #fff;
            text-decoration: none;
        }

        /* Optional: Add gradient or custom colors */
        .bg-info {
            background: linear-gradient(135deg, #17a2b8, #138496);
        }

        .bg-danger {
            background: linear-gradient(135deg, #dc3545, #c82333);
        }

        .bg-success {
            background: linear-gradient(135deg, #28a745, #218838);
        }

        .bg-warning {
            background: linear-gradient(135deg, #ffc107, #e0a800);
            color: #212529 !important;
        }

        .bg-primary {
            background: linear-gradient(135deg, #007bff, #0069d9);
        }

        .bg-secondary {
            background: linear-gradient(135deg, #6c757d, #5a6268);
        }

        .bg-teal {
            background: linear-gradient(135deg, #20c997, #17a589);
        }

        .bg-pink {
            background: linear-gradient(135deg, #e83e8c, #d63384);
        }
    </style>

    <div class="card">
        <div class="card-header">
            <h1 class="card-title display-4">
                <strong>Welcome Back</strong>, <?php echo e(Auth::user()->name); ?>

            </h1>
        </div>

        <div class="card-body">
            <div class="container-fluid">
                <!-- Small boxes (Stat box) -->
                <div class="row">
                    <!-- Total Sales -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3><?php echo e(number_format($totalSales)); ?></h3>
                                <p>Total sales</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-cash-register"></i>
                            </div>
                            <a href="<?php echo e(route('get.sales.report')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Total Expense -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h3><?php echo e(number_format($totalExpenses)); ?></h3>
                                <p>Total expenses</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <a href="<?php echo e(route('expense.report')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Total Purchases -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3><?php echo e(number_format($totalPurchases)); ?></h3>
                                <p>Total Purchases</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <a href="<?php echo e(route('get.purchases.report')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Pending Debts -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3><?php echo e(number_format($totalDue)); ?></h3>
                                <p>Pending Balance </p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-exclamation-circle"></i>
                            </div>
                            <a href="<?php echo e(route('sales.report.pending.debts', [$sellingId, 'today', '-', '-'])); ?>"
                                class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                </div>
                <!-- /.row -->

                <!-- Small boxes (Stat box) -->
                <div class="row">
                    <!-- Requisition -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-primary">
                            <div class="inner">
                                <h3><?php echo e($requisitionCount); ?></h3>
                                <p>Requisition Orders</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-ban"></i>
                            </div>
                            <a href="<?php echo e(route('requisitions')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Products missing Prices -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-secondary">
                            <div class="inner">
                                <h3><?php echo e(number_format($itemsMissingPriceCount)); ?></h3>
                                <p>Products missing Prices</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-question-circle"></i>
                            </div>
                            <a href="<?php echo e(route('items.missing.prices', $sellingId)); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Minimum Products -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-teal">
                            <div class="inner">
                                <h3><?php echo e(number_format($minimumLevelProductsCount)); ?></h3>
                                <p>Minimum Products </p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-layer-group"></i>
                            </div>
                            <a href="<?php echo e(route('minimum.level.products')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- Expired Products -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-pink">
                            <div class="inner">
                                <h3><?php echo e($expiredItemsCount); ?></h3>
                                <p>Expired Products</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-calendar-times"></i>
                            </div>
                            <a href="<?php echo e(route('expired.products')); ?>" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                </div>
                <!-- /.row -->

                <!-- Main row -->
                <div class="row">
                    <!-- Left col -->
                    <section class="col-lg-6 connectedSortable">
                        <!-- CUSTOMER DEBTS -->
                        <div class="card direct-chat direct-chat-primary">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fas fa-user"></i> Customer Debts</h3>

                                <div class="card-tools">
                                    <a href="<?php echo e(route('customer.debts.report')); ?>"><span title="3 New Messages"
                                            class="badge badge-secondary"><i class="fa fa-eye fa-lg"></i></span></a>
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <!-- Conversations are loaded here -->
                                <table class="table table-bordered table-striped table-hover">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th style="width: 5%; text-align: center;">#</th>
                                            <th style="width: 60%;">Customer Name</th>
                                            <th style="width: 35%; text-align: right;">Due Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($customerDebts->isEmpty()): ?>
                                            <tr>
                                                <td colspan="3" class="text-center py-5">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                                            alt="No Data" style="width: 80px; opacity: 0.5;">
                                                        <h6 class="mt-3 text-secondary">No Data To Dispaly
                                                        </h6>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <?php $__currentLoopData = $customerDebts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $debt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($debt->due > 0): ?>
                                                    <tr>
                                                        <td style="text-align: center;"><?php echo e($index + 1); ?></td>
                                                        <td><?php echo e($debt->customer->name ?? 'null'); ?></td>
                                                        <td style="text-align: right; font-weight: bold; color: #dc3545;">
                                                            <?php echo e(number_format($debt->due)); ?>

                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <!--/.direct-chat-messages-->

                                <!-- Contacts are loaded here -->
                                <div class="direct-chat-contacts">
                                    <ul class="contacts-list">
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user1-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Count Dracula
                                                        <small class="contacts-list-date float-right">2/28/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">How have you been? I was...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user7-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Sarah Doe
                                                        <small class="contacts-list-date float-right">2/23/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">I will be waiting for...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user3-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Nadia Jolie
                                                        <small class="contacts-list-date float-right">2/20/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">I'll call you back at...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user5-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Nora S. Vans
                                                        <small class="contacts-list-date float-right">2/10/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Where is your new...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user6-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        John K.
                                                        <small class="contacts-list-date float-right">1/27/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Can I take a look at...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                        <li>
                                            <a href="#">
                                                <img class="contacts-list-img" src="dist/img/user8-128x128.jpg"
                                                    alt="User Avatar">

                                                <div class="contacts-list-info">
                                                    <span class="contacts-list-name">
                                                        Kenneth M.
                                                        <small class="contacts-list-date float-right">1/4/2015</small>
                                                    </span>
                                                    <span class="contacts-list-msg">Never mind I found...</span>
                                                </div>
                                                <!-- /.contacts-list-info -->
                                            </a>
                                        </li>
                                        <!-- End Contact Item -->
                                    </ul>
                                    <!-- /.contacts-list -->
                                </div>
                                <!-- /.direct-chat-pane -->
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                
                            </div>
                            <!-- /.card-footer-->
                        </div>
                        <!--/.CUSTOMER DEBTS -->
                        <!-- /.card -->

                        <!-- Fast Moving Items -->
                        <div class="card direct-chat direct-chat-primary">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fas fa-rocket"></i> Fast Moving Products (Monthly)</h3>

                                <div class="card-tools">
                                    
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    
                                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- /.card-header -->

                            <div class="card-body">
                                <!-- Conversations are loaded here -->
                                <table class="table table-bordered table-hover table-striped text-center">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th style="width: 5%;">#</th>
                                            <th style="width: 40%;">Product Name</th>
                                            <th style="width: 15%;">QTY</th>
                                            <th style="width: 20%;">Price</th>
                                            <th style="width: 20%;">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($topMovingProducts->isEmpty()): ?>
                                            <tr>
                                                <td colspan="5" class="text-center py-5">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                                            alt="No Data" style="width: 80px; opacity: 0.5;">
                                                        <h6 class="mt-3 text-secondary">No Data To Dispaly
                                                        </h6>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <?php $__currentLoopData = $topMovingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($index + 1); ?></td>
                                                    <td><?php echo e($item->name); ?></td>
                                                    <td><?php echo e(number_format($item->total_qty)); ?> <?php echo e($item->unit); ?></td>
                                                    <td><?php echo e(number_format($item->price)); ?></td>
                                                    <td><?php echo e(number_format($item->total_amount)); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <!--/.direct-chat-messages-->
                            </div>

                            <!-- /.card-body -->
                            <div class="card-footer">

                            </div>
                            <!-- /.card-footer-->
                        </div>
                        <!--/.Fast Moving Products -->
                    </section>
                    <!-- /.Left col -->

                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Admin')): ?>
                        <!-- right col (We are only adding the ID to make the widgets sortable)-->
                        <section class="col-lg-6 connectedSortable">
                            <!-- SUPPLIER DEBTS -->
                            <div class="card direct-chat direct-chat-primary">
                                <div class="card-header">
                                    <h3 class="card-title"><i class="fas fa-user"></i> Supplier Debts</h3>

                                    <div class="card-tools">
                                        <a href="<?php echo e(route('supplier.debts.report')); ?>"><span title="3 New Messages"
                                                class="badge badge-secondary"><i class="fa fa-eye fa-lg"></i></span></a>
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.card-header -->

                                <div class="card-body">
                                    <!-- Conversations are loaded here -->
                                    <table class="table table-bordered table-hover table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th style="width: 5%; text-align: center;">#</th>
                                                <th style="width: 60%;">Supplier Name</th>
                                                <th style="width: 35%; text-align: right;">Due Balance</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if($supplierDebts->isEmpty()): ?>
                                                <tr>
                                                    <td colspan="3" class="text-center py-5">
                                                        <div class="d-flex flex-column align-items-center">
                                                            <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                                                alt="No Data" style="width: 80px; opacity: 0.5;">
                                                            <h6 class="mt-3 text-secondary">No Data To Dispaly
                                                            </h6>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php else: ?>
                                                <?php $__currentLoopData = $supplierDebts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $debt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($debt->due > 0): ?>
                                                        <tr>
                                                            <td style="text-align: center;"><?php echo e($index + 1); ?></td>
                                                            <td><?php echo e($debt->supplier->name); ?></td>
                                                            <td style="text-align: right; font-weight: bold; color: #dc3545;">
                                                                <?php echo e(number_format($debt->due, 2)); ?>

                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                    <!--/.direct-chat-messages-->
                                </div>
                                <!-- /.card-body -->

                                <div class="card-footer">
                                    
                                </div>
                                <!-- /.card-footer-->
                            </div>
                            <!--/.SUPPLIER DEBTS -->
                            <!-- /.card -->
                        </section>
                    <?php endif; ?>
                    <!-- /.Left col -->
                    <!-- /.row (main row) -->
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.container-fluid -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laraval\dukamax\resources\views/home.blade.php ENDPATH**/ ?>