<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\QRController;
use App\Http\Controllers\Api\TableReservationApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/qr-products', [ProductController::class, 'getQRProducts']);

# QR Code Routes
Route::post('/receive-order', [QRController::class, 'receiveOrder']);
Route::get('/get-tables', [QRController::class, 'getTables']);

# Website routes
Route::post('/reservations', [TableReservationApiController::class, 'store']);
