<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        #receipt {
            max-width: 500px;
            margin: 0 auto;
            border: 2px solid #333;
            padding: 20px;
            font-family: Arial, sans-serif;
            background-color: #fff;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header img {
            max-height: 80px;
            margin-bottom: 10px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }

        .header p {
            margin: 0;
            font-size: 16px;
        }

        .body {
            margin-bottom: 40px;
            text-align: center;
        }

        .body h6 {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }

        .footer {
            text-align: center;
        }

        .footer p {
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }

        .footer p:last-of-type {
            margin-top: 10px;
            font-weight: normal;
            color: #888;
        }
    </style>

    {{-- Theme style --}}
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
</head>

<div id="receipt">

    <div class="header">
        <img src="https://example.com/logo.png" alt="Company Logo">
        <h2>{{ $profile->name }}</h2>
        <p>{{ $profile->address }}</p>
        <p>{{ $profile->phone }} @if ($profile->email)
                | {{ $profile->email }}
            @endif
        </p>
        <p>Date: {{ $current_booking->created_at }} </p>
        @if ($current_booking->customer)
            <p>Received from: {{ $current_booking->customer }}</p>
        @endif
        <p>Reciept #: 00{{ $current_booking->id }}</p>
    </div>

    <div class="body">

        <h6>Sales Receipt</h6>

        <table class="table table-stripped">

            <thead>
                <th>#</th>
                <th>Service</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Amount</th>
            </thead>

            <tbody>

                <tr>
                    <td>1</td>
                    <td>Event ({{ $current_booking->event }})</td>
                    <td>1</td>
                    <td>{{ $current_booking->eprice }}</td>
                    <td>{{ $current_booking->eprice }}</td>
                </tr>

                <tr>
                    <td>2</td>
                    <td>Venue ({{ $current_booking->venue }})</td>
                    <td>1</td>
                    <td>{{ $current_booking->vprice }}</td>
                    <td>{{ $current_booking->vprice }}</td>
                </tr>

                <tr>
                    <td colspan="3"></td>
                    <td>Total</td>
                    <td>{{$current_booking->total }}</td>
                </tr>

                @if ($current_booking->discount)
                    <tr>
                        <td colspan="3"></td>
                        <td>Discount</td>
                        <td>-{{ $current_booking->discount }}</td>
                    </tr>
                @endif

                <tr>
                    <td colspan="3"></td>
                    <td><b>Net</b></td>
                    <td><b>{{ $current_booking->net }}</b></td>
                </tr>
            </tbody>

        </table>

    </div>

    <div class="footer">
        <p>Thank you for your business!</p>

        @if ($profile->slogan)
            <p>Refund policy: All sales are final.</p>
        @endif

        <p>Powered by: Dukamax Business Software.</p>
    </div>

</div>
<script>
    window.print()

    document.getElementById("receipt").onclick = function() {
        window.location.href = "{{ route('venue.booking.index') }}"
    };
</script>

</html>
