@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h3 class="card-title">Vehicle report..</h3>
            </div>

            <div class="card-body">

                <table id="example1" class="table table-striped" style="text-align: center;">

                    <thead>

                        <tr>
                            <th>Load Date</th>
                            <th>Vehicle</th>
                            <th>Driver</th>
                            <th>Salesmen</th>
                            <th>Load Value</th>
                            <th>Status</th>
                            <th>unload Date</th>
                            <th>Unload Value</th>
                        </tr>

                    </thead>

                    <tbody>
                        @foreach ($loads as $load)
                            @php
                                $unloads = App\Models\UnloadVehicle::where('load_vehicle_id', $load->id)->get();
                                foreach ($unloads as $unload) {
                                    $unloaddate = $unload->date;
                                    $unloadvalue = $unload->unloadedvalue;
                                    $unloadid = $unload->id;
                                }
                            @endphp
                            <tr>
                                <td>{{ $load->date }}</td>
                                <td>{{ $load->vehicle }}</td>
                                <td>{{ $load->driver }}</td>
                                <td>{{ $load->salesman }}</td>
                                <td>
                                    <a href="" data-toggle="modal"
                                        data-target="#load-{{ $load->id }}">{{ $load->total }}</a>

                                    <div class="modal fade" id="load-{{ $load->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-body">

                                                    <h5>Loaded items</h5>
                                                    <table class="table table-striped" style="text-align: center;">

                                                        <thead>

                                                            <tr>
                                                                <th>Product</th>
                                                                <th>Unit</th>
                                                                <th>Cont</th>
                                                                <th>Price</th>
                                                                <th>Qty</th>
                                                                <th>Amount</th>
                                                            </tr>

                                                        </thead>

                                                        <tbody>
                                                            @php
                                                                $loadeditems = App\Models\LoadedItems::where('load_vehicle_id', $load->id)->get();
                                                            @endphp

                                                            @foreach ($loadeditems as $loadeditem)
                                                                <tr>
                                                                    <td>{{ $loadeditem->product }}</td>
                                                                    <td>{{ $loadeditem->unit }}</td>
                                                                    <td>{{ $loadeditem->cont }}</td>
                                                                    <td>{{ $loadeditem->price }}</td>
                                                                    <td>{{ $loadeditem->qty }}</td>
                                                                    <td>{{ $loadeditem->amount }}</td>
                                                                </tr>
                                                            @endforeach
                                                            <tr>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td><b>Total</b></td>
                                                                <td>{{ $load->total }}</td>
                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                                <div class="modal-footer">

                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </td>
                                <td>{{ $load->status }}</td>
                                <td>{{ $unloaddate }}</td>
                                <td>
                                    <a href="" data-toggle="modal" data-target="#unload-{{ $unloadid }}">
                                        {{ $unloadvalue }} </a>

                                    <div class="modal fade" id="unload-{{ $unloadid }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-body">

                                                    <h5>Unloaded items</h5>
                                                    <table class="table table-striped" style="text-align: center;">

                                                        <thead>

                                                            <tr>
                                                                <th>Product</th>
                                                                <th>Unit</th>
                                                                <th>Cont</th>
                                                                <th>Price</th>
                                                                <th>Qty</th>
                                                                <th>Amount</th>
                                                            </tr>

                                                        </thead>

                                                        <tbody>
                                                            @php
                                                                $unloadeditems = App\Models\UnloadedItems::where('unload_vehicle_id', $unloadid)->get();
                                                            @endphp

                                                            @foreach ($unloadeditems as $unloadeditem)
                                                                <tr>
                                                                    <td>{{ $unloadeditem->product }}</td>
                                                                    <td>{{ $unloadeditem->unit }}</td>
                                                                    <td>{{ $unloadeditem->cont }}</td>
                                                                    <td>{{ $unloadeditem->price }}</td>
                                                                    <td>{{ $unloadeditem->qty }}</td>
                                                                    <td>{{ $unloadeditem->amount }}</td>
                                                                </tr>
                                                            @endforeach
                                                            <tr>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td>&nbsp</td>
                                                                <td><b> Total </b></td>
                                                                <td>{{ $unload->unloadedvalue }}</td>
                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                                <div class="modal-footer">

                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Load Date</th>
                            <th>Vehicle</th>
                            <th>Driver</th>
                            <th>Salesmen</th>
                            <th>Load Value</th>
                            <th>Status</th>
                            <th>unload Date</th>
                            <th>Unload Value</th>
                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            $("#type").on("change", function() {
                var change = $(this).val();

                if (change == "opening & closing") {
                    $("#start").fadeIn("slow");
                    $("#end").fadeIn("slow");
                } else {
                    $("#start").fadeOut("slow");
                    $("#end").fadeOut("slow");
                }
            });

        });
    </script>
@endsection

@endsection
