@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card card-primary">

            <form action="{{ route('update.room.price', $id) }}" method="get">

                <div class="card-header">
                    <h5 class="card-title">Update {{ $roomname }} price.</h5>
                </div>

                <div class="card-body">

                    <table class="table table-striped" style="text-align: center">

                        <thead style="text-align: center">
                            <th>Pax</th>
                            <th>Price</th>
                            <th>Action</th>
                        </thead>

                        <tbody id="tbody">

                            @foreach ($roomprices as $roomprice)
                                <tr>
                                    <td><input type="number" name="pax[]" value="{{ $roomprice->pax }}"
                                            class="form-control" style="text-align: center"></td>

                                    <td><input type="number" name="price[]" value="{{ $roomprice->price }}"
                                            class="form-control" style="text-align: center"></td>

                                    <td><a href="{{ route('delete.room.price', $roomprice->id) }}" class="btn btn-danger">
                                            <i class="fa fa-trash fa-lg" aria-hidden="true"></i></a></td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                </div>

                <div class="card-footer">
                    <center>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </center>
                </div>

            </form>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#customer").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                alert("please select at least one items!!");
            } else {
                if (confirm("Are you sure..")) {
                    $.ajax({
                        url: "{{ route('rooms.bulk.delete') }}",
                        method: "GET",
                        data: {
                            'ids': selected
                        },
                        success: function(data) {
                            window.location.reload(true);
                        }
                    });
                }

            }

        });

        {{--  var index = 0;
        // add row
        $("#addRow").on("click", function() {
            var tr =

                '<tr id="tr' + index + '">' +

                '<td><input type="text" value="" name="pax[]" id="pax' + index +
                '" class="form-control pax" style="text-align: center" required></td>' +

                '<td><input type="text" value="" name="price[]" id="price' + index +
                '" class="form-control price" style="text-align: center" required></td>' +

                '</td>' +

                '<td><button type="button" id="' + index + '" class="btn btn-danger removeRow">-</button></td>' +

                '</tr>';

            $("#tbody").append(tr);
            index++;

            $(".removeRow").on("click", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
            });
        });  --}}
    </script>
@endsection

@endsection
