<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Transfer Slip</title>
    <style>
        /* General body */
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
            font-size: 10px;
            line-height: 1.2;
            width: 80mm;
            color: #000;
        }

        @page {
            size: 80mm auto;
            margin: 0;
        }

        header {
            text-align: center;
            margin-bottom: 5px;
        }

        #logo {
            width: 50%;
            display: block;
            margin: 0 auto 5px;
        }

        h1 {
            font-size: 12px;
            margin: 2px 0;
        }

        .company-info,
        .receipt-info {
            text-align: center;
            margin-bottom: 5px;
        }

        .company-info span,
        .receipt-info span {
            display: block;
            font-size: 9px;
        }

        .highlight {
            font-weight: bold;
            font-size: 11px;
        }

        .line {
            border-top: 1px dashed #000;
            margin: 2px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 5px;
        }

        table th,
        table td {
            padding: 3px 0;
            vertical-align: middle;
        }

        table th {
            font-size: 10px;
            text-align: center;
        }

        table td {
            font-size: 10px;
        }

        .item-name {
            text-align: left;
            width: 40%;
        }

        .from-to {
            text-align: center;
            width: 20%;
        }

        .qty {
            text-align: right;
            width: 15%;
        }

        section {
            text-align: center;
            margin-top: 5px;
        }

        footer {
            text-align: center;
            font-size: 8px;
            margin-top: 3px;
        }

        /* Highlight batch numbers */
        .batch-no {
            font-size: 9px;
            color: #555;
        }

        .qty-container {
            display: flex;
            justify-content: flex-end;
            gap: 2px;
        }

        .qty-container span {
            font-size: 10px;
        }
    </style>
</head>

<body id="body">
    <header>
        <img id="logo" src="{{ asset('logo.png') }}" alt="Logo">
        <div class="company-info">
            <span class="highlight">{{ $profileData->name }}</span>
            <span>{{ $profileData->address }}</span>
            <span>{{ $profileData->phone }}</span>
        </div>
        <div class="receipt-info">
            <span>Date: {{ \Carbon\Carbon::parse($flag)->format('d-m-Y H:i') }}</span>
            <span class="highlight">TRANSFER SLIP</span>
        </div>
        <div class="line"></div>
    </header>

    <table>
        <thead>
            <tr>
                <th>SN</th>
                <th class="item-name">Item</th>
                <th class="from-to">From</th>
                <th class="from-to">To</th>
                <th class="qty">Qty</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transferedItems as $item)
                @php
                    $from = App\Models\Location::find($item->from);
                    $to = App\Models\Location::find($item->to);
                @endphp
                <tr>
                    <td style="text-align:center;">{{ $loop->iteration }}</td>
                    <td class="item-name">
                        {{ $item->product->product }}
                        @if ($item->batch_no)
                            <div class="batch-no">Batch: {{ $item->batch_no }}</div>
                        @endif
                    </td>
                    <td class="from-to">{{ $from->name ?? '-' }}</td>
                    <td class="from-to">{{ $to->name ?? '-' }}</td>
                    <td class="qty">
                        <div class="qty-container">
                            <span>{{ number_format($item->qty / $item->cont) }}</span>
                            <span>{{ $item->unit->name }}</span>
                            @if ($item->cont > 1)
                                <span>(x{{ $item->cont }})</span>
                            @endif
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="line"></div>

    <section>
        <p class="highlight">Thank you for using Dukamax Business Software</p>
    </section>

    <footer>
        <p>Powered by Dukamax Business Software</p>
    </footer>

    <script>
        window.print();
        window.onload = function() {
            document.getElementById("body").onclick = function() {
                window.close();
                window.location.href =
                    "{{ route('stock.transfer.view', ['success', 'Successfully Transferred.']) }}";
            }
        };
    </script>
</body>

</html>
