@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5 class="text-black-50">Tables</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h3 class="card-title">Customers whose return dates is today</h3>
            </div>

            <div class="card-body">

                <table id="example1" class="table table-bordered table-striped" style="text-align: center;">

                    <thead>


                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Due amount</th>
                            <th>Action</th>
                        </tr>

                    </thead>

                    <tbody>

                        @foreach ($today as $data)
                            <tr>
                                <td>{{ $data->loan->date }}</td>
                                <td>{{ $data->loan->customer }}</td>
                                <td>{{ $data->loan->dueamount }}</td>
                                <td>Action</td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Due amount</th>
                            <th>Action</th>
                        </tr>

                    </tfoot>

                </table>

            </div>
        </div>
        
    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
    </script>
@endsection

@endsection
