@extends('layouts.bar-layout')

@section('title', 'Table - Reservations')

@push('styles')
    <style>
        body {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)),
                url('https://images.unsplash.com/photo-1565299624946-b28f40a0ae38') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            font-family: Arial, sans-serif;
        }

        .reservation-card {
            background: rgba(255, 255, 255, 0.12);
            /* Transparent white */
            backdrop-filter: blur(12px);
            /* Glass effect */
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: #fff;
            transition: all 0.3s ease;
            border-radius: 15px;
            overflow: hidden;
        }

        .reservation-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 28px rgba(0, 0, 0, 0.4);
        }

        .status-badge {
            font-size: 0.8rem;
            padding: 0.35em 0.7em;
            border-radius: 10px;
        }

        /* Make icons visible and stylish */
        .reservation-card i {
            color: #fff;
            background: rgba(255, 255, 255, 0.15);
            padding: 6px;
            border-radius: 50%;
            margin-right: 8px;
            transition: 0.3s;
        }

        .reservation-card i:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Improve button look */
        .btn-sm {
            font-weight: 600;
        }
    </style>
@endpush

@section('content')
    <div class="container-fluid py-3">
        <h2 class="text-center mb-3 fw-bold text-light">🍽 Incoming Table Reservations</h2>

        <div class="row g-4">
            @foreach ($reservations as $reservation)
                <div class="col-md-4">
                    <div class="card reservation-card shadow-sm p-3 h-100">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="fw-bold mb-0">{{ $reservation->customer_name }}</h5>
                            <span
                                class="badge 
                        @if ($reservation->status == 'booked') bg-primary
                        @elseif($reservation->status == 'checked_in') bg-success
                        @elseif($reservation->status == 'completed') bg-secondary
                        @else bg-danger @endif status-badge">
                                {{ ucfirst($reservation->status) }}
                            </span>
                        </div>
                        <p class="mb-1"><i class="bi bi-telephone"></i>
                            {{ $reservation->customer_phone ?? '-' }}
                        </p>
                        <p class="mb-1"><i class="bi bi-people-fill"></i>
                            {{ $reservation->guest_count }} Guests
                        </p>
                        <p class="mb-1"><i class="bi bi-grid-3x3-gap"></i>
                            Table {{ $reservation->table->name ?? $reservation->table_id }}
                        </p>
                        <p class="mb-3"><i class="bi bi-clock"></i>
                            {{ $reservation->booking_start->format('d M Y, h:i A') }}
                        </p>
                        <div class="d-flex gap-2 mt-auto">
                            <button class="btn btn-success btn-sm w-50 check-in-btn" data-id="{{ $reservation->id }}">
                                <i class="bi bi-check2-circle me-1"></i> Check-In
                            </button>
                            <button class="btn btn-danger btn-sm w-50 cancel-btn" data-id="{{ $reservation->id }}">
                                <i class="bi bi-x-circle me-1"></i> Cancel
                            </button>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Your scripts goes in here
    </script>
@endpush
