@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            Supplier debts report
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-striped table-hover table-bordered align-middle text-center">
                    <thead class="table-dark">
                        <tr>
                            <th><i class="fas fa-user"></i> Creditor</th>
                            <th><i class="fas fa-money-bill-wave"></i> Due Balance</th>
                            <th><i class="fas fa-info-circle"></i> Status</th>
                            <th><i class="fas fa-map-pin"></i> Location</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $sum = 0; @endphp
                        @forelse ($debts as $debt)
                            @if ($debt->due > 0)
                                @php
                                    $sum += $debt->due;
                                    $supplierData = App\Models\Supplier::find($debt->supplier_id);
                                    $sellingData = App\Models\Selling::with('location')->find($debt->selling_id);
                                @endphp
                                <tr class="align-middle">
                                    <td><i class="fas fa-user"></i> {{ $supplierData->name ?? 'N/A' }} </td>
                                    <td>
                                        <a href="{{ route('supplier.statement', ['supplierId' => $debt->supplier_id, 'sellingId' => $debt->selling_id]) }}"
                                            class="fw-bold text-decoration-underline text-danger">
                                            <i class="fas fa-money-bill-wave me-1"></i> {{ number_format($debt->due) }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-warning text-dark p-2">
                                            <i class="fas fa-exclamation-triangle"></i> Pending..
                                        </span>
                                    <td>
                                        <div class="d-flex align-items-center gap-2 justify-content-center">
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-map-marker-alt"></i>
                                            </span>
                                            <span>
                                                {{ $sellingData->location->name ?? 'N/A' }}
                                            </span>
                                        </div>
                                    </td>
                                </tr>
                            @endif
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary fw-bold">No Debts Found</h5>
                                        <p class="text-muted mb-0">
                                            There are currently no supplier debts to display.<br>
                                            <span class="small">Once you add purchases or credits from suppliers, they will
                                                appear here.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="table-secondary">
                        <tr>
                            <th colspan="1" class="text-end">Total</th>
                            <th class="fw-bold">{{ number_format($sum) }}</th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(function() {
                $("#example1").DataTable({
                    "pageLength": 100,
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

                }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            });
        </script>
    @endsection
@endsection
