@extends('layouts.master')

@section('content')

    @include('patial.loading-spinner')

    <div class="container-fluid mt-2">
        <!-- Summary Section -->
        @php
            $totalOpening = $debts->sum('opening_balance');
            $totalAmount = $debts->sum('amount');
            $totalPaid = $debts->sum('paid');
            $totalDue = $latestSupplierDebts->due;
        @endphp

        <div class="row mb-4">
            <div class="col-md-2">
                <div class="card text-center shadow-sm border-primary">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Opening Balance</h6>
                        <h5 class="fw-bold">{{ number_format($totalOpening, 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center shadow-sm border-info">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Amount</h6>
                        <h5 class="fw-bold">{{ number_format($totalAmount, 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card text-center shadow-sm border-success">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Paid</h6>
                        <h5 class="fw-bold">{{ number_format($totalPaid, 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center shadow-sm border-success">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Total Due</h6>
                        <h5 class="fw-bold text-danger">{{ number_format($totalDue, 2) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                @php
                    if ($totalDue <= 0) {
                        $statusText = 'Cleared';
                        $statusBadgeClass = 'bg-success text-white';
                        $cardBorderClass = 'border-success';
                    } else {
                        $statusText = 'Pending';
                        $statusBadgeClass = 'bg-warning text-dark';
                        $cardBorderClass = 'border-danger';
                    }
                @endphp
                <div class="card text-center shadow-sm {{ $cardBorderClass }}">
                    <div class="card-body">
                        <h6 class="text-uppercase text-muted small">Status</h6>
                        <span class="badge fs-6 p-2 {{ $statusBadgeClass }}">
                            <i class="fas {{ $totalDue <= 0 ? 'fa-check-circle' : 'fa-hourglass-half' }} me-1"></i>
                            {{ $statusText }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Table Section -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">{{ $latestSupplierDebts->supplier->name }} Debts History</h5>
            </div>
            <div class="card-body">
                @if (count($debts) === 0)
                    <center>
                        <h5>There's no data to display based on the selected duration.</h5>
                    </center>
                @else
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="data-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Date</th>
                                    <th>Supplier</th>
                                    <th>Opening Balance</th>
                                    <th>Amount</th>
                                    <th>Paid</th>
                                    <th>Due</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($debts as $debt)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $debt->created_at }}</td>
                                        <td>{{ $latestSupplierDebts->supplier->name }}</td>
                                        <td>{{ $debt->opening_balance ? number_format($debt->opening_balance, 2) : '-' }}
                                        </td>
                                        <td>
                                            @if ($debt->amount)
                                                <a href="{{ route('purchased.items', $debt->purchase_id) }}">
                                                    {{ number_format($debt->amount, 2) }}
                                                </a>
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>{{ $debt->paid ? number_format($debt->paid, 2) : '-' }}</td>
                                        <td class="text-danger">{{ number_format($debt->due, 2) }}</td>
                                        <td>
                                            <form id="deleteform{{ $debt->id }}" method="GET"
                                                action="{{ route('cancel.supplier.debt.transaction', $debt->id) }}">
                                                @csrf
                                                <button type="button" class="btn btn-danger btn-sm delete"
                                                    data-id="{{ $debt->id }}">
                                                    <i class="fa fa-trash-alt"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>

            <div class="card-footer">
                <div class="d-flex justify-content-end">
                    <div class="btn-group" role="group" aria-label="Actions">
                        <!-- Generate PDF -->
                        <a href="{{ route('generate.pdf', [$latestSupplierDebts->supplier_id, $latestSupplierDebts->selling_id, isset($duration) ? $duration : '-', isset($start) ? $start : '-', isset($end) ? $end : '-', 1, 0, 'supplier']) }}"
                            class="btn btn-primary float-right" style="margin-right: 5px;">
                            <i class="fas fa-download"></i> Generate PDF
                        </a>

                        <!-- Submit Payment -->
                        @if ($latestSupplierDebts->due > 0)
                            <button type="button" class="btn btn-success" data-toggle="modal" data-target="#paymentModal">
                                <i class="fas fa-money-bill-wave mr-1"></i> Submit Payment
                            </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('pay.Supplier.debt.history', $latestSupplierDebts->supplier->id) }}" method="GET">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="paymentModalLabel">Clear Debt</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Date -->
                        <div class="form-group">
                            <label for="date">Date</label>
                            <input type="date" id="date" name="date" class="form-control"
                                value="{{ now()->format('Y-m-d') }}" required>
                        </div>

                        <!-- Supplier -->
                        <div class="form-group">
                            <label for="supplier_name">Supplier</label>
                            <input type="text" id="supplier_name" class="form-control"
                                value="{{ $latestSupplierDebts->supplier->name }}" readonly>
                        </div>

                        <!-- Due Balance -->
                        <div class="form-group">
                            <label for="due_balance">Due Balance</label>
                            <input type="text" id="due_balance" class="form-control"
                                value="{{ number_format($latestSupplierDebts->due, 2) }}" readonly>
                        </div>

                        <!-- Paid Amount -->
                        <div class="form-group">
                            <label for="paid">Paid Amount</label>
                            <input type="number" id="paid" name="paid" class="form-control" required>
                        </div>

                        <!-- Account -->
                        <div class="form-group">
                            <label for="account">Account</label>
                            <select id="account" name="account" class="form-control" required>
                                <option value="">-- Select Account --</option>
                                @foreach ($accounts as $account)
                                    <option value="{{ $account->id }}">-- {{ $account->name }} --</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Confirm Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            $(".delete").on("click", function() {
                var id = $(this).attr("data-id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "This action will cancel the debt transaction!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, cancel it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                });
            });
        });
    </script>
@endsection
@endsection
