@extends('layouts.master')

@section('content')

    <form action="{{ route('stock.transfer.report') }}" method="get" class="was-validated">

        <div class="card table-responsive">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td><button type="button" class="btn btn-danger" id="deleteall"><i
                                        class="fa fa-trash-alt fa-lg"></i> Delete all</button>
                            </td>

                            <td>
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                        @foreach ($selling->storage as $storage)
                                            <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary"><i
                                        class="fa fa-search fa-lg"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <div class="container">
                    <div class="row">

                    </div>
                </div>

                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped table-hover align-middle"
                        style="text-align: center;">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width:40px;"><input type="checkbox" id="checkall"></th>
                                <th>Date</th>
                                <th>Product</th>
                                <th>Cont</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>From</th>
                                <th>To</th>
                                <th>User</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($results as $result)
                                @php
                                    $fromData = App\Models\Location::find($result->from);
                                    $toData = App\Models\Location::find($result->to);
                                    $formattedQty = '0';
                                    if ($result->product->unit) {
                                        $units = $result->product->unit
                                            ->where('location_id', $result->from)
                                            ->where('unit_id', '!=', null)
                                            ->sortByDesc('unit_cont');
                                        $remainingQty = $result->qty;
                                        $formattedQty = $units
                                            ->flatMap(function ($unit) use (&$remainingQty) {
                                                $unit_cont = $unit->unit_cont;
                                                if (is_numeric($unit_cont) && $unit_cont > 0) {
                                                    $current_qty = (int) ($remainingQty / $unit_cont);
                                                    $remainingQty %= $unit_cont;
                                                    return $current_qty ? [$current_qty . ' ' . $unit->unit->name] : [];
                                                }
                                                return [];
                                            })
                                            ->implode(', ');
                                        $formattedQty = $formattedQty ?: '0';
                                    }
                                @endphp
                                <tr>
                                    <td>
                                        <input type="checkbox" class="selected" id="{{ $result->id }}">
                                    </td>
                                    <td>{{ $result->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        <span class="fw-bold">{{ $result->product->product }} {{ $result->batch_no ? '| Batch '.$result->batch_no : '' }}</span>
                                    </td>
                                    <td>{{ $result->cont }}</td>
                                    <td>{{ number_format($result->price, 2) }}</td>
                                    <td>
                                        <span class="badge bg-info text-dark">{{ $formattedQty }}</span>
                                    </td>
                                    <td>
                                        <span class="text-primary">{{ $fromData->name ?? '-' }}</span>
                                    </td>
                                    <td>
                                        <span class="text-success">{{ $toData->name ?? '-' }}</span>
                                    </td>
                                    <td>
                                        <span class="fw-semibold">{{ $result->user->name ?? '-' }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th><input type="checkbox" id="checkall"></th>
                                <th>Date</th>
                                <th>Product</th>
                                <th>Cont</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>From</th>
                                <th>To</th>
                                <th>User</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {
            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        });

        //global variable
        var type = "";
        var start = "";
        var end = "";

        $("#start").on("change", function() {
            start = $(this).val();
        });

        $("#end").on("change", function() {
            end = $(this).val();
        });

        $("#type").on("change", function() {
            type = $(this).val();

            if (type == "today") {
                $("#start").attr("required", false).fadeOut("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set date") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set duration") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", true).fadeIn("slow");
            }
        });

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select at least one item!!',
                });
                return;
            }

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('delete.stock.transfer') }}",
                        method: "GET",
                        data: {
                            'ids': selected
                        },
                        success: function(data) {
                            // Remove deleted rows from the table
                            selected.forEach(function(id) {
                                $("#example1").find("#" + id).closest("tr").remove();
                            });

                            // Show SweetAlert success
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted successfully!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Something went wrong. Please try again!',
                            });
                        }
                    });
                }
            });
        });
    </script>
@endsection

@endsection
