@extends('layouts.master')

@section('content')

        <div class="card">
            <div class="card-header">

                <a href="{{ route('stock.tacking.report') }}" class="btn btn-primary btn-sm"><i class="fas fa-file-excel fa-lg"></i> Stock tacking report</a>

            </div>
            <div class="card-body">

                <strong>
                    <h5> Carefully follow the followig steps. </h5>
                </strong>

                <ol>
                    <li>Download excel <a href="{{ route('download.stock.tacking.excel') }}" class="btn btn-success btn-sm"><i class="fas fa-file-excel fa-lg"></i> Download
                            Excel</a></li>
                    <li>Fill the excel and then save it <strong>(.xls)</strong>.</li>
                    <li>Highlight and format the <strong>New expiry date</strong> column to <strong>text</strong>.</li>
                    <li>Fill in new Qty and Expiry date where nessessary,<strong>do not update any product name</strong>.
                    </li>
                    <li>Save the updates and upload the excel.</li>

                    <form action="{{ route('upload.stock.tacking.excel') }}" method="post" enctype="multipart/form-data" class="was-validated">
                        @csrf
                        <li>
                            <table>
                                <td>
                                    <div class="custom-file">
                                        <input type="file" name="file" class="custom-file-input" id="stockFile" required>
                                        <label class="custom-file-label" for="stockFile">Choose Excel file...</label>
                                    </div>
                                    <script>
                                        document.addEventListener('DOMContentLoaded', function () {
                                            const input = document.getElementById('stockFile');
                                            const label = input.nextElementSibling;
                                            input.addEventListener('change', function (e) {
                                                const fileName = e.target.files[0] ? e.target.files[0].name : 'Choose Excel file...';
                                                label.textContent = fileName;
                                            });
                                        });
                                    </script>
                                </td>
                                <td>
                                    @if ($sellingCount > 1)
                                        <select name="area" id="area" class="form-control"
                                            style="text-align: center" required>
                                            <option disabled selected value="">-- Choose Location --</option>
                                            @foreach ($sellings as $selling)
                                                <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                                </option>
                                                @foreach ($selling->storage as $storage)
                                                    <option value="{{ $storage->location_id }}">
                                                        -- {{ $storage->location->name }} --</option>
                                                @endforeach
                                            @endforeach
                                        </select>
                                    @else
                                        <select name="area" id="area" class="form-control"
                                            style="text-align: center" required>
                                            <option disabled selected value="">-- Choose Location --</option>
                                            <option value="{{ $sellings[0]->location_id }}">
                                                -- {{ $sellings[0]->location->name }} --
                                            </option>
                                            @foreach ($sellings[0]->storage as $storage)
                                                <option value="{{ $storage->location_id }}">
                                                   --  {{ $storage->location->name }} --</option>
                                            @endforeach
                                        </select>
                                    @endif
                                </td>

                                <td>
                                    <button type="submit" class="btn btn-warning"><i class="fas fa-upload fa-lg"></i> Upload Excel</button>
                                </td>
                            </table>
                        </li>

                    </form>
                </ol>

            </div>
        </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script></script>
@endsection

@endsection
