@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <div class="card-header">
                <p>Stock tacking report</p>
            </div>

            <div class="card-body">

                <table class="table table-stripped" style="text-align: center" id="customer">
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>Product</th>
                            <th>Before Qty</th>
                            <th>After Qty</th>
                            <th>Difference</th>
                            <th>Buying Price</th>
                            <th>Missing value</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($stockTackingData as $data)
                            @php
                                $products = App\Models\Product::where('product', $data->product)->get();
                            @endphp
                            <tr>
                                <td>{{ $loop->index +1 }}</td>
                                <td>{{ $data->product }}</td>
                                <td>{{ $data->oldqty }}</td>
                                <td>{{ $data->newqty }}</td>
                                <td>{{ $data->newqty - $data->oldqty }}</td>
                                <td>{{ $data->buying }}</td>
                                <td>{{ $data->missing_value }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>

                        <tr>
                            <th>S/N</th>
                            <th>Product</th>
                            <th>Before Qty</th>
                            <th>After Qty</th>
                            <th>Difference</th>
                            <th>Buying</th>
                            <th>{{ $missingValue }}</th>
                        </tr>

                        </tr>
                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#customer").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
@endsection

@endsection
