@extends('layouts.master')

@section('content')

    <div class="card table-responsive"
        style="width: 50%; margin-left: 25%; margin-top: 5%; border-radius: 20px; box-shadow: 0px 0px 10px 5px rgba(0,0,0,0.5)">
        <div class="card-header"
            style="border-radius: 20px 20px 0px 0px; background-color: #007bff; color: white; font-size: 20px">Stock Reset
        </div>


        <form action="{{ route('stock.reset') }}" onsubmit="showSpinner()" method="get" class="was-validated">
            @csrf

            <div class="card-body">
                <b>
                    <p>
                    <h5 style="color: red; display: none" id="error">Unakaribnia kufuta bidhaa zote zisomeke 0</h5>
                    </p>
                </b>
                    <select name="location" id="location" class="form-control" style="text-align: center" required>
                        <option disabled selected value="">-- Choose Location --</option>
                        @foreach ($sellings as $selling)
                            <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --</option>
                            @foreach ($selling->storage as $storage)
                                <option value="{{ $storage->location_id }}">
                                    -- {{ $storage->location->name }} --</option>
                            @endforeach
                        @endforeach
                    </select>
            </div>

            <div class="card-footer text-right">
                <button class="btn btn-primary"> <i class="fas fa-refresh"></i> Reset</button>
            </div>
        </form>
    </div>

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $("#error").show(2000).fadeOut(2000).show(2000).hide(3000).show(3000).hide(2000).show(2000);
        });
    </script>
@endsection

@endsection
