@extends('layouts.master')

@section('content')
    <div class="container-fluid">
        <div class="card shadow-sm rounded-3">
            <div class="card-header">
                <form action="{{ route('stock.movement.report') }}" method="get" class="was-validated">
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    <select name="area" id="area" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected value="">-- Choose location --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>
                                </td>

                                <td>
                                    <select name="type" id="type" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected value="">-- Select duration --</option>
                                        <option value="today">-- Today --</option>
                                        <option value="set date">-- Set Date --</option>
                                        <option value="set duration">-- Set Duration --</option>
                                    </select>
                                </td>

                                <td><input type="date" name="start" id="start" class="form-control"
                                        style="text-align: center; display:none" required></td>
                                <td><input type="date" name="end" id="end" class="form-control"
                                        style="text-align: center; display:none" required></td>

                                <td> <button type="submit" id="search" class="btn btn-primary"><i
                                            class="fa fa-search fa-lg"></i> Search</button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </form>
            </div>

            <div class="card-body">
                {{-- Stock report table --}}
                <div class="table-responsive">
                    <table id="data-table" class="table table-bordered table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th class="text-start">Product</th>
                                <th>Opening</th>
                                <th>Purchases</th>
                                <th>Sales</th>
                                <th>Damages</th>
                                <th>Transfers</th>
                                <th>Adjustments</th>
                                <th class="bg-primary text-white">Closing</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($report as $item)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td class="text-start fw-semibold">{{ $item['product'] }}</td>
                                    <td>{{ number_format($item['opening']) }}</td>
                                    <td class="text-success fw-bold">
                                        + {{ number_format($item['purchases']) }}
                                    </td>
                                    <td class="text-danger fw-bold">
                                        - {{ number_format($item['sales']) }}
                                    </td>
                                    <td class="text-primary fw-bold">
                                        - {{ number_format($item['damages']) }}
                                    </td>
                                    <td>
                                        @if ($item['transfers'] >= 0)
                                            + {{ number_format($item['transfers']) }}
                                        @else
                                            - {{ number_format(abs($item['transfers'])) }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($item['adjustments'] >= 0)
                                            + {{ number_format($item['adjustments']) }}
                                        @else
                                            - {{ number_format(abs($item['adjustments'])) }}
                                        @endif
                                    </td>
                                    <td class="bg-light fw-bold">
                                        {{ number_format($item['closing']) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center text-muted py-3">
                                        No stock movement found for the selected duration.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        @if (count($report))
                            <tfoot class="table-light fw-bold">
                                <tr>
                                    <td>#</td>
                                    <td class="text-end">TOTAL:</td>
                                    <td>{{ number_format($report->sum('opening')) }}</td>
                                    <td class="text-success">+ {{ number_format($report->sum('purchases')) }}</td>
                                    <td class="text-danger">- {{ number_format($report->sum('sales')) }}</td>
                                    <td class="text-primary">- {{ number_format($report->sum('damages')) }}</td>
                                    <td>
                                        @php $transferSum = $report->sum('transfers'); @endphp
                                        @if ($transferSum >= 0)
                                            + {{ number_format($transferSum) }}
                                        @else
                                            - {{ number_format(abs($transferSum)) }}
                                        @endif
                                    </td>
                                    <td>
                                        @php $adjustmentSum = $report->sum('adjustments'); @endphp
                                        @if ($adjustmentSum >= 0)
                                            + {{ number_format($adjustmentSum) }}
                                        @else
                                            - {{ number_format(abs($adjustmentSum)) }}
                                        @endif
                                    </td>
                                    <td class="bg-light">{{ number_format($report->sum('closing')) }}</td>
                                </tr>
                            </tfoot>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(document).ready(function() {
                // $('#stockMovementTable').DataTable({
                //     "paging": true,
                //     "lengthChange": true,
                //     "searching": true,
                //     "ordering": true,
                //     "info": true,
                //     "autoWidth": false,
                //     "responsive": true,
                // });
                
                //global variable
                var type = "";
                var area = "";
                var start = "";
                var end = "";

                $("#start").on("change", function() {
                    start = $(this).val();
                });

                $("#end").on("change", function() {
                    end = $(this).val();
                });

                $("#type").on("change", function() {
                    type = $(this).val();

                    if (type == "today") {
                        $("#start").attr("required", false).fadeOut("slow");
                        $("#end").attr("required", false).fadeOut("slow");

                    } else if (type == "set date") {
                        $("#start").attr("required", false).fadeIn("slow");
                        $("#end").attr("required", false).fadeOut("slow");

                    } else if (type == "set duration") {
                        $("#start").attr("required", true).fadeIn("slow");
                        $("#end").attr("required", true).fadeIn("slow");
                    }
                });
            });
        </script>
    @endsection
@endsection
