@extends('layouts.master')

@section('content')

    <form action="{{ route('stock.list.view') }}" method="get">
        <div class="card table-responsive">
            <div class="card-header">
                @if ($sellingCount > 1)
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    <select name="location" id="location" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected>-- Choose Location --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>
                                </td>

                                <td> <button type="submit" id="search" class="btn btn-primary">Search</button></td>
                            </tr>
                        </tbody>
                    </table>
                @else
                    <h5>{{ $sellings[0]->location->name }} stock list</h5>
                @endif
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered align-middle text-center" id="customer"
                        style="width:100%">
                        <thead class="thead-dark">
                            <tr>
                                <th style="width: 3%;">S/N</th>
                                <th>Barcode</th>
                                <th>Product</th>
                                <th>Category</th>
                                <th>Supplier</th>
                                <th>Min Qty</th>
                                <th>Qty</th>
                                <th>Expiry Date</th>
                                <th>Batch</th>
                                <th>Location</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($products as $product)
                                @php
                                    $stock = App\Models\Stock::where('product_id', $product->id)
                                        ->where('location_id', $product->location_id)
                                        ->with('unit', 'location')
                                        ->first();

                                    $answer = [];

                                    if ($stock) {
                                        $units = App\Models\UnitAssigned::where('product_id', $product->id)
                                            ->whereNotNull('unit_id')
                                            ->where('unit_cont', '>', 0)
                                            ->with('unit')
                                            ->orderBy('unit_cont', 'desc')
                                            ->get();

                                        // --- Sanitize stock quantity ---
                                        $remainder = is_numeric($stock->qty) ? floatval($stock->qty) : 0.0;

                                        $x = 0;
                                        while ($remainder > 0 && isset($units[$x])) {
                                            // --- Sanitize unit_cont ---
                                            $current_cont_raw = $units[$x]->unit_cont;
                                            $current_cont = is_numeric($current_cont_raw)
                                                ? floatval($current_cont_raw)
                                                : 0.0;

                                            // Skip if invalid or zero to avoid division errors
                                            if ($current_cont > 0) {
                                                // Get whole number of units
                                                $current_qty = floor($remainder / $current_cont);

                                                // Calculate remainder with float support
                                                $remainder = fmod($remainder, $current_cont);

                                                if ($current_qty > 0) {
                                                    $answer[] = $current_qty . ' ' . $units[$x]->unit->name;
                                                }
                                            } else {
                                                // Optional: log invalid data for debugging
                                                \Log::warning('Invalid unit_cont value', [
                                                    'product_id' => $product->id,
                                                    'unit_cont' => $current_cont_raw,
                                                ]);
                                            }

                                            $x++;
                                        }

                                        // --- Handle any leftover remainder ---
                                        if ($remainder > 0) {
                                            $answer[] =
                                                number_format($remainder, 2) . ' ' . ($stock?->unit?->name ?? 'units');
                                        }
                                    }
                                @endphp
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        @if ($product->barcode)
                                            <span class="badge bg-secondary">{{ $product->barcode }}</span>
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td class="text-left">{{ $product->product ?? 'N/A' }}</td>
                                    <td>{{ $product->category->name ?? 'N/A' }}</td>
                                    <td>{{ $product->supplier->name ?? 'N/A' }}</td>
                                    <td>
                                        @if ($stock)
                                            {{ $stock->min_qty }} {{ $stock?->unit?->name ?? '' }}
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if (!$stock || $stock->qty <= 0)
                                            <span class="badge bg-danger">0 {{ $stock ? $stock?->unit?->name : '' }}</span>
                                        @else
                                            <span class="badge bg-success">{{ implode(', ', $answer) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($stock && $stock->exp)
                                            <span class="badge bg-info">{{ $stock->exp }}</span>
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $stock->batch_np ?? 'N/A' }}
                                    </td>
                                    <td>
                                        {{ $stock->location->name ?? 'N/A' }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center py-5">
                                        <div class="d-flex flex-column align-items-center">
                                            <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png"
                                                alt="No Data" style="width: 80px; opacity: 0.5;">
                                            <h5 class="mt-3 text-secondary font-weight-bold">No Units Found</h5>
                                            <p class="text-muted mb-0">You haven't added any Units yet.<br>
                                                <span class="small">Click <strong>Register Unit</strong> to get
                                                    started.</span>
                                            </p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th>S/N</th>
                                <th>Barcode</th>
                                <th>Product</th>
                                <th>Category</th>
                                <th>Supplier</th>
                                <th>Min Qty</th>
                                <th>Qty</th>
                                <th>Expiry Date</th>
                                <th>Batch</th>
                                <th>Location</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

    @section('scripts')
        <script>
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
        </script>
    @endsection

@endsection
