@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        {{-- <center>
            <h5>Slipt bill</h5>
        </center> --}}
    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <style>
            .grid-container {
                display: grid;
                grid-template-columns: auto auto auto;
                background-color: gray;
                padding: 10px;
            }

            .grid-item {
                background-color: rgba(255, 255, 255, 0.8);
                border: 1px solid rgba(0, 0, 0, 0.8);
                padding: 20px;
                font-size: 15px;
                text-align: center;
            }
        </style>

        <div class="card">

            <div class="card-header">
                <table>
                    <thead>
                        {{-- <th>
                            <select name="location" id="location" class="form-control">
                                <option disabled selected value="">Choose location</option>
                                @foreach ($locations as $location)
                                    <option value="{{ $location->id }}">{{ $location->name }}
                                    </option>
                                @endforeach
                            </select>
                        </th> --}}

                        <th>
                            @foreach ($categories as $category)
                                <button type="button" class="btn btn-outline-info category">{{ $category->name }}</button>
                            @endforeach
                        </th>
                    </thead>
                </table>

                <input type="hidden" name="" id="category" class="form-control">
            </div>

            <form action="{{ route('split.bill') }}" method="post">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <input type="search" name="" id="search" class="form-control  use-keyboard-input"
                                placeholder="Search by product name..">
                            <br>

                            <div class="grid-container">

                            </div>
                        </div>

                        <div class="col">
                            <table class="table table-striped" style="text-align: center">
                                <thead style="text-align: center">
                                    <tr>
                                        <th style="width:1%">#</th>
                                        <th style="width:25%">Product</th>
                                        <th style="width:10%">Unit</th>
                                        <th style="width:20%">Price</th>
                                        <th style="width:25%">Qty</th>
                                        <th style="width:20%">Amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody id="tbody">
                                    <tr id="jumla">
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td colspan="2">
                                            <input type="number" name="total" id="total" class="form-control"
                                                style="text-align: center" placeholder="Total" readonly>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td colspan="2">
                                            <input type="text" name="table" id="table" class="form-control"
                                                style="text-align: center" value="{{ $tableData->name }}" readonly>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td colspan="2">
                                            <input type="text" name="waiter" id="waiter" class="form-control"
                                                style="text-align: center" value="{{ $waiterData->name }}" readonly>
                                        </td>
                                    </tr>

                                    {{-- <div id="room-div" style="display: none">
                                        <tr>
                                            @php
                                                $bookings = App\Models\Booking::where('status', 'check-in')->get();
                                            @endphp

                                            <td>&nbsp</td>
                                            <td>&nbsp</td>
                                            <td>&nbsp</td>
                                            <td>&nbsp</td>
                                            <td>&nbsp</td>
                                            <td colspan="2">

                                                <select name="room" id="room" class="form-control"
                                                    style="text-align: center;" required>
                                                    <option selected value="">--Room #--</option>
                                                    @foreach ($bookings as $booking)
                                                        <option value="{{ $booking->room }}">{{ $booking->room }}</option>
                                                    @endforeach
                                                </select>

                                            </td>

                                        </tr>
                                    </div> --}}

                                    <tr>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td colspan="2">
                                            <button type="submit"
                                                class="btn btn-lg btn-block btn-outline-success shadow-sm"
                                                style="font-size: 1.2rem; font-weight: 600; border-radius: 10px; padding: 10px 20px">
                                                <i class="fas fa-print mr-2"></i> Print Bill
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <input type="hidden" name="" style="text-align: center" id="vatstatus"
                                value="{{ $businessProfile->vat }}" class="form-control">
                        </div>
                    </div>
                </div>
            </form>
        </div>

        @include('patial.keyboard')

    </div>
    {{-- /.content --}}


@section('scripts') 
    <script>
        $(document).ready(function() {
            $("#customer").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            var vatstatus = $("#vatstatus").val();
            if (vatstatus == "Inclusive") {
                $(".vat").fadeIn("slow");
            } else {
                $(".vat").fadeOut("slow");
            }

            var index = 0;
            // var locationId = "";

            // $("#location").on("change", function() {
            //     locationId = $(this).val();
            // });

            $(".category").on("click", function() {
                let category = $(this).html();
                $("#category").val(category);

                $.ajax({
                    url: "{{ route('get.menu.by.category') }}",
                    method: "get",
                    data: {
                        'category': category,
                        //'locationId': locationId,
                    },
                    success: function(data) {
                        $(".grid-container").empty();
                        console.log(data);
                        for (var i = 0; i < data[0].length; i++) {
                            let image = '';
                            let image_dir = '{{ asset('images/') }}'
                            if (data[0][i].image) {
                                image =
                                    '<img height="70" width="105" style="object-fit: cover; border-radius: 10px;" src="' +
                                    '{{ asset('storage/images/') }}/' + data[0][i].image +
                                    '" alt="Product Image"><br>';
                            }
                            $(".grid-container").append(
                                '<button type="button" class="grid-item" id="' + i +
                                '">' +
                                image +
                                data[0][i].product + '</button>');
                        }

                        $(".grid-item").on("click", function() {
                            let product = $(this).html();
                            let id = $(this).attr("id");

                            let tr =
                                '<tr id="tr' + index + '">' +
                                '<td><input type="hidden" value="' + data[0][id]
                                .id +
                                '" name="id[]" id="id' +
                                index +
                                '" class="form-control id" style="text-align: center" readonly><input type="hidden" value="' +
                                data[0][id]
                                .location_id +
                                '" name="area[]" id="id' +
                                index +
                                '" class="form-control id" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + data[0][id]
                                .product +
                                '" name="product[]" id="product' +
                                index +
                                '" class="form-control product" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + data[0][id].unit[
                                    0]
                                .unit
                                .name +
                                '" name="unit[]" id="unit' +
                                index +
                                '" class="form-control unit" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + new Intl
                                .NumberFormat('en-US', {
                                    style: 'decimal',
                                    minimumFractionDigits: 0
                                }).format(data[0][id].unit[0].selling) +
                                '" name="price[]" id="price' +
                                index +
                                '" class="form-control price" style="text-align: center" readonly></td>' +
                                '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                                index +
                                '"><i class="fas fa-minus"></i></button><input type="text" value="1" name="qty[]" id="qty' +
                                index +
                                '" class="form-control qty" style="text-align: center;" readonly required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                                index + '"><i class="fas fa-plus"></i></button></td>' +
                                '<td><input type="text" name="amount[]" value="' +
                                new Intl.NumberFormat('en-US', {
                                    style: 'decimal',
                                    minimumFractionDigits: 0
                                }).format(data[0][id].unit[0].selling) +
                                '" id="amount' +
                                index +
                                '" class="form-control amount" style="text-align: center" readonly></td>' +
                                '<td><button type="button" class="btn btn-outline-danger removeRow" id="' +
                                index +
                                '"><i class="fas fa-trash-alt"></i></button></td>' +
                                '</tr>';

                            $("#jumla").before(tr);
                            index++;
                            total();
                        });

                    }
                });
            });

            $("#search").on('input', function() {
                let query = $(this).val();
                let category = $("#category").val();

                $.ajax({
                    url: "{{ route('get.category.menu') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'category': category,
                        // 'locationId': locationId,
                    },
                    success: function(data) {
                        $(".grid-container").empty();
                        console.log(data);

                        for (var i = 0; i < data[0].length; i++) {
                            let image = '';
                            let image_dir = '{{ asset('images/') }}'
                            if (data[0][i].image) {
                                image = '<img height="100" width="150" src="' + image_dir +
                                    '/' + data[0][i].image + '"><br>'
                            }
                            $(".grid-container").append(
                                '<button type="button" class="grid-item" id="' + i + '">' +
                                image +
                                data[0][i].product + '</button>');
                        }

                        $(".grid-item").on("click", function() {
                            var product = $(this).html();
                            var id = $(this).attr("id");

                            var tr =
                                '<tr id="tr' + index + '">' +
                                '<td><input type="hidden" value="' + data[0][id]
                                .id +
                                '" name="id[]" id="id' +
                                index +
                                '" class="form-control id" style="text-align: center" readonly><input type="hidden" value="' +
                                data[0][id]
                                .location_id +
                                '" name="area[]" id="id' +
                                index +
                                '" class="form-control id" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + data[0][id].product +
                                '" name="product[]" id="product' +
                                index +
                                '" class="form-control product" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + data[0][id].unit[0]
                                .unit.name + '" name="unit[]" id="unit' +
                                index +
                                '" class="form-control unit" style="text-align: center" readonly></td>' +
                                '<td><input type="text" value="' + data[0][id].unit[0]
                                .selling +
                                '" name="price[]" id="price' +
                                index +
                                '" class="form-control price" style="text-align: center" readonly></td>' +
                                '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                                index +
                                '"><i class="fas fa-minus"></i></button><input type="text" value="1" name="qty[]" id="qty' +
                                index +
                                '" class="form-control qty" style="text-align: center;" readonly required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                                index + '"><i class="fas fa-plus"></i></button></td>' +
                                '<td><input type="text" name="amount[]" value="' +
                                data[0][id].unit[0].selling +
                                '" id="amount' +
                                index +
                                '" class="form-control amount" style="text-align: center" readonly></td>' +
                                '<td><button type="button" id="' + index +
                                '" class="btn btn-outline-danger removeRow"><i class="fas fa-trash-alt"></i></button></td>' +
                                '</tr>';

                            $("#jumla").before(tr);
                            index++;
                            total();
                        });

                    }
                });
            });

            $("#search").on('change', function() {
                let barcode = $(this).val();

                $.ajax({
                    url: "{{ route('get.product.by.barcode') }}",
                    method: "get",
                    data: {
                        'barcode': barcode,
                        //'locationId': locationId,
                    },
                    success: function(data) {
                        $(".grid-container").empty();
                        console.log(data);

                        var tr =
                            '<tr id="tr' + index + '">' +
                            '<td><input type="hidden" value="' + data[0]
                            .id +
                            '" name="id[]" id="id' +
                            index +
                            '" class="form-control id" style="text-align: center" readonly><input type="hidden" value="' +
                            data[0]
                            .location_id +
                            '" name="area[]" id="id' +
                            index +
                            '" class="form-control id" style="text-align: center" readonly></td>' +
                            '<td><input type="text" value="' + data[0].product +
                            '" name="product[]" id="product' +
                            index +
                            '" class="form-control product" style="text-align: center" readonly></td>' +
                            '<td><input type="text" value="' + data[0].unit[0]
                            .unit.name + '" name="unit[]" id="unit' +
                            index +
                            '" class="form-control unit" style="text-align: center" readonly></td>' +
                            '<td><input type="text" value="' + data[0].unit[0]
                            .selling +
                            '" name="price[]" id="price' +
                            index +
                            '" class="form-control price" style="text-align: center" readonly></td>' +
                            '<td style="display:flex"><button type="button" class="btn btn-warning btn-block decrement" id="' +
                            index +
                            '">-</button><input type="text" value="1" name="qty[]" id="qty' +
                            index +
                            '" class="form-control qty" style="text-align: center;" readonly required><button type="button" class="btn btn-success btn-block increment" id="increment' +
                            index + '">+</button></td>' +
                            '<td><input type="text" name="amount[]" value="' +
                            data[0].unit[0].selling +
                            '" id="amount' +
                            index +
                            '" class="form-control amount" style="text-align: center" readonly></td>' +
                            '<td><button type="button" id="' + index +
                            '" class="btn btn-danger removeRow">-</button></td>' +
                            '</tr>';

                        $("#jumla").before(tr);
                        index++;
                        total();

                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("click", ".removeRow", function() {
                let id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
            });

            $(document).on("click", ".increment", function() {
                let id = $(this).attr("id").replace("increment", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            $(document).on("click", ".decrement", function() {
                let id = $(this).attr("id").replace("decrement", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());

                let priceInput = $("#price" + id);
                // Remove commas from the price input and convert it to a float
                let price = parseFloat(priceInput.val().replace(/,/g, ''));

                let amountInput = $("#amount" + id);
                let amount = qty * price;

                // Format the amount with commas
                amountInput.val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));

                // Call the total function to update the total amount
                total();
            }

            function total() {
                let amount = 0;
                let grandtotal = 0;

                $(".amount").each(function() {
                    // Ensure the number is properly parsed
                    amount += Number($(this).val().replace(/,/g, ''));
                });

                // Format total with commas
                $("#total").val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));
            }

            $(document).on("change", ".unit", function() {
                let unit = $(this).val();
                let id = $(this).attr('id').replace("unit", "");

                $.ajax({
                    url: "",
                    method: "get",
                    data: {
                        'unit': unit
                    },
                    success: function(data) {
                        $("#cont" + id).val(data.unitcont)
                        console.log(data);
                    }
                });
            });

            $("#table").on("change", function() {
                let table = $(this).val();
                // if (table != "") {
                //     $("#room").attr("required", false).fadeOut("slow");
                // } else {
                //     $("#room").attr("required", true).fadeIn("slow");
                // }
            });

            // $("#room").on("change", function() {
            //     let table = $(this).val();
            //     if (table != "") {
            //         $("#table").attr("required", false).fadeOut("slow");
            //     } else {
            //         $("#table").attr("required", true).fadeIn("slow");
            //     }
            // });

        });
    </script>
@endsection

@endsection
