@extends('layouts.master')

@section('content')

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-danger btn-sm" id="deleteall">
                        <i class="fas fa-trash"></i> Delete All
                    </button>
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                        data-target="#registerSalesmanModal">
                        <i class="fas fa-plus"></i> Register Salesman
                    </button>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <table class="table table-striped table-hover" id="example1">
                <thead class="thead-dark">
                    <tr>
                        <th style="width: 5%;" class="text-center"><input type="checkbox" id="checkall"></th>
                        <th style="width: 5%" class="text-center">S/N</th>
                        <th class="text-center">Name</th>
                        <th class="text-center">Address</th>
                        <th class="text-center">Phone</th>
                        <th style="width: 20%;" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($salesmen as $salesman)
                        <tr>
                            <td class="text-center"><input type="checkbox" class="selected" value="{{ $salesman->id }}"></td>
                            <td class="text-center">{{ $loop->iteration }}</td>
                            <td class="text-center">{{ $salesman->name }}</td>
                            <td class="text-center">{{ $salesman->address }}</td>
                            <td class="text-center">{{ $salesman->phone }}</td>
                            <td class="text-center">
                                <div class="btn-group" role="group" aria-label="Unit Actions">
                                    <!-- Edit button -->
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#edit-{{ $salesman->id }}">
                                        <i class="fas fa-pen"></i> Edit
                                    </button>

                                    <!-- Delete button -->
                                    <form action="{{ route('salesmen.destroy', $salesman->id) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash-alt"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>

                        <!-- Edit Modal -->
                        <div class="modal fade" id="edit-{{ $salesman->id }}" tabindex="-1"
                            aria-labelledby="editLabel-{{ $salesman->id }}" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('salesmen.update', $salesman->id) }}" method="POST" class="was-validated">
                                        @csrf
                                        @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="editLabel-{{ $salesman->id }}">Update Salesman
                                                Details</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="name-{{ $salesman->id }}">Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    value="{{ $salesman->name }}" id="name-{{ $salesman->id }}" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="address-{{ $salesman->id }}">Address</label>
                                                <input type="text" name="address" class="form-control"
                                                    value="{{ $salesman->address }}" id="address-{{ $salesman->id }}"
                                                    required>
                                            </div>
                                            <div class="form-group">
                                                <label for="phone-{{ $salesman->id }}">Phone</label>
                                                <input type="text" name="phone" class="form-control"
                                                    value="{{ $salesman->phone }}" id="phone-{{ $salesman->id }}"
                                                    required>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <i class="fas fa-paper-plane"></i> Update
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Register Salesman Modal -->
        <div class="modal fade" id="registerSalesmanModal" tabindex="-1" aria-labelledby="registerSalesmanLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('salesmen.store') }}" method="POST" class="was-validated">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title" id="registerSalesmanLabel">Register Salesman</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="new-name">Salesman</label>
                                <input type="text" name="name" class="form-control" id="new-name" required>
                            </div>
                            <div class="form-group">
                                <label for="new-address">Address</label>
                                <input type="text" name="address" class="form-control" id="new-address" required>
                            </div>
                            <div class="form-group">
                                <label for="new-phone">Phone</label>
                                <input type="text" name="phone" class="form-control" id="new-phone" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fas fa-paper-plane"></i> Register
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


@section('scripts')
    <script>
        $("#example1").DataTable();

        $("#checkall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".selected").prop('checked', true);
            } else {
                $(".selected").prop('checked', false);
            }
        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });

            } else {

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('salesmen.bulk.delete') }}",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'deleted successfully!!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        });
                    }
                });

            }

        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
