@extends('layouts.master')

@section('content')
    <div class="card shadow rounded">
        <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ $message }}</h5>
            {{-- <div class="card-tools">
                <button type="button" class="btn btn-tool text-white" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool text-white" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div> --}}
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-hover table-striped table-bordered align-middle">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 5%">#</th>
                            <th style="width: 30%">Customer</th>
                            <th style="width: 20%">Total Debt</th>
                            <th style="width: 20%">Paid Amount</th>
                            <th style="width: 20%">Due Balance</th>
                        </tr>
                    </thead>

                    <tbody>
                        @php
                            $total_debt = 0;
                            $total_paid = 0;
                            $total_due = 0;
                        @endphp

                        @foreach ($sales as $sale)
                            @php
                                $total_debt += $sale->total_debt;
                                $total_paid += $sale->total_paid;
                                $total_due += $sale->total_due;
                            @endphp
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $sale->customer->name }}</td>
                                <td>{{ number_format($sale->total_debt, 2) }}</td>
                                <td>{{ number_format($sale->total_paid, 2) }}</td>
                                <td>{{ number_format($sale->total_due, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot class="bg-light font-weight-bold">
                        <tr>
                            <td colspan="2" class="text-end">Totals:</td>
                            <td>{{ number_format($total_debt, 2) }}</td>
                            <td>{{ number_format($total_paid, 2) }}</td>
                            <td>{{ number_format($total_due, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#example1').DataTable();
        });
    </script>
@endsection
@endsection
