@extends('layouts.master')

@section('content')

    <div class="card table-responsive">

        <div class="card-header">
            <form action="{{ route('sales.reciept') }}" method="get" class="was-validated">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                @if ($sellingCount > 1)
                                    <select name="area" id="area" class="form-control" style="text-align: center"
                                        required>
                                        <option disabled selected>--Choose location--</option>
                                        <option value="0">-- All --</option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">
                                                {{ $selling->selling_location }}
                                            </option>
                                        @endforeach
                                    </select>
                                @else
                                    <input type="hidden" name="area" id="area" class="form-control"
                                        value="{{ $sellings[0]->location_id }}">

                                    <input type="text" name="area-copy" id="area-copy" class="form-control"
                                        value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                                @endif
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button id="search" class="btn btn-primary"><i class="fa fa-search"></i>
                                    Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-bordered table-hover table-striped align-middle shadow-sm"
                    style="text-align: center; background: #fff;">
                    <thead class="thead-dark bg-gradient-primary text-white">
                        <tr>
                            <th style="width: 3%">#</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Receipt #</th>
                            <th>Status</th>
                            <th>Total</th>
                            <th style="width: 20%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $sum = 0; @endphp
                        @foreach ($sales as $sale)
                            @php $sum += $sale->net; @endphp
                            <tr>
                                <td class="fw-bold">{{ $loop->iteration }}</td>
                                <td>{{ $sale->created_at }}</td>
                                <td>
                                    @if ($sale->customer)
                                        <span class="badge bg-info text-dark">{{ $sale->customer->name }}</span>
                                    @else
                                        <span class="text-muted">Walk-in</span>
                                    @endif
                                </td>
                                <td>
                                    <a class="text-primary fw-bold" data-toggle="modal"
                                        data-target="#view-{{ $sale->id }}" style="cursor:pointer;">
                                        #00{{ $sale->id }}
                                    </a>
                                    <!-- Modal for Receipt Details -->
                                    <div class="modal fade" id="view-{{ $sale->id }}" tabindex="-1">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content border-0 shadow">
                                                <div class="modal-header bg-primary text-white">
                                                    <h5 class="modal-title">Receipt Details</h5>
                                                    <button type="button" class="close text-white" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('print.receipt', $sale->id) }}" method="get">
                                                    <div class="modal-body">
                                                        @php
                                                            $items = App\Models\SoldItem::where('sale_id', $sale->id)
                                                                ->with('unit', 'product')
                                                                ->get();
                                                        @endphp

                                                        <div class="mb-2">
                                                            <strong>Date:</strong>
                                                            {{ $sale->created_at->format('d M Y H:i') }}<br>
                                                            @if ($sale->customer && isset($sale->customer->name))
                                                                <strong>Customer:</strong> {{ $sale->customer->name }}<br>
                                                            @endif
                                                            <strong>Receipt #:</strong> #00{{ $sale->id }}
                                                        </div>
                                                        <table
                                                            class="table table-sm table-bordered table-hover align-middle">
                                                            <thead class="bg-light">
                                                                <tr>
                                                                    {{-- <th><input type="checkbox" id="selectall"></th> --}}
                                                                    <th>Product</th>
                                                                    <th>Unit</th>
                                                                    <th>Price</th>
                                                                    <th>Qty</th>
                                                                    <th>Discount</th>
                                                                    <th>Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($items as $item)
                                                                    <tr>
                                                                        {{-- <td><input type="checkbox" class="chosen"
                                                                            id="{{ $item->id }}"></td> --}}
                                                                        <td class="text-left">
                                                                            {{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}  {{ $item->batch_no ? '| Batch'.$item->batch_no : '' }}
                                                                            <input type="hidden" name="product[]"
                                                                                class="form-control form-control-sm product"
                                                                                value="{{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}">
                                                                        </td>
                                                                        <td>{{ $item->unit->name }} ({{ $item->cont }})
                                                                            <input type="hidden" name="unit[]"
                                                                                class="form-control form-control-sm unit"
                                                                                value="{{ $item->unit->name }}">

                                                                            <input type="hidden" name="cont[]"
                                                                                class="form-control form-control-sm cont"
                                                                                value="{{ $item->cont }}" step="0.01"
                                                                                min="1">
                                                                        </td>
                                                                        <td>
                                                                            <input type="number" name="price[]"
                                                                                class="form-control form-control-sm price"
                                                                                value="{{ $item->price }}" step="0.01"
                                                                                min="0">
                                                                        </td>
                                                                        <td>
                                                                            <input type="number" name="qty[]"
                                                                                class="form-control form-control-sm qty"
                                                                                value="{{ $item->qty }}"
                                                                                step="1" min="0">
                                                                        </td>
                                                                        <td>
                                                                            <input type="number" name="disc[]"
                                                                                class="form-control form-control-sm discount"
                                                                                value="{{ $item->discount }}"
                                                                                step="0.01" min="0">
                                                                        </td>
                                                                        <td>
                                                                            <input type="number" name="amount[]"
                                                                                class="form-control form-control-sm amount"
                                                                                readonly value="{{ $item->amount }}">
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                                <tr class="table-secondary">
                                                                    <td colspan="4"></td>
                                                                    <td class="fw-bold">Total</td>
                                                                    <td><input type="number" id="total"
                                                                            name="total"
                                                                            class="form-control form-control-sm"
                                                                            value="{{ $sale->total }}" readonly></td>
                                                                </tr>
                                                                <tr class="table-secondary">
                                                                    <td colspan="4"></td>
                                                                    <td class="fw-bold">Discount</td>
                                                                    <td><input type="number" id="total-discount"
                                                                            name="discount"
                                                                            class="form-control form-control-sm"
                                                                            value="{{ $sale->discount }}" readonly></td>
                                                                </tr>
                                                                <tr class="table-secondary">
                                                                    <td colspan="4"></td>
                                                                    <td class="fw-bold">Net</td>
                                                                    <td><input type="number" id="net"
                                                                            name="net"
                                                                            class="form-control form-control-sm"
                                                                            value="{{ $sale->net }}" readonly></td>
                                                                </tr>
                                                                <tr class="table-secondary">
                                                                    <td colspan="4"></td>
                                                                    <td class="fw-bold">Paid</td>
                                                                    <td><input type="number" id="paid"
                                                                            name="paid"
                                                                            class="form-control form-control-sm"
                                                                            value="{{ $sale->paid }}"></td>
                                                                </tr>
                                                                <tr class="table-secondary">
                                                                    <td colspan="4"></td>
                                                                    <td class="fw-bold">Due</td>
                                                                    <td><input type="number" id="due"
                                                                            name="due"
                                                                            class="form-control form-control-sm"
                                                                            value="{{ $sale->due }}" readonly></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="modal-footer bg-light">
                                                        <div class="btn-group" role="group" aria-label="Unit Actions">
                                                            <a href="{{ route('edit.customer.order', $sale->id) }}"
                                                                class="btn btn-success">
                                                                <i class="fa-solid fa-pen-to-square"></i> Edit
                                                            </a>
                                                            <button type="submit" class="btn btn-primary print-btn"
                                                                data-sale-id="{{ $sale->id }}">
                                                                <i class="fa-solid fa-print"></i> Print
                                                            </button>
                                                            {{-- <button type="button" class="btn btn-danger delete-btn"
                                                            data-sale-id="{{ $sale->id }}">
                                                            <i class="fa-solid fa-trash-alt"></i> Delete
                                                        </button> --}}
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span
                                        class="badge {{ $sale->status == 'Completed' ? 'bg-success' : 'bg-warning text-dark' }}">
                                        {{ $sale->status }} - {{ $sale->account?->type ?? 'N/A' }}
                                    </span>
                                </td>
                                <td class="fw-bold text-end">
                                    {{ number_format($sale->net) }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        @if ($sale->customer_id)
                                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#exampleModal{{ $sale->id }}">
                                                <i class="fa-solid fa-truck"></i> Delivery note
                                            </button>

                                            <!-- Delivery Note Modal -->
                                            <div class="modal fade" id="exampleModal{{ $sale->id }}" tabindex="-1"
                                                aria-labelledby="exampleModalLabel" aria-hidden="true"
                                                data-backdrop="static" data-keyboard="false">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content border-0 shadow">
                                                        <div class="modal-header bg-primary text-white">
                                                            <h5 class="modal-title" id="exampleModalLabel">
                                                                {{ $sale->customer->name }}'s Delivery Note
                                                            </h5>
                                                            <button type="button" class="close text-white"
                                                                data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        @php
                                                            $items = App\Models\SoldItem::where('sale_id', $sale->id)
                                                                ->with([
                                                                    'product' => function ($q) {
                                                                        $q->withTrashed();
                                                                    },
                                                                    'unit',
                                                                ])
                                                                ->get();
                                                        @endphp
                                                        <form action="{{ route('print.delivery', $sale->id) }}"
                                                            method="get" class="was-validated">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <table class="table table-bordered table-sm align-middle">
                                                                    <thead class="bg-light">
                                                                        <tr>
                                                                            <th>S/N</th>
                                                                            <th>Description</th>
                                                                            <th>Ordered Qty</th>
                                                                            <th>Delivered Qty</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @foreach ($items as $item)
                                                                            <tr>
                                                                                <td>{{ $loop->iteration }}</td>
                                                                                <td>{{ $item->product->product }}</td>
                                                                                <td>{{ $item->qty }}</td>
                                                                                <td>
                                                                                    <input type="number" name="qty[]"
                                                                                        class="form-control form-control-sm"
                                                                                        placeholder="Delivered Qty"
                                                                                        style="text-align: center;"
                                                                                        required>
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                        <tr>
                                                                            <td colspan="3"></td>
                                                                            <td>
                                                                                <select name="vehicle"
                                                                                    class="form-control form-control-sm"
                                                                                    required>
                                                                                    <option selected disabled
                                                                                        value="">
                                                                                        Delivery Method</option>
                                                                                    <option value="Truck">Truck</option>
                                                                                    <option value="Van">Van</option>
                                                                                    <option value="Motorcycle">Motorcycle
                                                                                    </option>
                                                                                </select>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="modal-footer bg-light">
                                                                <button type="button" class="btn btn-secondary"
                                                                    data-dismiss="modal">
                                                                    <i class="fa-solid fa-xmark"></i> Close
                                                                </button>
                                                                <button type="submit" class="btn btn-primary">
                                                                    <i class="fa-solid fa-paper-plane"></i> Submit
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif

                                        <button class="btn btn-danger btn-sm cancel-btn" id="{{ $sale->id }}">
                                            <i class="fa fa-trash-alt"></i> Cancel
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="bg-light">
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Receipt #</th>
                            <th>Status</th>
                            <th class="fw-bold">Total ({{ number_format($sum) }})</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        //global variable
        let type = "";
        let area = "";
        let start = "";
        let end = "";

        $("#area").on("change", function() {
            area = $(this).val();
        });

        $("#start").on("change", function() {
            start = $(this).val();
        });

        $("#end").on("change", function() {
            end = $(this).val();
        });

        $("#type").on("change", function() {
            type = $(this).val();

            if (type == "today") {
                $("#start").attr("required", false).fadeOut("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set date") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", false).fadeOut("slow");

            } else if (type == "set duration") {
                $("#start").attr("required", true).fadeIn("slow");
                $("#end").attr("required", true).fadeIn("slow");
            }
        });

        $("#selectall").on("click", function() {
            if ($(this).is(':checked', true)) {
                $(".chosen").prop('checked', true);
            } else {
                $(".chosen").prop('checked', false);
            }
        });

        $(document).on("click", ".delete-btn", function() {
            let saleId = $(this).data("sale-id");
            let modal = $(this).closest('.modal');

            // Collect selected rows
            let selectedRows = modal.find(".chosen:checked");
            let selectedProductIds = [];

            selectedRows.each(function() {
                selectedProductIds.push($(this).val());
            });

            if (selectedProductIds.length === 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select at least one item!',
                });
                return;
            }

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('sales.bulk.delete') }}",
                        method: "GET", // or "POST" with _token
                        data: {
                            ids: selectedProductIds,
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            // Remove deleted rows from the table
                            selectedRows.each(function() {
                                $(this).closest("tr").remove();
                            });

                            // Recalculate totals
                            let newTotal = 0;
                            let newDiscount = 0;

                            modal.find("tbody tr").each(function() {
                                let amtText = $(this).find("td:last").text()
                                    .replace(/,/g, '').trim();
                                let discountText = $(this).find(
                                    "td:nth-child(6)").text().replace(
                                    /,/g, '').trim();

                                let amount = parseFloat(amtText) || 0;
                                let disc = parseFloat(discountText) || 0;

                                newTotal += amount;
                                newDiscount += disc;
                            });

                            let net = newTotal - newDiscount;

                            // Update totals in the modal
                            modal.find(".fw-bold:contains('Total')").closest("tr")
                                .find("td:last").text(newTotal.toLocaleString());
                            modal.find("td:contains('- Disc')").next().text(
                                newDiscount > 0 ? newDiscount.toLocaleString() :
                                '0');
                            modal.find(".fw-bold:contains('Net')").closest("tr")
                                .find("td:last").text(net.toLocaleString());

                            // Success alert
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted successfully!',
                                showConfirmButton: false,
                                timer: 1500
                            });
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Something went wrong!'
                            });
                        }
                    });
                }
            });
        });

        document.addEventListener("input", function(e) {
            if (e.target.classList.contains("price") ||
                e.target.classList.contains("qty") ||
                e.target.classList.contains("discount") ||
                e.target.id === "paid") {

                let total = 0;
                let totalDiscount = 0;

                document.querySelectorAll("tr").forEach(row => {
                    let price = parseFloat(row.querySelector(".price")?.value) || 0;
                    let qty = parseFloat(row.querySelector(".qty")?.value) || 0;
                    let discount = parseFloat(row.querySelector(".discount")?.value) || 0;

                    let amount = (price * qty) - discount;
                    if (row.querySelector(".amount")) {
                        row.querySelector(".amount").value = amount.toFixed(2);
                    }

                    total += (price * qty);
                    totalDiscount += discount;
                });

                let net = total - totalDiscount;
                let paid = parseFloat(document.getElementById("paid").value) || 0;
                let due = net - paid;

                document.getElementById("total").value = total.toFixed(2);
                document.getElementById("total-discount").value = totalDiscount.toFixed(2);
                document.getElementById("net").value = net.toFixed(2);
                document.getElementById("due").value = due.toFixed(2);
            }
        });

        // document.querySelectorAll('.print-btn').forEach(button => {
        //     button.addEventListener('click', function() {
        //         const saleId = this.getAttribute('data-sale-id');
        //         // Open the print route URL with saleId param in a new tab
        //         window.open(`/print/receipt/${saleId}`, '_blank');
        //     });
        // });

        $(document).on('click', '.cancel-btn', function(e) {
            e.preventDefault();

            let saleId = $(this).attr('id');
            let $row = $(this).closest('tr'); // store the row so we can remove it later

            Swal.fire({
                title: 'Are you sure?',
                text: "This action will cancel the sale.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, cancel it!',
                cancelButtonText: 'No, keep it'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/sales/${saleId}/cancel`,
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            Swal.fire(
                                'Cancelled!',
                                'The sale has been cancelled.',
                                'success'
                            );

                            // Remove the row with a fade-out effect
                            $row.fadeOut(500, function() {
                                $(this).remove();
                            });
                        },
                        error: function() {
                            Swal.fire(
                                'Error!',
                                'Something went wrong while cancelling.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    </script>
@endsection

@endsection
