@extends('layouts.master')

@section('content')

    <input type="hidden" value="{{ Auth::user()->role }}" id="user">

    <div class="card">

        <div class="card-header">
            <p>Sales return</p>
        </div>

        <div class="card-body">

            <table class="table table-striped">
                <tbody>
                    <tr>
                        <td>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode..">
                            <div id="list" style="display:none">
                                <ol id="results"></ol>
                            </div>
                        </td>

                        <td>
                            @if ($sellingCount > 1)
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            @else
                                <input type="hidden" name="area" id="area" class="form-control"
                                    value="{{ $sellings[0]->location_id }}">

                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>

            <br>

            <form action="{{ route('post.sales.return') }}" method="post">
                @csrf

                <div class="row">
                    <div class="col-9">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle shadow-sm"
                                style="text-align: center; background: #fff;">
                                <thead class="thead-light" style="background: #343a40; color: #fff;">
                                    <tr>
                                        <th style="width: 25%; vertical-align: middle;">Product</th>
                                        <th style="width:10%; vertical-align: middle;">Unit</th>
                                        <th style="width:20%; vertical-align: middle;">Price</th>
                                        <th style="width: 20%; vertical-align: middle;">Qty</th>
                                        <th style="width:20%; vertical-align: middle;">Amount</th>
                                        <th style="vertical-align: middle;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody">
                                    <!-- Dynamic rows will be appended here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col was-validated">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="number" name="total" id="total" class="form-control" style="text-align: center"
                            placeholder="Total" readonly>

                        <select name="account" id="account" class="form-control" style="text-align: center"
                            required></select>

                        <select name="customer" id="customer" class="form-control" style="text-align: center">
                            <option disabled selected value="">-- Choose Customer --</option>
                            @foreach ($customers as $customer)
                                <option value="{{ $customer->id }}">-- {{ $customer->name }} --</option>
                            @endforeach
                        </select>

                        <input type="hidden" name="location" id="location" class="form-control"
                            style="text-align: center">

                        <br>
                        <button class="btn btn-primary btn-block"><i class="fa fa-paper-plane"></i> Confirm</button>
                        <a href="{{ route('sales.return.view') }}" class="btn btn-danger btn-block"> <i
                                class="fa fa-times"></i> Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            //Global variables
            var index = 0
            var query;
            var location;
            var ajaxResults;
            var productId;
            var paid;
            var total;
            var price;
            var qty;
            var unit;
            var id;

            var sellingCount = {{ $sellingCount }}; // Access the PHP variable in JavaScript

            if (sellingCount > 1) { // If there are multiple selling sellings
                $("#area").focus();
                $("#area").on("change", function() {
                    location = $(this).val();
                    locationStatus(location); // Call locationStatus function.
                    locationAccounts(location); // Call locationAccount function
                });
            } else { // If there's one selling one selling location
                $("#search").focus();
                location = $("#area").val();
                locationStatus(location); // Call locationStatus function.
                locationAccounts(location); // Call locationAccount function
            }

            function locationStatus(location) {
                $.ajax({
                    url: "{{ route('location.status') }}",
                    method: "get",
                    data: {
                        'location': location
                    },
                    success: function(data) {
                        console.log(data);
                        $("#locationstatus").val(data[0]);
                        $("#location").val(location);

                        if (data[0] == "static") {
                            $("#mteja").fadeIn("slow");
                            $("#salesman").fadeOut("slow");
                        } else {
                            $("#mteja").fadeOut("slow");
                            $("#salesman").fadeIn("slow");
                            $("#salesman").val(data[1]);
                        }
                    }
                });
            }

            function locationAccounts(location) {
                $.ajax({
                    url: "{{ route('get.location.accounts') }}",
                    method: "get",
                    data: {
                        'locationId': location
                    },
                    success: function(response) {
                        var selectElement = $('#account');
                        // Clear any existing options
                        selectElement.empty();
                        // Add the default option if needed
                        selectElement.append(
                            '<option disabled selected value="">-- Account --</option>');

                        // Iterate over the response data and add options
                        $.each(response, function(index, item) {
                            selectElement.append('<option value="' + item.id +
                                '">-- ' +
                                item.type + ' - ' + item.name + ' --</option>');

                        });
                    }
                });
            }

            $("#search").on("change", function() {
                let barcode = $(this).val();
                let locationId = $("#location1").val();

                $.ajax({
                    url: "{{ route('get.product.by.barcode') }}",
                    method: "GET",
                    data: {
                        'barcode': barcode,
                        'locationId': locationId,
                    },
                    success: function(data) {
                        console.log(data)

                        if (data.length == 0) {
                            $("#search").val("");
                            $("#search").focus();
                        } else {
                            var units;
                            var unitprice;

                            for (var i = 0; i < data[0].unit.length; i++) {
                                units = units + '<option value="' + data[0].unit[i].unit.id +
                                    '">' +
                                    data[0].unit[i].unit.name + '</option>';
                                unitprice = data[0].unit[0].selling;
                                //console.log(units);
                            }

                            var tr =

                                '<tr id="tr' + index + '">' +

                                '<td><input type="hidden" name="id[]" value="' +
                                data[0].id + '" id="id' + index +
                                '" class="form-control id" style="text-align: center" readonly>' +
                                data[0].product + '</td>' +

                                '<td><select class="form-control unit" style="text-align: center" name="unit[]" id="unit' +
                                index + '">' + units +
                                '</select><input type="hidden" value="1" name="cont[]" id="cont' +
                                index +
                                '" class="form-control cont" style="text-align: center" readonly></td>' +

                                '<td><input type="text" name="price[]" value="' + unitprice +
                                '" id="price' +
                                index +
                                '" class="form-control price" style="text-align: center"></td>' +

                                '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                                index +
                                '"><i class="fa fa-minus"><i/></button><input type="text" value="1" name="qty[]" id="qty' +
                                index +
                                '" class="form-control qty" style="text-align: center;" required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                                index + '"><i class="fa fa-plus"><i/></button></td>' +

                                '<td><input type="text" name="amount[]" value="' + unitprice +
                                '" id="amount' +
                                index +
                                '" class="form-control amount" style="text-align: center" readonly></td>' +

                                '<td><button type="button" id="' + index +
                                '" class="btn btn-danger removeRow">-</button></td>' +

                                '</tr>';

                            $("#tbody").after(tr);
                            index++;
                            total();
                            $("#search").val("");
                            $("#search").focus();
                        }
                    }

                })
            });

            $("#search").on("keyup", function() {

                isFunctionRunning = true;

                let ujumbe = "No suggestions..";
                let query = $(this).val();
                let locationId = $("#location").val();

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': locationId,
                    },
                    success: function(data) {
                        $("#results").empty();
                        ajaxResults = data;
                        console.log(ajaxResults);
                        // If somthing is typed.
                        if (query != "") {
                            // If ajax response returns nothing.
                            if (ajaxResults.length === 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }
                            // If ajax response returns sothing.
                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    [i] + '" >' +
                                    ajaxResults[i].product + ' | ' +
                                    ajaxResults[i].stock[0]
                                    .qty + ' ' + ajaxResults[i].unit[0].unit.name +
                                    '</button></li>');
                            }
                        }
                    }
                });

                isFunctionRunning = false;
            });

            $(document).on("click", ".items", function() {
                id = $(this).attr("id");
                var product = $(this).html();
                $("#list").fadeOut("slow");

                let units;
                let unitprice;

                // Loop through the assigned units relation.
                for (var i = 0; i < ajaxResults[id].unit.length; i++) {
                    unitprice = ajaxResults[id].unit[0].selling;
                    units = units + '<option value="' + ajaxResults[id].unit[i].unit.id + '">' +
                        ajaxResults[id].unit[i].unit.name + '</option>';
                }

                let tr =

                    '<tr id="tr' + index + '">' +

                    '<td><input type="hidden" name="id[]" value="' +
                    ajaxResults[id].id + '" id="id' + index +
                    '" class="form-control id" style="text-align: center" readonly>' + ajaxResults[id]
                    .product + '</td>' +

                    '<td><select class="form-control unit" style="text-align: center" name="unit[]" id="unit' +
                    index + '">' + units +
                    '</select><input type="hidden" value="1" name="cont[]" id="cont' +
                    index +
                    '" class="form-control cont" style="text-align: center" readonly></td>' +

                    '<td><input type="text" name="price[]" value="' + unitprice +
                    '" id="price' +
                    index +
                    '" class="form-control price" style="text-align: center"></td>' +

                    '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                    index +
                    '"><i class="fa fa-minus"></i></button><input type="text" value="1" name="qty[]" id="qty' +
                    index +
                    '" class="form-control qty" style="text-align: center;" required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                    index + '"><i class="fa fa-plus"></i></button></td>' +

                    '<td><input type="text" name="amount[]" value="' + unitprice +
                    '" id="amount' +
                    index +
                    '" class="form-control amount" style="text-align: center" readonly></td>' +

                    '<td><button type="button" id="' + index +
                    '" class="btn btn-outline-danger removeRow"><i class="fa fa-trash-alt"></i></button></td>' +

                    '</tr>';

                $("#tbody").after(tr);
                index++;
                total();
                $("#search").val("");
                $("#search").focus();

            });

            $(document).on("click", ".removeRow", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
                $("#search").val("");
                $("#search").focus();
            });

            $(document).on("click", ".increment", function() {
                var id = $(this).attr("id").replace("increment", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            $(document).on("click", ".decrement", function() {
                var id = $(this).attr("id").replace("decrement", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                var priceInput = $("#price" + id);
                var price = parseFloat(priceInput.val());
                var amountInput = $("#amount" + id);
                var amount = qty * price;
                amountInput.val(amount);
                total();
                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("change", ".unit", function() {
                let unitId = $(this).val();
                let id = $(this).attr("id").replace("unit", "");
                let productId = $("#id" + id).val();
                let qty = $("#qty" + id).val();
                let locationId = $("#location1").val();
                console.log(productId);

                let row = {
                    index: id,
                    id: $("#id" + id).val(),
                    name: $("#product" + id).val(),
                    unit: '',
                    selected_unit: $("#unit" + id).val(),
                    cont: $("#cont" + id).val(),
                    price: $("#price" + id).val(),
                    qty: $("#qty" + id).val(),
                    disc: $("#disc" + id).val(),
                    amount: $("#amount" + id).val(),
                    total: $("#total").val(),
                }

                let saleDetails = {
                    total: $("#total").val(),
                    transaport: $("#transport").val(),
                    discount: $("#discount").val(),
                    net: $("#net").val(),
                    due: $("#due").val(),
                    locationId: $("#location1").val(),
                    locationstatus: $("#locationstatus").val(),
                }

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unitId,
                        'productId': productId,
                        'locationId': locationId,
                        'row': row,
                        'details': saleDetails,
                    },

                    success: function(data) {
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(data.selling);
                        $("#amount" + id).val(data.selling * qty);
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("keyup", ".price", function() {
                price = $(this).val();
                id = $(this).attr("id").replace("price", "");
                qty = $("#qty" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            $(document).on("keyup", ".qty", function() {
                qty = $(this).val();
                id = $(this).attr("id").replace("qty", "");
                price = $("#price" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            function total() {
                var amount = 0;
                $(".amount").each(function() {
                    amount += Number($(this).val());
                });
                $("#total").val(amount);
            }
        });
    </script>
@endsection

@endsection
