@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <div class="btn-group" role="group">
                <h4>Total Eligible Customers: <span class="text-primary">{{ $eligibleCustomersCount }}</span></h4>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm border rounded" id="data-table">
                    <thead class="table-dark text-uppercase text-center">
                        <tr>
                            <th>Customer Name</th>
                            <th>Total Sales</th>
                            <th>Total Amount Last 6 Sales</th>
                            <th>Royalty Discount %</th>
                            <th>Discount Amount</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($result as $customer)
                            <tr class="align-middle">
                                <td class="text-center fw-bold">{{ $customer['customer_name'] }}</td>
                                <td class="text-center">{{ $customer['total_sales'] }}</td>
                                <td class="text-center text-success fw-semibold">
                                    {{ number_format($customer['total_amount_last_six'], 2) }}
                                </td>
                                <td class="text-center text-primary fw-semibold">
                                    {{ $customer['royalty_discount_percent'] }}%
                                </td>
                                <td class="text-center text-warning fw-bold">
                                    {{ number_format($customer['discount_amount'], 2) }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary fw-bold">No Eligible Customers Found</h5>
                                        <p class="text-muted mb-0">Please try again later...</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>

                    <tfoot class="bg-light text-center text-uppercase fw-bold">
                        <tr>
                            <th>Customer Name</th>
                            <th>Total Sales</th>
                            <th>Total Amount Last 6 Sales</th>
                            <th>Royalty Discount %</th>
                            <th>Discount Amount</th>
                        </tr>
                    </tfoot>
                </table>

                <!-- Optional custom CSS for extra flair -->
                <style>
                    #data-table tbody tr:hover {
                        background-color: #f1f8ff;
                        transition: 0.3s;
                    }

                    #data-table th,
                    #data-table td {
                        vertical-align: middle;
                    }

                    #data-table tfoot {
                        border-top: 2px solid #dee2e6;
                    }
                </style>

            </div>
        </div>
    </div>

    @section('scripts')
        <script></script>
    @endsection

@endsection
