<!DOCTYPE html>
<html>

<head>
    <title>Requisition #{{ $requisition->id }}</title>
    <style>
        body {
            font-family: 'Calibri', sans-serif;
            margin: 0;
            background: #f4f6f8;
            color: #333;
        }

        .document {
            background: white;
            max-width: 900px;
            margin: 30px auto;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.1);
        }

        /* Header */
        .header {
            border-bottom: 4px solid #1f4e79;
            padding-bottom: 15px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header img {
            max-height: 60px;
        }

        .header-title {
            text-align: right;
        }

        .header-title h1 {
            margin: 0;
            font-size: 26px;
            color: #1f4e79;
        }

        .header-title small {
            font-size: 14px;
            color: #555;
        }

        /* Section headings */
        h2 {
            font-size: 18px;
            color: #1f4e79;
            margin-bottom: 8px;
            border-bottom: 2px solid #e0e0e0;
            padding-bottom: 4px;
        }

        /* Info grid */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 8px 20px;
            font-size: 14px;
            margin-bottom: 20px;
        }

        .info-grid div strong {
            display: inline-block;
            width: 120px;
            color: #444;
        }

        /* Table */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        thead {
            background: #1f4e79;
            color: white;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 14px;
        }

        tbody tr:nth-child(even) {
            background: #f9f9f9;
        }

        /* Footer signatures */
        .signatures {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }

        .sign-box {
            width: 40%;
            text-align: center;
        }

        .sign-line {
            margin-top: 50px;
            border-top: 1px solid #000;
            padding-top: 5px;
            font-size: 13px;
        }

        /* Print */
        @media print {
            body {
                background: white;
            }

            .document {
                box-shadow: none;
                margin: 0;
                border-radius: 0;
            }
        }
    </style>
</head>

<body onload="window.print()">

    <div class="document">

        {{-- HEADER --}}
        <div style="text-align:center; margin-bottom: 10px;">
            {{-- <img src="{{ asset('dist/img/company-logo.png') }}" alt="Company Logo" style="height:60px;"><br> --}}
            <h2 style="margin:5px 0; font-weight:bold;">{{ $profileData->selling->location->name }}</h2>
            <p style="margin:2px 0; font-size:14px;">
                {{ $profileData->slogan  }}
            </p>
            <p style="margin:2px 0; font-size:13px;">
                {{ $profileData->address }}
            </p>
            <p style="margin:2px 0; font-size:13px;">
                {{ $profileData->phone ?? '' }} {{ $profileData->email ?? '' }} {{ $profileData->website ?? '' }}
            </p>
            <hr style="border:1px solid #000; margin-top:10px;">
        </div>

        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Note</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($requisition->items as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $item->product_name }}</td>
                        <td>{{ $item->qty }} {{ $item->unit->name ?? '-' }}</td>
                        <td>{{ $item->note ?? '-' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{-- SIGNATURES --}}
        {{-- <div class="signatures">
            <div class="sign-box">
                <div class="sign-line">Requested By</div>
            </div>
            <div class="sign-box">
                <div class="sign-line">Approved By</div>
            </div>
        </div> --}}
    </div>

</body>

</html>
