@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#registerModal">
                <i class="fa-solid fa-plus"></i>
                Register new user
            </button>

            <div class="modal fade" id="registerModal" tabindex="-1" role="dialog" aria-labelledby="registerModalLabel"
                aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="registerModalLabel">Register new user</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form method="post" action="{{ route('store.user') }}" class="was-validated">
                            @csrf
                            <div class="modal-body">
                                <label for="role">Role</label>
                                <select name="role" class="form-control" id="role" required>
                                    <option disabled selected value="">-- Role--</option>
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->name }}">
                                            -- {{ $role->name }} --
                                        </option>
                                    @endforeach
                                </select>

                                <label for="name">Full name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    placeholder="Full name" required>

                                <label for="phone">Contact</label>
                                <input type="text" name="phone" class="form-control" placeholder="Phone" id="phone"
                                    required>

                                <label for="username">User name</label>
                                <input type="text" name="username" class="form-control" placeholder="Enter User Name"
                                    required>

                                <label for="password">Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Password" required>

                                <label for="main">Main location</label>
                                <select name="main" class="form-control" id="main" required>
                                    <option disabled selected value="">-- Main Location --</option>
                                    <option value="all">-- All --</option>
                                    @foreach ($mains as $main)
                                        <option value="{{ $main->id }}">
                                            -- {{ $main->location->name }} --
                                        </option>
                                    @endforeach
                                </select>

                                <label for="selling">Selling Location</label>
                                <select name="selling" class="form-control" id="selling" required>
                                    <option disabled selected value="">-- Selling Location --</option>
                                    <option value="all">-- All --</option>
                                    @foreach ($sellings as $sellinglocation)
                                        <option value="{{ $sellinglocation->id }}">
                                            -- {{ $sellinglocation->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="modal-footer">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn-secondary btn-sm" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn-primary btn-sm">Register user</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle" id="data-table">
                    <thead class="thead-dark">
                        <tr>
                            <th scope="col" class="text-center">#</th>
                            <th scope="col" class="text-center">Role</th>
                            <th scope="col" class="text-center">Name</th>
                            <th scope="col" class="text-center">Phone</th>
                            <th scope="col" class="text-center">Selling Location</th>
                            <th scope="col" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($users as $user)
                            <tr>
                                <th scope="row" class="text-center">{{ $loop->iteration }}</th>
                                <td class="text-center">
                                    <span class="badge badge-info">{{ $user->role }}</span>
                                </td>
                                <td class="text-center">{{ $user->name }}</td>
                                <td class="text-center">{{ $user->phone }}</td>
                                <td class="text-center">
                                    <span
                                        class="badge badge-secondary">{{ $user->selling->location->name ?? 'All' }}</span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        {{-- Edit modal --}}
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target="#edit-{{ $user->id }}">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </button>

                                        <div class="modal fade" id="edit-{{ $user->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Update user details</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <form action="{{ route('update.user', $user->id) }}" method="POST"
                                                        class="was-validated">
                                                        @csrf
                                                        @method('PUT')

                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="role-{{ $user->id }}">Role</label>
                                                                <select name="role" class="form-control"
                                                                    id="role-{{ $user->id }}" required>
                                                                    <option selected value="{{ $user->role }}">
                                                                        -- {{ $user->role }} --</option>
                                                                    @foreach ($roles as $role)
                                                                        @if ($role->name !== $user->role)
                                                                            <option value="{{ $role->name }}">--
                                                                                {{ $role->name }} --</option>
                                                                        @endif
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="name-{{ $user->id }}">Full Name</label>
                                                                <input type="text" name="name" class="form-control"
                                                                    id="name-{{ $user->id }}"
                                                                    value="{{ $user->name }}" required>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="phone-{{ $user->id }}">Phone</label>
                                                                <input type="text" name="phone" class="form-control"
                                                                    id="phone-{{ $user->id }}"
                                                                    value="{{ $user->phone }}" required>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="username-{{ $user->id }}">Username</label>
                                                                <input type="text" name="username"
                                                                    value="{{ $user->username }}"
                                                                    id="username-{{ $user->id }}"
                                                                    class="form-control" required>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="password-{{ $user->id }}">Password <small
                                                                        class="text-muted">(Leave blank to keep
                                                                        current)</small></label>
                                                                <input type="password" name="password"
                                                                    id="password-{{ $user->id }}"
                                                                    class="form-control" autocomplete="new-password">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="location-{{ $user->id }}">Selling
                                                                    Location</label>
                                                                <select name="selling" class="form-control"
                                                                    id="location-{{ $user->id }}" required>
                                                                    <option value="all"
                                                                        {{ $user->selling_location_id == null ? 'selected' : '' }}>
                                                                        -- All --</option>
                                                                    @foreach ($sellings as $selling)
                                                                        <option value="{{ $selling->id }}"
                                                                            {{ $user->selling_id == $selling->id ? 'selected' : '' }}>
                                                                            -- {{ $selling->location->name }} --
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <div class="btn-group" role="group">
                                                                <button type="button" class="btn btn-secondary btn-sm"
                                                                    data-dismiss="modal">Cancel</button>
                                                                <button type="submit"
                                                                    class="btn btn-primary btn-sm">Update</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Delete button --}}
                                        <button type="button" class="btn btn-danger btn-sm delete"
                                            id="{{ $user->id }}">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        <form action="{{ route('delete.user', $user->id) }}" method="POST"
                                            id="deleteform{{ $user->id }}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Units Found</h5>
                                        <p class="text-muted mb-0">You haven't added any Units yet.<br>
                                            <span class="small">Click <strong>Register Unit</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });

            });
        </script>
    @endsection

@endsection
