@extends('layouts.master')

@section('content')

    <input type="hidden" value="{{ Auth::user()->role }}" id="user">

    <div class="card">

        <div class="card-header">
            <p>Purchase return</p>
        </div>

        <div class="card-body">
            <table class="table table-striped table-hover">
                <tbody>
                    <tr>
                        <td>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode..">
                            <div id="list" style="display:none">
                                <ol id="results"></ol>
                            </div>
                        </td>

                        <td>
                            @if ($sellingCount > 1)
                                <select name="area" id="area" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            @else
                                <input type="hidden" name="area" id="area" class="form-control"
                                    value="{{ $sellings[0]->location_id }}">

                            <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>

            <br>

            <form action="{{ route('post.purchase.return') }}" onsubmit="showSpinner" method="post">
                @csrf
                <div class="row">

                    <div class="col-9">

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle shadow-sm"
                                style="text-align: center; background: #fff;">
                                <thead class="thead-light">
                                    <tr>
                                        <th style="width: 25%; vertical-align: middle;">Product</th>
                                        <th style="width: 15%; vertical-align: middle;">Unit</th>
                                        <th style="width: 15%; vertical-align: middle;">Price</th>
                                        <th style="vertical-align: middle;">Qty</th>
                                        <th style="width: 15%; vertical-align: middle;">Amount</th>
                                        <th style="vertical-align: middle;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody">
                                    <!-- Dynamic rows go here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col was-validated">

                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="number" name="total" id="total" class="form-control" style="text-align: center"
                            placeholder="Total" readonly>

                        <select name="account" id="account" class="form-control" style="text-align: center"
                            required></select>

                        <select name="supplier" id="supplier" class="form-control" required style="text-align: center">
                            <option disabled selected value=""> -- Choose Supplier -- </option>
                            @foreach ($suppliers as $supplier)
                                <option value="{{ $supplier->id }}">-- {{ $supplier->name }} --</option>
                            @endforeach
                        </select>

                        @if ($sellingCount > 1)
                            <select name="area" id="area" class="form-control" style="text-align: center" required>
                                <option disabled selected value="">-- Store Location --</option>
                                @foreach ($sellings as $area)
                                    <option value="{{ $area->location_id }}">-- {{ $area->location->name }} --</option>
                                    @foreach ($area->storage as $storage)
                                        <option value="{{ $storage->location_id }}">
                                            -- {{ $storage->location->name }} --</option>
                                    @endforeach
                                @endforeach
                            </select>
                        @else
                            <select name="area" id="area" class="form-control" style="text-align: center" required>
                                <option disabled selected value="">-- Store Location --</option>
                                <option value="{{ $sellings[0]->location_id }}">
                                    -- {{ $sellings[0]->location->name }} --
                                </option>
                                @foreach ($sellings[0]->storage as $storage)
                                    <option value="{{ $storage->location_id }}">
                                        -- {{ $storage->location->name }} --</option>
                                @endforeach
                            </select>
                        @endif

                        <input type="hidden" name="location" id="location1" class="form-control"
                            style="text-align: center">
                        <br>

                        <button class="btn btn-primary btn-block"><i class="fas fa-paper-plane"></i> Confirm</button>
                        <a href="{{ route('purchase.return.view') }}" class="btn btn-danger btn-block"> <i
                                class="fas fa-times"></i> Cancel</a>

                    </div>

                </div>

            </form>

        </div>

    </div>

@section('scripts')
    <script>
        $(document).ready(function() {

            //Global variables
            var index = 0;
            var query;
            var location;
            var ajaxResults;
            var productId;
            var paid;
            var net;
            var total;
            var discount;
            var price;
            var qty;
            var unit;
            var id;

            var sellingCount = {{ $sellingCount }}; // Access the PHP variable in JavaScript

            if (sellingCount > 1) { // If there are multiple selling sellings
                $("#area").focus();
                $("#area").on("change", function() {
                    location = $(this).val();
                    locationAccounts(location); // Call locationAccount function.
                });
            } else { // If there's one selling one selling location.
                $("#search").focus();
                location = $("#area").val();
                locationAccounts(location); // Call locationAccount function.
            }

            function locationAccounts(location) {
                $("#location1").val(location);

                $.ajax({
                    url: "{{ route('get.location.accounts') }}",
                    method: "get",
                    data: {
                        'locationId': location
                    },
                    success: function(response) {
                        var selectElement = $('#account');
                        // Clear any existing options
                        selectElement.empty();
                        // Add the default option if needed
                        selectElement.append(
                            '<option disabled selected value="">-- Account --</option>');
                        selectElement.append(
                            '<option value="advance" id="advance">-- Advance --</option>');
                        // Iterate over the response data and add options
                        $.each(response, function(index, item) {
                            selectElement.append('<option value="' + item.id + '">-- ' +
                                item.type + ' - ' + item.name + ' --</option>');
                        });
                    }
                });
            };

            $("#location").on("change", function() {
                location = $(this).val();
                $("#location1").val(location);
                $.ajax({
                    url: "{{ route('get.location.accounts') }}",
                    method: "get",
                    data: {
                        'locationId': location
                    },
                    success: function(response) {
                        var selectElement = $('#account');
                        // Clear any existing options
                        selectElement.empty();
                        // Add the default option if needed
                        selectElement.append(
                            '<option disabled selected value="">-- Account --</option>');
                        selectElement.append(
                            '<option value="advance" id="advance">-- Advance --</option>');
                        // Iterate over the response data and add options
                        $.each(response, function(index, item) {
                            selectElement.append('<option value="' + item.id + '">-- ' +
                                item.type + ' - ' + item.name + ' --</option>');
                        });
                    }
                });
            });

            $("#search").on("change", function() {
                let barcode = $(this).val();
                let locationId = $("#location1").val();

                $.ajax({
                    url: "{{ route('get.product.by.barcode') }}",
                    method: "GET",
                    data: {
                        'barcode': barcode,
                        'locationId': locationId,
                    },
                    success: function(data) {
                        console.log(data)

                        if (data.length == 0) {
                            $("#search").val("");
                            $("#search").focus();
                        } else {
                            var units;
                            var unitprice;

                            for (var i = 0; i < data[0].unit.length; i++) {
                                units = units + '<option value="' + data[0].unit[i].unit.id +
                                    '">' +
                                    data[0].unit[i].unit.name + '</option>';
                                unitselling = data[0].unit[0].selling;
                                //console.log(units);
                            }

                            var tr =

                                '<tr id="tr' + index + '">' +

                                '<td><input type="hidden" name="id[]" value="' +
                                data[0].id + '" id="id' + index +
                                '" class="form-control id" style="text-align: center" readonly>' +
                                data[0].product + '</td>' +

                                '<td><select class="form-control unit" style="text-align: center" name="unit[]" id="unit' +
                                index + '">' + units +
                                '</select><input type="hidden" value="1" name="cont[]" id="cont' +
                                index +
                                '" class="form-control cont" style="text-align: center" readonly></td>' +

                                '<td><input type="text" name="buying[]" value="' + data[0]
                                .buying +
                                '" id="buying' +
                                index +
                                '" class="form-control buying" style="text-align: center"></td>' +

                                '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                                index +
                                '"><i class="fa fa-minus"></i></button><input type="text" value="1" name="qty[]" id="qty' +
                                index +
                                '" class="form-control qty" style="text-align: center;" required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                                index + '"><i class="fa fa-plus"></i></button></td>' +

                                '<td><input type="text" name="amount[]" value="' + data[0]
                                .buying +
                                '" id="amount' +
                                index +
                                '" class="form-control amount" style="text-align: center" readonly></td>' +

                                '<td><button type="button" id="' + index +
                                '" class="btn btn-outline-danger removeRow"><i class="fas fa-trash-alt"></i></button></td>' +

                                '</tr>';

                            $("#tbody").after(tr);
                            index++;
                            total();
                            $("#search").val("");
                            $("#search").focus();;
                        }
                    }

                })
            });

            $("#search").on("keyup", function() {
                let ujumbe = "No suggestions..";
                let query = $(this).val();
                let locationId = $("#location1").val();

                $.ajax({

                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': locationId,
                    },
                    success: function(data) {
                        $("#results").empty();
                        ajaxResults = data;
                        console.log(ajaxResults);

                        if (query != "") {
                            if (ajaxResults.length == 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            // If ajax response returns sothing.
                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    [i] + '" >' +
                                    ajaxResults[i].product + ' | ' +
                                    ajaxResults[i].stock[0]
                                    .qty + ' ' + ajaxResults[i].unit[0].unit.name +
                                    '</button></li>');
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".items", function() {
                id = $(this).attr("id");
                var product = $(this).html();
                $("#list").fadeOut("slow");

                var units;
                var unitbuying;
                var unitselling;

                for (var i = 0; i < ajaxResults[id].unit.length; i++) {
                    units = units + '<option value="' + ajaxResults[id].unit[i].unit.id + '">' +
                        ajaxResults[id].unit[i].unit.name + '</option>';
                    unitselling = ajaxResults[id].unit[0].selling;
                    unitbuying = ajaxResults[id].buying;
                }

                var tr =

                    '<tr id="tr' + index + '">' +

                    '<td><input type="hidden" name="id[]" value="' +
                    ajaxResults[id].id + '" id="id' + index +
                    '" class="form-control id" style="text-align: center" readonly>' + ajaxResults[id]
                    .product + '</td>' +

                    '<td><select class="form-control unit" style="text-align: center" name="unit[]" id="unit' +
                    index + '">' + units +
                    '</select><input type="hidden" value="1" name="cont[]" id="cont' +
                    index +
                    '" class="form-control cont" style="text-align: center" readonly></td>' +

                    '<td><input type="text" name="buying[]" value="' + unitbuying +
                    '" id="buying' +
                    index +
                    '" class="form-control buying" style="text-align: center"></td>' +

                    '<td style="display:flex"><button type="button" class="btn btn-outline-warning btn-block decrement" id="' +
                    index +
                    '"><i class="fa fa-minus"></i></button><input type="text" value="1" name="qty[]" id="qty' +
                    index +
                    '" class="form-control qty" style="text-align: center;" required><button type="button" class="btn btn-outline-success btn-block increment" id="increment' +
                    index + '"><i class="fa fa-plus"></i></button></td>' +

                    '<td><input type="text" name="amount[]" value="' + unitbuying +
                    '" id="amount' +
                    index +
                    '" class="form-control amount" style="text-align: center" readonly></td>' +

                    '<td><button type="button" id="' + index +
                    '" class="btn btn-outline-danger removeRow"><i class="fas fa-trash-alt"></i></button></td>' +

                    '</tr>';

                $("#tbody").after(tr);
                index++;
                total();
                $("#search").val("");
                $("#search").focus();
            });

            $(document).on("click", ".removeRow", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
                $("#search").val("");
                $("#seach").focus();
            });

            $(document).on("click", ".increment", function() {
                var id = $(this).attr("id").replace("increment", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            $(document).on("click", ".decrement", function() {
                var id = $(this).attr("id").replace("decrement", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                var priceInput = $("#buying" + id);
                var price = parseFloat(priceInput.val());
                var amountInput = $("#amount" + id);
                var amount = qty * price;
                amountInput.val(amount);
                total();
                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("change", ".unit", function() {
                let unit = $(this).val();
                let id = $(this).attr("id").replace("unit", "");
                let productId = $("#id" + id).val();
                let qty = $("#qty" + id).val();
                let locationId = $("#location1").val();

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unit,
                        'productId': productId,
                        'locationId': locationId,
                    },
                    success: function(data) {
                        console.log(data);
                        $("#cont" + id).val(data.unit_cont);
                        $("#buying" + id).val(data.product.buying * data.unit_cont * qty);
                        $("#amount" + id).val(data.product.buying * data.unit_cont * qty);
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }

                });
            });

            $(document).on("keyup", ".buying", function() {
                price = $(this).val();
                id = $(this).attr("id").replace("buying", "");
                qty = $("#qty" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            $(document).on("keyup", ".qty", function() {
                qty = $(this).val();
                id = $(this).attr("id").replace("qty", "");
                price = $("#buying" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            function total() {
                var amount = 0;
                $(".amount").each(function() {
                    amount += Number($(this).val());
                });

                $("#total").val(amount);
                $("#net").val($("#total").val());
            }

            $("#supplier").on("keyup", function() {

                var ujumbe = "No suggestions..";
                var query = $(this).val();

                $.ajax({

                    url: "{{ route('get.supplier') }}",
                    method: "get",
                    data: {
                        'query': query,
                    },
                    success: function(data) {

                        $("#supplierlist2").empty();

                        console.log(data);

                        if (query != "") {
                            if (data.length == 0) {
                                $("#supplierlist1").fadeIn("slow");
                                $("#supplierlist2").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < data.length; i++) {
                                $("#supplierlist1").fadeIn("slow");
                                $("#supplierlist2").append(
                                    '<li><button type="button" class="form-control customer btn btn-outline-secondary" id="' +
                                    i + '" >' + data[i].name + '</button></li>');

                                $(".customer").on("click", function() {
                                    var customer = $(this).html();
                                    $("#supplier").val(customer);
                                    $("#supplierlist2").fadeOut("slow");
                                });
                            }
                        }
                    }
                });
            });
        });
    </script>
@endsection

@endsection
