@extends('layouts.master')

@section('content')
    <div class="card table-responsive">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete"><i class="fa fa-trash-alt"></i> Delete
                    Selected</button>
                <a href="{{ route('new.purchase.order', 'new')}}" class="btn btn-primary btn-sm"> <i class="fa fa-plus"></i> New
                    purchase order </a>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-striped table-hover align-middle" id="customer">
                <thead class="thead-dark">
                    <tr>
                        <th width="40"><input type="checkbox" id="master"></th>
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Total (₦)</th>
                        <th>Location</th>
                        <th>User</th>
                        <th style="width: 20%;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if (count($purchaseOrders) > 0)
                        @foreach ($purchaseOrders as $purchaseOrder)
                            <tr>
                                <td>
                                    <input type="checkbox" class="sub_chk" id="{{ $purchaseOrder->id }}">
                                </td>
                                <td>{{ \Carbon\Carbon::parse($purchaseOrder->date)->format('d M, Y') }}</td>
                                <td>
                                    <span class="fw-bold">{{ $purchaseOrder->supplier->name }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-success">
                                        {{ number_format($purchaseOrder->total, 2) }}
                                    </span>
                                </td>
                                <td>{{ $purchaseOrder->selling->location->name }}</td>
                                <td>{{ $purchaseOrder->user->name }}</td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Unit Actions">
                                        {{-- Edit --}}
                                        <a  href="{{ route('edit.purchase.order', ['id' => $purchaseOrder->id, 'flag' => 'edit']) }}"
                                            class="btn btn-info btn-sm" title="Edit">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </a>

                                        {{-- Purchase --}}
                                        <a href="{{ route('purchase.view', ['id' => $purchaseOrder->id, 'status' => 'purchase-order']) }}"
                                            class="btn btn-success btn-sm" title="Purchase">
                                            <i class="fa-solid fa-cart-shopping"></i> Purchase
                                        </a>

                                        {{-- View --}}
                                        <a href="{{ route('get.purchase.order', $purchaseOrder->id) }}"
                                            class="btn btn-primary btn-sm" title="View">
                                            <i class="fa fa-eye"></i> View
                                        </a>

                                        {{-- Delete --}}
                                        <button type="button" class="btn btn-danger delete btn-sm"
                                            id="{{ $purchaseOrder->id }}" title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        <form action="{{ route('delete.purchase.order', $purchaseOrder->id) }}"
                                            method="GET" id="deleteform{{ $purchaseOrder->id }}" style="display: none;">
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <div class="d-flex flex-column align-items-center">
                                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                        style="width: 80px; opacity: 0.5;">
                                    <h5 class="mt-3 text-secondary font-weight-bold">No Data Found</h5>
                                    <p class="text-muted mb-0">You haven't added any data yet.<br>
                                        <span class="small">Click <strong>New purchase order</strong> to get
                                            started.</span>
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endif
                </tbody>
                <tfoot class="thead-light">
                     <tr>
                        <th width="40"><input type="checkbox" id="master"></th>
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Total (₦)</th>
                        <th>Location</th>
                        <th>User</th>
                        <th style="width: 20%;">Action</th>
                    </tr>
                </tfoot>
            </table>
            @if (method_exists($purchaseOrders, 'links'))
                <div class="d-flex justify-content-end mt-3">
                    {!! $purchaseOrders->links() !!}
                </div>
            @endif
        </div>
    </div>

@section('scripts')
    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $('#master').on('click', function(e) {

            if ($(this).is(':checked', true)) {
                $(".sub_chk").prop('checked', true);
            } else {
                $(".sub_chk").prop('checked', false);
            }

        });

        $("#bulkdelete").on("click", function() {
            var selected = [];

            $(".sub_chk:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one purchaseOrder!!',
                });

            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('purchase.order.bulk.delete') }}",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: 'Deleted Successfully',
                                background: '#e6ffed',
                                showConfirmButton: false,
                                timer: 2500,
                                timerProgressBar: true,
                                position: 'top-end',
                                toast: true,
                                customClass: {
                                    popup: 'swal2-border-radius'
                                }
                            });
                        });
                    }
                });
            }
        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
