@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group" aria-label="Unit Actions">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete"> <i class="fa fa-trash-alt"></i> Delete
                    Selected</button>
                <a href="{{ route('new.profoma.invoice') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New
                    profoma
                    invoice </a>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle" id="customer">
                    <thead class="table-dark">
                        <tr>
                            <th width="40px" class="text-center">
                                <input type="checkbox" id="master" title="Select All">
                            </th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Total (TZS)</th>
                            <th>Location</th>
                            <th>User</th>
                            <th style="width: 25%">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($profomas as $profoma)
                            @php
                                $overAllTotal += $profoma->total;
                            @endphp
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" class="sub_chk" id="{{ $profoma->id }}">
                                </td>
                                <td>{{ \Carbon\Carbon::parse($profoma->date)->format('d M Y') }}</td>
                                <td>{{ $profoma->customer->name ?? '-' }}</td>
                                <td>{{ number_format($profoma->total, 2) }}</td>
                                <td>{{ $profoma->selling->location->name ?? '-' }}</td>
                                <td>{{ $profoma->user->name ?? '-' }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        {{-- Edit --}}
                                        <a href="{{ route('new.profoma.invoice', ['id' => $profoma->id, 'status' => 'edit']) }}"
                                            class="btn btn-info btn-sm" title="Edit">
                                            <i class="fa-solid fa-pen-to-square fa-lg"></i> Edit
                                        </a>

                                        {{-- Sale --}}
                                        <a href="{{ route('sale.index', ['id' => $profoma->id, 'status' => 'profoma']) }}"
                                            class="btn btn-success btn-sm" title="Convert to Sale">
                                            <i class="fa-solid fa-cart-shopping"></i> Sale
                                        </a>

                                        {{-- View --}}
                                        <a href="{{ route('get.profoma.invoice', $profoma->id) }}"
                                            class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i> View
                                        </a>

                                        {{-- Delete --}}
                                        <button type="button" class="btn btn-sm btn-danger delete"
                                            id="{{ $profoma->id }}" title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        <form action="{{ route('profoma.delete', $profoma->id) }}" method="GET"
                                            id="deleteform{{ $profoma->id }}" style="display:none;">
                                            @csrf
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Profomas Found</h5>
                                        <p class="text-muted mb-0">You haven't added any profoma yet.<br>
                                            <span class="small">Click <strong>Register Profoma</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="table-light">
                        <tr>
                            <th class="text-center">
                                <input type="checkbox" id="master" title="Select All">
                            </th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Total ({{ number_format($overAllTotal) }}TZS)</th>
                            <th>Location</th>
                            <th>User</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $('#master').on('click', function(e) {
                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }
            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one profoma!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('profoma.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted Successfully!',
                                    background: '#e6ffed',
                                    showConfirmButton: false,
                                    timer: 2500,
                                    timerProgressBar: true,
                                    position: 'top-end',
                                    toast: true,
                                    customClass: {
                                        popup: 'swal2-border-radius'
                                    }
                                });
                            });
                        }
                    });
                }
            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
