@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <h5>Products About To Expire</h5>
        </div>

        <div class="card-body">
            <table class="table table-striped table-hover text-center" id="customer">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Available Stock</th>
                        <th>Expiration Date</th>
                        <th>Expiration Notification</th>
                        <th>Location</th>
                    </tr>
                </thead>
            
                <tbody>
                    @foreach ($aboutToExpireItems as $index => $item)
                        @php
                            $stock = App\Models\Stock::where('product_id', $item->product_id)
                                ->where('location_id', $item->location_id)
                                ->with('unit')
                                ->first();
            
                            $formattedStock = 'N/A'; // Default if no stock is found
            
                            if ($stock) {
                                $answer = [];
                                $units = App\Models\UnitAssigned::where('product_id', $item->product_id)
                                    ->where('unit_id', '!=', null)
                                    ->where('unit_cont', '>', 0)
                                    ->with('unit')
                                    ->orderBy('unit_cont', 'desc')
                                    ->get();
            
                                $remainder = $stock->qty;
                                $x = 0;
                                while ($remainder > 0 && isset($units[$x])) {
                                    $current_cont = $units[$x]->unit_cont;
                                    if ($remainder >= $current_cont) {
                                        $current_qty = (int) ($remainder / $current_cont);
                                        $remainder = $remainder % $current_cont;
                                        if ($current_qty) {
                                            $answer[] = $current_qty . ' ' . $units[$x]->unit->name;
                                        }
                                    }
                                    $x++;
                                }
            
                                if (!empty($answer)) {
                                    $formattedStock = implode(', ', $answer);
                                }
                            }
                        @endphp
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ optional($item->product)->product }}</td>
                            <td>{{ $formattedStock }}</td>
                            <td>{{ $item->exp }}</td>
                            <td>{{ $item->exp_not }} Month(s)</td>
                            <td>{{ optional($item->location)->name }}</td>
                        </tr>
                    @endforeach
                </tbody>
            
                <tfoot>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Available Stock</th>
                        <th>Expiration Date</th>
                        <th>Expiration Notification</th>
                        <th>Location</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

@section('scripts')
    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
@endsection

@endsection
