@extends('layouts.master')

@section('content')

    <form action="{{ route('production.report') }}" method="get">

        <div class="card table-responsive">
            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="genre" id="genre" class="form-control" style="text-align: center" required>
                                    <option disabled selected value="">-- Select Genre --</option>
                                    <option value="1">-- Orders --</option>
                                    <option value="2">-- Stock --</option>
                                </select>
                            </td>

                            <td>
                                <select name="type" id="type" class="form-control"
                                    style="text-align: center; display:none" required>
                                    <option disabled selected value="">-- Select Type --</option>
                                    <option value="1">-- Recieved --</option>
                                    <option value="2">-- Dispatched --</option>
                                </select>
                            </td>

                            <td>
                                <select name="duration" id="duration" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Duration --</option>
                                    <option value="1">-- Today --</option>
                                    <option value="2">-- Set Date --</option>
                                    <option value="3">-- Set Duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-hover table-striped align-middle shadow-sm"
                        style="text-align: center; background: #fff;">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Date</th>
                                <th scope="col">Customer</th>
                                <th scope="col">Total</th>
                                <th scope="col">Paid</th>
                                <th scope="col">Due</th>
                                <th scope="col">Status</th>
                                <th scope="col">User</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>

                        @php
                            $total = 0;
                            $paid = 0;
                            $due = 0;
                        @endphp

                        <tbody>
                            @foreach ($orders as $order)
                                @php
                                    $total += $order->total;
                                    $paid += $order->paid;
                                    $due += $order->due;
                                @endphp
                                <tr>
                                    <td><span class="badge bg-primary">{{ $loop->iteration }}</span></td>
                                    <td>{{ \Carbon\Carbon::parse($order->created_at)->format('d M, Y') }}</td>
                                    <td><strong>{{ $order->customer->name }}</strong></td>
                                    <td><span class="text-success fw-bold">{{ number_format($order->total) }}</span>
                                    </td>
                                    <td><span class="text-info fw-bold">{{ number_format($order->paid) }}</span></td>
                                    <td>
                                        <span class="fw-bold {{ $order->due > 0 ? 'text-danger' : 'text-success' }}">
                                            {{ number_format($order->due) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if ($order->due <= 0)
                                            <span class="badge bg-success">Cleared...</span>
                                        @else
                                            <span class="badge bg-warning text-dark">Pending...</span>
                                        @endif
                                    </td>
                                    <td>{{ $order->user->name }}</td>
                                    <td>
                                        {{-- View Modal --}}
                                        <button type="button" class="btn btn-secondary btn-sm" data-toggle="modal"
                                            data-target="#view{{ $order->id }}">
                                            <i class="fa fa-eye" aria-hidden="true"></i> View Order
                                        </button>

                                        <div class="modal fade" id="view{{ $order->id }}" tabindex="-1" role="dialog"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl" role="document">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">
                                                            {{ $order->customer ? $order->customer->name : 'LMT Textile' }}'s
                                                            Order</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered table-hover">
                                                                <thead class="thead-dark">
                                                                    <tr>
                                                                        <th class="text-center">#</th>
                                                                        <th class="text-center">Product Name</th>
                                                                        <th class="text-center">Size</th>
                                                                        <th class="text-center">Color</th>
                                                                        <th class="text-center">Main Design</th>
                                                                        <th class="text-center">Sub Design</th>
                                                                        <th class="text-center">QTY</th>
                                                                        <th class="text-center">Price</th>
                                                                        <th class="text-center">Amount</th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody>
                                                                    @foreach ($order->items as $item)
                                                                        <tr>
                                                                            <td class="text-center">
                                                                                {{ $loop->iteration }}
                                                                            </td>
                                                                            <td>{{ $item->product->product }}</td>
                                                                            <td class="text-center">
                                                                                {{ $item->size }}
                                                                            </td>
                                                                            <td class="text-center">
                                                                                {{ $item->color }}
                                                                            </td>
                                                                            <td class="text-center">
                                                                                {{ $item->main }}
                                                                            </td>
                                                                            <td class="text-center">
                                                                                {{ $item->sub }}
                                                                            </td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->qty) }}
                                                                                {{ $item->unit->name }}</td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->price) }}</td>
                                                                            <td class="text-center">
                                                                                {{ number_format($item->price * $item->qty) }}
                                                                            </td>
                                                                        </tr>
                                                                    @endforeach

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right">Total
                                                                        </td>
                                                                        <td colspan="2" class="text-center">
                                                                            {{ number_format($order->total) }}</td>
                                                                    </tr>

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right">Paid
                                                                        </td>
                                                                        <td colspan="2" class="text-center">
                                                                            {{ number_format($order->paid) }}</td>
                                                                    </tr>

                                                                    <tr class="font-weight-bold">
                                                                        <td colspan="8" class="text-right text-danger">
                                                                            Due
                                                                        </td>
                                                                        <td colspan="2"
                                                                            class="text-center text-danger">
                                                                            {{ number_format($order->due) }}</td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                        <tfoot class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>
                                    <h5 class="mb-0 text-success">({{ number_format($total) }})</h5>
                                </th>
                                <th>
                                    <h5 class="mb-0 text-info">({{ number_format($paid) }})</h5>
                                </th>
                                <th>
                                    <h5 class="mb-0 {{ $due > 0 ? 'text-danger' : 'text-success' }}">
                                        ({{ number_format($due) }})</h5>
                                </th>
                                <th>Status</th>
                                <th>User</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(function() {
            $("#example1").DataTable();

            //global variable
            let genre = "";
            let duration = "";
            let start = "";
            let end = "";

            $("#genre").on("change", function() {
                genre = $(this).val();

                if (genre == 1) {
                    $("#type").prop("required", true).fadeIn("slow");
                } else if (genre == 2) {
                    $("#type").val(""); // to clear input
                    $("#type").prop("required", false).fadeOut("slow");
                }
            });

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#duration").on("change", function() {
                duration = $(this).val();

                if (duration == 1) {
                    $("#start").val(""); // to clear input
                    $("#end").val(""); // to clear input
                    $("#start").prop("required", false).fadeOut("slow");
                    $("#end").prop("required", false).fadeOut("slow");

                } else if (duration == 2) {
                    $("#end").val(""); // to clear input
                    $("#start").prop("required", true).fadeIn("slow");
                    $("#end").prop("required", false).fadeOut("slow");

                } else if (duration == 3) {
                    $("#start").prop("required", true).fadeIn("slow");
                    $("#end").prop("required", true).fadeIn("slow");
                }
            });


            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#deleteall").on("click", function() {
                let selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).prop("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('expenses.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            let change;
            $("#date").on("change", function() {
                change = $(this).val();
            });


            $("#changedate").on("click", function() {
                let selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).prop("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "Your about to change expense date!!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, change date!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('change.expenses.date') }}",
                                method: "GET",
                                data: {
                                    'ids': selected,
                                    'newdate': change
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'date updated successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $("#changedate").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).prop("id"));
                });

                if (selected.length == 0) {
                    alert("please select at least one items!!");
                } else {
                    if (confirm("Are you sure..")) {
                        $.ajax({
                            url: "{{ route('change.expenses.date') }}",
                            method: "GET",
                            data: {
                                'ids': selected,
                                'newdate': change
                            },
                            success: function(data) {
                                window.location.reload(true);
                            }
                        });
                    }

                }

            });


        });
    </script>
@endsection
@endsection
