@extends('layouts.master')

@section('content')

    <div class="card table-responsive">

        <div class="card-header">
            <p> New Production Order</p>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <td class="col-7">
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode..">
                            <div id="list"
                                style="display:none; position: absolute; z-index: 10; width: 100%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                                class="bg-white border border-primary">
                                <ol id="results" class="list-group list-group-flush"></ol>
                            </div>
                        </td>

                        <td>
                            @if ($sellingCount > 1)
                                <select name="location" id="location" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected>-- Choose Location --</option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                        </option>
                                    @endforeach
                                </select>
                            @else
                                <input type="hidden" name="location" id="location" class="form-control"
                                    value="{{ $sellings[0]->location_id }}">

                                <input type="text" name="area-copy" id="area-copy" class="form-control"
                                    value="{{ $sellings[0]->location->name }}" style="text-align: center" readonly>
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>
            <br>

            <form action="{{ route('store.production.order') }}" method="post">
                @csrf

                <div class="row">
                    <div class="col-10">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover align-middle shadow-sm"
                                style="background: #fff;">
                                <thead class="table-secondary text-center align-middle">
                                    <tr>
                                        <th style="width: 15%">Product</th>
                                        <th style="width:8%">Unit</th>
                                        <th style="width: 6%">Size</th>
                                        <th style="width: 15%">Color</th>
                                        <th>Main.Design</th>
                                        <th>Sub.Design</th>
                                        <th style="width:8%">Qty</th>
                                        <th style="width:10%">Price</th>
                                        <th style="width:10%">Amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                @php
                                    $iteration = 200;
                                @endphp

                                <tbody id="tbody">

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col was-validated">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="number" name="total" id="total" class="form-control" style="text-align: center"
                            placeholder="Total" readonly value="{{ old('total', session('profomaData.total', '')) }}">

                        <select name="type" id="type" class="form-control" style="text-align: center">
                            <option disabled selected value="">-- Choose Type --</option>
                            <option value="1">-- Knitting --</option>
                            <option value="2">-- Sewing --</option>
                            <option value="3">-- Printing --</option>
                            <option value="4">-- Embroidery --</option>
                        </select>
                        <select name="genre" id="Genre" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Choose Genre --</option>
                            <option value="1">-- Customer --</option>
                            <option value="2">-- Stock --</option>
                        </select>

                        <input type="search" name="customer" id="customer" class="form-control" style="text-align: center"
                            placeholder="Customer" required value="{{ old('customer', session('customerData.name')) }}">
                        <div id="customerlist1" style="display:none">
                            <ol id="customerlist2"></ol>
                        </div>

                        <input type="text" name="paid" id="paid" class="form-control" placeholder="Paid"
                            style="text-align: center" required>

                        <input type="text" name="due" id="due" class="form-control" placeholder="due"
                            style="text-align: center" readonly>

                        <select name="account" id="account" class="form-control" style="text-align: center" required>
                            <option selected disabled value="">-- Choose Account --</option>
                            @foreach ($accounts as $account)
                                <option value="{{ $account->id }}">-- {{ $account->type }} - {{ $account->name }} --
                                </option>
                            @endforeach
                        </select>

                        <select name="expectation" id="expectaiton" class="form-control" style="text-align: center"
                            required>
                            <option selected disabled value="">-- Expectaions --</option>
                            <option value="1">-- 1 Week --</option>
                            <option value="2">-- 2 Weeks --</option>
                            <option value="3">-- 3 Weeks --</option>
                            <option value="4">-- 1 Month --</option>
                        </select>

                        <input type="hidden" name="location" id="location1" class="form-control"
                            style="text-align: center">
                        <br>

                        <button class="btn btn-info btn-block"><i class="fa fa-paper-plane fa-lg"></i> Confirm</button>

                        <a href="{{ route('production.order') }}" class="btn btn-danger btn-block"><i
                                class="fa fa-times fa-lg"></i> Cancel</a>

                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {

            $("#search").focus();

            $("#location").focus();

            //Global variablesx
            var index = 0
            var query;
            var location;
            var ajaxResults;
            var productId;
            var paid;
            var total;
            var price;
            var qty;
            var unit;
            var id;

            var sellingCount = {{ $sellingCount }}; // Access the PHP variable in JavaScript

            if (sellingCount > 1) { // If there are multiple selling sellings
                $("#location").on("change", function() {
                    location = $(this).val();
                    $("#location1").val(location);
                });
            } else { // If there's one selling one selling location
                location = $("#location").val();
                $("#location1").val(location);
            }

            $("#search").on("keyup", function() {
                var ujumbe = "No suggestions..";
                var query = $(this).val();

                $.ajax({

                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': location
                    },
                    success: function(response) {
                        $("#results").empty();
                        ajaxResults = response;

                        if (query != "") {
                            if (ajaxResults.length == 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    i + '" >' +
                                    ajaxResults[i].product + ' | ' + ajaxResults[i]
                                    .stock[0]
                                    .qty + ' ' + ajaxResults[i].unit[0].unit.name +
                                    '</button></li>');

                                productId = ajaxResults[i].id;
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".items", function() {
                id = $(this).attr("id");
                var product = $(this).html();
                $("#list").fadeOut("slow");

                var units;
                var unitprice;

                for (var i = 0; i < ajaxResults[id].unit.length; i++) {

                    units = units + '<option value="' + ajaxResults[id].unit[i].unit_id + '">' +
                        ajaxResults[
                            id].unit[i].unit.name + '</option>';
                    unitprice = ajaxResults[id].unit[0].selling;
                    //console.log(units);
                }

                var tr = `
                    <tr id="tr${index}">
                        <td>
                            <input type="hidden" name="id[]" value="${ajaxResults[id].id}" id="id${index}" class="form-control id" style="text-align: center" readonly>
                            <input type="hidden" name="product[]" value="${ajaxResults[id].product}" id="product${index}" class="form-control product" style="text-align: center" readonly required>
                            ${ajaxResults[id].product}
                        </td>

                        <td>
                            <select class="form-control unit" style="text-align: center" name="unit[]" id="unit${index}" required>
                                ${units}
                            </select>
                            <input type="hidden" value="1" name="cont[]" id="cont${id}" class="form-control cont" style="text-align: center">
                        </td>

                        <td>
                            <input type="text" value="" name="size[]" id="size${index}" class="form-control size" style="text-align: center" required>
                        </td>

                        <td>
                            <input type="text" name="rangi[]" value="" id="rangi${index}" class="form-control rangi" style="text-align: center" required>
                            <div id="colors-list${index}" style="display:none; position: absolute; z-index: 10; width: 35%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);" class="bg-white border border-primary">
                                <ol id="colors${index}" class="list-group list-group-flush"></ol>
                            </div>
                        </td>

                        <td>
                            <select class="form-control mainSelect" style="text-align: center" name="main[]" id="mainSelect${index}" required>
                                <option value="">-- Select --</option>
                                <option value="normal">-- Normal --</option>
                                <option value="mixed">-- Mixed --</option>
                                <option value="special">-- Special --</option>
                            </select>
                        </td>

                        <td>
                            <input type="text" name="sub[]" value="" id="sub${index}" class="form-control sub" style="text-align: center" required>
                        </td>

                        <td>
                            <input type="text" name="qty[]" value="" id="qty${index}" class="form-control qty" style="text-align: center" required>
                        </td>

                        <td>
                            <input type="text" name="price[]" value="${unitprice}" id="price${index}" class="form-control price" style="text-align: center" required>
                        </td>

                        <td>
                            <input type="text" name="amount[]" value="${unitprice}" id="amount${index}" class="form-control amount" style="text-align: center" readonly required>
                        </td>

                        <td>
                            <button type="button" id="${index}" class="btn btn-danger removeRow">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                    </tr>`;

                // JSON encode the session data for 'purchaseOrderItems' and store it in purchaseOrderItems variable
                let profomaItems = {!! json_encode(session()->has('profomaItems')) !!};

                // If purchaseOrderItems is true, prepend the 'tr' row to the element with id 'tbody1'
                if (profomaItems) {
                    $("#tbody1").prepend(tr);
                } else {
                    // If purchaseOrderItems is false, append the 'tr' row after the element with id 'tbody'
                    $("#tbody").after(tr);
                }

                index++;
                total();
                $("#search").val("");
                $("#search").focus();
            });

            let selectedId;

            $(document).on("keyup", ".rangi", function() {
                let selectedId = $(this).attr("id").replace("rangi", "");
                let ujumbe = "No suggestions..";
                let query = $(this).val();

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': location
                    },
                    success: function(response) {
                        $("#colors" + selectedId).empty();
                        ajaxResults = response;

                        if (query !== "") {
                            if (ajaxResults.length === 0) {
                                $("#colors-list" + selectedId).fadeIn("slow");
                                $("#colors" + selectedId).append(`
                                    <li>
                                        <button type="button" class="btn btn-outline-secondary form-control items">
                                            ${ujumbe}
                                        </button>
                                    </li>
                                `);
                            }

                            for (let i = 0; i < ajaxResults.length; i++) {
                                $("#colors-list" + selectedId).fadeIn("slow");
                                let productName = ajaxResults[i].product.split('|')[0].trim();
                                $("#colors" + selectedId).append(`
                                    <li>
                                        <button type="button" class="form-control colors btn btn-outline-secondary" 
                                                data-ajax-index="${i}" data-row-index="${selectedId}">
                                            ${productName}
                                        </button>
                                    </li>
                                `);
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".colors", function() {
                let ajaxIndex = $(this).data("ajax-index");
                let rowIndex = $(this).data("row-index");

                let colorId = ajaxResults[ajaxIndex].id;
                let productName = $(this).text().split('|')[0].trim();

                $("#rangi" + rowIndex).val(productName);
                $("#colors-list" + rowIndex).fadeOut("slow");
            });

            $(document).on("click", ".removeRow", function() {
                var id = $(this).attr("id"); // e.g., "3"
                $("#tr" + id).remove(); // removes row with id="tr3"
                total(); // recalculate totals
                $("#search").val(""); // clear search field
                $("#search").focus(); // focus back to search input
            });


            $(document).on("click", ".increment", function() {
                var id = $(this).attr("id").replace("increment", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);

            });

            $(document).on("click", ".decrement", function() {
                var id = $(this).attr("id").replace("decrement", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                var priceInput = $("#price" + id);
                var price = parseFloat(priceInput.val());
                var amountInput = $("#amount" + id);
                var amount = qty * price;
                amountInput.val(amount);
                total();
                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("change", ".unit", function() {
                unit = $(this).val();
                id = $(this).attr("id").replace("unit", "");
                productId = $("#id" + id).val();
                qty = $("#qty" + id).val();
                location = $("#location1").val();
                console.log(unit, productId, location, qty);

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unit,
                        'productId': productId,
                        'locationId': location,
                    },
                    success: function(data) {
                        //console.log(data);
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(data.selling);
                        $("#amount" + id).val(data.selling * qty);
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("keyup", ".price", function() {
                price = $(this).val();
                id = $(this).attr("id").replace("price", "");
                qty = $("#qty" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            $(document).on("keyup", ".qty", function() {
                qty = $(this).val();
                id = $(this).attr("id").replace("qty", "");
                price = $("#price" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            function total() {
                var amount = 0;
                $(".amount").each(function() {
                    amount += Number($(this).val());
                });
                $("#total").val(amount);
            }

            $("#paid").on("keyup", function() {
                let total = $("#total").val();
                let paid = $(this).val();
                let due = total - paid;
                $("#due").val(due);
            });

            $("#Genre").on("change", function() {
                let genre = $(this).val();

                if (genre == 1) {
                    $("#customer").fadeIn("slow");
                    $("#customer").attr("required", true);
                } else if (2) {
                    $("#customer").attr("required", false);
                    $("#customer").fadeOut("slow");
                }

            });

            $("#paid").on("keyup", function() {
                let paid_amount = $(this).val();

                if (paid_amount > 0) {
                    $("#account").fadeIn("slow");
                    $("#account").attr("required", true);
                } else {
                    $("#account").attr("required", false);
                    $("#account").fadeOut("slow");
                }
            });

            $("#customer").on("keyup", function() {

                var ujumbe = "No suggestion..";
                var query = $(this).val();

                $.ajax({

                    url: "{{ route('get.customer') }}",
                    method: "get",
                    data: {
                        'query': query,
                    },
                    success: function(data) {
                        $("#customerlist2").empty();

                        console.log(data);

                        if (query != "") {

                            if (data.length == 0) {
                                $("#customerlist1").fadeIn("slow");
                                $("#customerlist2").append(
                                    '<li><button type="button" class="btn btn-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < data.length; i++) {
                                $("#customerlist1").fadeIn("slow");
                                $("#customerlist2").append(
                                    '<li><button type="button" class="form-control customer btn btn-secondary" id="' +
                                    index++ + '" >' + data[i].name + '</button></li>');

                                $(".customer").on("click", function() {
                                    var customer = $(this).html();
                                    $("#customer").val(customer);
                                    $("#customerlist2").fadeOut("slow");
                                });
                            }
                        }
                    }
                });
            });
        });
    </script>
@endsection

@endsection
