@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <div class="btn-group" role="group" aria-label="Unit Actions">
                <button type="button" id="deleteall" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash-alt"></i> Delete
                    selected</button>

                <!-- Button trigger modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i>
                    Add category
                </button>

                <!-- Modal -->
                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add category</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ Route('product.category.store') }}" method="POST" class="was-validated">
                                @csrf
                                @method('POST')

                                <div class="modal-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover shadow-sm" id="table">
                                            <thead class="thead-light text-center">
                                                <tr>
                                                    <th scope="col" style="width:5%">#</th>
                                                    <th scope="col" class="font-weight-bold">Category Name</th>
                                                    <th scope="col" class="font-weight-bold">Parent Category</th>
                                                    <th scope="col" style="width:10%">
                                                        <button type="button" class="btn btn-success btn-sm" id="addRow"
                                                            title="Add Row">
                                                            <i class="fa-solid fa-plus"></i>
                                                        </button>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                                <!-- Dynamic rows will be added here -->
                                            </tbody>
                                        </table>
                                    </div>
                                    <p class="text-muted small mt-2 mb-0">
                                        <i class="fa fa-info-circle"></i> Add multiple categories at once. Click <span
                                            class="badge badge-success"><i class="fa-solid fa-plus"></i></span> to add more
                                        rows.
                                    </p>
                                </div>

                                <div class="modal-footer">
                                    <div class="btn-group" role="group" aria-label="Unit Actions">
                                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i
                                                class="fa-solid fa-xmark"></i> Close</button>
                                        <button type="submit" class="btn btn-primary btn-sm"><i
                                                class="fa-solid fa-paper-plane"></i>
                                            Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-hover">
            <div class="table-responsive">
                <table class="table table-hover table-striped shadow-sm border rounded">
                    <thead class="table-dark">
                        <tr>
                            <th style="width: 15%">#</th>
                            <th>Category</th>
                            <th class="text-center">Type</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($categories as $category)
                            {{-- Parent Category --}}
                            <tr class="bg-light font-weight-bold">
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <i class="fa fa-folder text-warning mr-2"></i>
                                    {{ $category->name }}
                                </td>
                                <td class="text-center align-middle">
                                    <span class="badge badge-primary">Main</span>
                                </td>
                                <td class="text-center align-middle">
                                    {{-- keep original actions --}}
                                    <div class="btn-group" role="group">
                                        <!-- View Button -->
                                        <button type="button" class="btn btn-info btn-sm view-products"
                                            data-category-id="{{ $category->id }}">
                                            <i class="fa fa-eye"></i> View Items
                                        </button>

                                        <!-- Product Modal -->
                                        <div class="modal fade" id="productModal" tabindex="-1"
                                            aria-labelledby="productModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-info text-white">
                                                        <h5 class="modal-title" id="productModalLabel">Category Products
                                                        </h5>
                                                        <button type="button" class="close text-white"
                                                            data-dismiss="modal">&times;</button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <table class="table table-bordered table-striped">
                                                            <thead>
                                                                <tr>
                                                                    <th>#</th>
                                                                    <th>Image</th>
                                                                    <th>Product</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="product-list">
                                                                <tr>
                                                                    <td colspan="4" class="text-center py-5">
                                                                        <div class="d-flex flex-column align-items-center">
                                                                            <i
                                                                                class="fa-solid fa-folder-open fa-3x text-secondary mb-3"></i>
                                                                            <h5 class="text-secondary mb-1">No Products
                                                                                Loaded</h5>
                                                                            <p class="text-muted small mb-0">
                                                                                Click a <strong
                                                                                    class="text-primary">category</strong>
                                                                                to view its products.
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Delete Button -->
                                        <button class="btn btn-danger btn-sm delete" id="{{ $category->id }}"
                                            title="Delete">
                                            <i class="fa fa-trash-alt fa-lg"></i> Delete
                                            <form action="{{ route('product.category.destroy', $category->id) }}"
                                                method="GET" id="deleteform{{ $category->id }}">
                                            </form>
                                        </button>

                                        <!-- Edit Button -->
                                        <button type="button" class="btn btn-primary btn-sm editCategory"
                                            data-id="{{ $category->id }}" data-name="{{ $category->name }}"
                                            data-parent="{{ $category->parent_id }}" data-toggle="modal"
                                            data-target="#editCategoryModal">
                                            <i class="fa fa-edit"></i> Edit
                                        </button>
                                    </div>
                                </td>
                            </tr>

                            {{-- Subcategories --}}
                            @foreach ($category->children as $child)
                                <tr>
                                    <td>—</td>
                                    <td>
                                        <i class="fa fa-level-up-alt text-secondary mr-2"></i>
                                        {{ $child->name }}
                                    </td>
                                    <td class="text-center align-middle">
                                        <span class="badge badge-secondary">Subcategory</span>
                                    </td>
                                    <td class="text-center align-middle">
                                        {{-- reuse same actions for subcategories --}}
                                        <div class="btn-group" role="group">
                                            <!-- View Button -->
                                            <button type="button" class="btn btn-info btn-sm view-products"
                                                data-category-id="{{ $child->id }}">
                                                <i class="fa fa-eye"></i> View Items
                                            </button>

                                            <!-- Delete Button -->
                                            {{-- <button class="btn btn-danger btn-sm delete" id="{{ $child->id }}"
                                                title="Delete">
                                                <i class="fa fa-trash-alt fa-lg"></i> Delete
                                                <form action="{{ route('product.category.destroy', $child->id) }}"
                                                    method="GET" id="deleteform{{ $child->id }}">
                                                </form>
                                            </button> --}}

                                            <!-- Edit Button -->
                                            <button type="button" class="btn btn-primary btn-sm editCategory"
                                                data-id="{{ $child->id }}" data-name="{{ $child->name }}"
                                                data-toggle="modal" data-target="#editCategoryModal">
                                                <i class="fa fa-edit"></i> Edit
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-5">
                                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                        style="width: 80px; opacity: 0.5;">
                                    <h5 class="mt-3 text-secondary font-weight-bold">No Categories Found</h5>
                                    <p class="text-muted mb-0">
                                        Start by adding a <strong>Main Category</strong> to organize your products.
                                    </p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <!-- Edit Category Modal -->
                <div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog"
                    aria-labelledby="editCategoryModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <form id="editCategoryForm" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editCategoryModalLabel">Edit
                                        Category</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Category Name</label>
                                        <input type="text" name="name" id="edit_name" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="parent_id" class="form-label">Parent Category</label>
                                        <select name="parent_id" id="edit_parent_id" class="form-control">
                                            <option value="">-- No Parent (Main Category) --</option>
                                            @foreach ($categories as $cat)
                                                <option value="{{ $cat->id }}">-- {{ $cat->name }} --</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-secondary btn-sm"
                                            data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary btn-sm">
                                            <i class="fa-solid fa-paper-plane"></i> Update
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @section('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $("#success").fadeIn("slow");
                setTimeout(function() {
                    $("#success").fadeOut("slow")
                }, 3000);

                var index = 1;

                // add row
                $("#addRow").on("click", function() {
                    const tr = `
                            <tr id="tr${index}">
                                <td class="text-center">${index}</td>
                                <td>
                                    <input 
                                        type="text" 
                                        name="name[]" 
                                        class="form-control text-center" 
                                        placeholder="Enter category" 
                                        required
                                    >
                                </td>
                                <td>
                                    <select name="parent_id[]" class="form-control text-center">
                                        <option value="">-- Main Category --</option>
                                        @foreach ($categories as $main)
                                            <option value="{{ $main->id }}">-- {{ $main->name ?? 'NULL' }} --</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td class="text-center">
                                    <button type="button" id="${index}" class="btn btn-danger removeRow">
                                        <i class="fa fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        `;

                    $("#tbody").append(tr);
                    index++;

                    $(".removeRow").on("click", function() {
                        var id = $(this).attr("id");
                        $("#tr" + id).remove();
                    });
                });


                $("#checkall").on("click", function() {
                    if ($(this).is(':checked', true)) {
                        $(".selected").prop('checked', true);
                    } else {
                        $(".selected").prop('checked', false);
                    }
                });

                $("#deleteall").on("click", function() {
                    var selected = [];
                    $(".selected:checked").each(function() {
                        selected.push($(this).attr("id"));
                    });

                    if (selected.length == 0) {

                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Select atleast one item!!',
                        });
                    } else {
                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Yes, delete it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('product.category.bulk.delete') }}",
                                    method: "GET",
                                    data: {
                                        'ids': selected
                                    },
                                    success: function(data) {
                                        window.location.reload(true);
                                    }
                                });

                                $(document).ready(function() {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: 'Selected categories deleted successfully.',
                                        background: '#e6ffed',
                                        showConfirmButton: false,
                                        timer: 2500,
                                        timerProgressBar: true,
                                        position: 'top-end',
                                        toast: true,
                                        customClass: {
                                            popup: 'swal2-border-radius'
                                        }
                                    });
                                });
                            }
                        });
                    }
                });

                $(".delete").on("click", function() {
                    var id = $(this).attr("id");

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.getElementById("deleteform" + id).submit();
                        }
                    })
                });

                const hardcodedImage = "{{ asset('dist/img/menu-6.jpg') }}";

                $(document).on('click', '.view-products', function() {
                    var categoryId = $(this).data('category-id');
                    $('#product-list').html(
                        '<tr><td colspan="4" class="text-center text-muted">Loading...</td></tr>');
                    $('#productModal').modal('show');

                    $.get('/category/' + categoryId + '/products', function(data) {
                        if (data.length > 0) {
                            let rows = '';
                            $.each(data, function(index, product) {
                                rows += `<tr>
                                                <td>${index + 1}</td>
                                                <td class="text-center">
                                                    <img src="${hardcodedImage}" 
                                                        alt="Product Image" 
                                                        class="img-thumbnail"
                                                        style="width:50px; height:50px; object-fit:cover;">
                                                </td>
                                                <td>${product.product}</td>
                                            </tr>`;
                            });
                            $('#product-list').html(rows);
                        } else {
                            $('#product-list').html(
                                `<tr>
                                    <td colspan="4" class="text-center py-5">
                                        <div class="d-flex flex-column align-items-center">
                                            <i class="fa-solid fa-box-open fa-3x text-secondary mb-3"></i>
                                            <h5 class="text-secondary mb-1">No Products Found</h5>
                                            <p class="text-muted small mb-0">Click another category to view its products.</p>
                                        </div>
                                    </td>
                                </tr>`
                            );
                        }
                    });
                });

                $(document).on('click', '.editCategory', function() {

                    var id = $(this).data('id');
                    var name = $(this).data('name');
                    var parentId = $(this).data('parent');

                    // Debug (optional – remove after confirming)
                    // console.log(id, name, parentId);

                    // Set form action
                    $('#editCategoryForm').attr('action', '/product/category/update/' + id);

                    // Populate fields
                    $('#edit_name').val(name);

                    // Handle null / undefined parent safely
                    if (parentId) {
                        $('#edit_parent_id').val(parentId);
                    } else {
                        $('#edit_parent_id').val('');
                    }

                });
            });
        </script>
    @endsection

@endsection
