@extends('layouts.master')

@section('content')
    <style>
        /* === Base Styles === */
        .invoice-box {
            max-width: 900px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            background: #fff;
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 16px;
            color: #555;
        }

        .invoice-header {
            background: #337ab7;
            color: white;
            padding: 30px;
        }

        .invoice-header h1 {
            font-size: 36px;
            margin-bottom: 0;
        }

        .invoice-summary {
            text-align: right;
            color: white;
        }

        .invoice-details {
            margin-top: 30px;
        }

        .invoice-address p {
            margin: 0;
            line-height: 1.6;
        }

        .invoice-table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        .invoice-table th {
            background: #f2f2f2;
            border: 1px solid #ddd;
            padding: 12px;
        }

        .invoice-table td {
            border: 1px solid #ddd;
            padding: 12px;
        }

        .total-section {
            margin-top: 20px;
            text-align: right;
        }

        .terms {
            margin-top: 50px;
            font-size: 12px;
            color: #666;
        }

        .signature {
            margin-top: 40px;
            text-align: right;
            font-family: 'Brush Script MT', cursive;
            font-size: 24px;
            color: #000;
        }

        /* === Print-Specific Overrides === */
        @media print {

            .btn,
            .btn-group,
            .no-print {
                display: none !important;
            }
        }
    </style>


    <div class="invoice-box shadow">
        {{-- Header --}}
        <div class="row invoice-header">
            <div class="col-md-6">
                <img src="{{ asset('storage/logos/' . $profileData->logo) }}" alt="Company Logo"
                    style="height: 80px; margin-bottom: 10px;">
                {{-- <h1>PURCHASE<br>ORDER</h1> --}}
            </div>
            <div class="col-md-6 invoice-summary">
                <p><strong>INVOICE #:</strong> 000{{ $purchaseOrderData->id }}</p>
                <p><strong>INVOICE DATE:</strong> {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
                <p><strong>P.O. #:</strong> {{ rand(1000, 9999) }}/{{ rand(2019, 2024) }}</p>
                <p><strong>DUE DATE:</strong> {{ \Carbon\Carbon::now()->addWeek()->format('d/m/Y') }}</p>
                <h4><strong>PURCHASE ORDER TOTAL:</strong> TZS {{ number_format($purchaseOrderData->total, 2) }}</h4>
            </div>
        </div>

        {{-- Addresses --}}
        <div class="row invoice-details">
            <div class="col-md-4 invoice-address"
                style="background: #f9f9f9; border-radius: 8px; padding: 18px; margin-bottom: 10px; box-shadow: 0 2px 8px rgba(51,122,183,0.07);">
                <strong style="font-size: 18px; color: #337ab7; letter-spacing: 1px;">SENT BY</strong>
                <hr style="margin: 8px 0;">
                <p style="font-weight: 600; margin-bottom: 4px;">{{ $profileData->selling->location->name }}</p>
                <p style="margin-bottom: 4px;">{{ $profileData->address }}</p>
                <p style="color: #888;">Tanzania</p>
            </div>
            <div class="col-md-4 invoice-address"
                style="background: #f9f9f9; border-radius: 8px; padding: 18px; margin-bottom: 10px; box-shadow: 0 2px 8px rgba(51,122,183,0.07);">
                <strong style="font-size: 18px; color: #337ab7; letter-spacing: 1px;">SENT TO</strong>
                <hr style="margin: 8px 0;">
                <p style="font-weight: 600; margin-bottom: 4px;">{{ $purchaseOrderData->supplier->name }}</p>
                <p style="margin-bottom: 4px;">{{ $purchaseOrderData->supplier->address }}</p>
                <p style="color: #888;">Tanzania</p>
            </div>
            <div class="col-md-4 invoice-address"
                style="background: #f9f9f9; border-radius: 8px; padding: 18px; margin-bottom: 10px; box-shadow: 0 2px 8px rgba(51,122,183,0.07);">
                <strong style="font-size: 18px; color: #337ab7; letter-spacing: 1px;">SHIP TO</strong>
                <hr style="margin: 8px 0;">
                <p style="font-style: italic; color: #999;">No shipping address</p>
            </div>
        </div>

        {{-- Items Table --}}
        <table class="invoice-table"
            style="background: #fff; box-shadow: 0 4px 24px rgba(51,122,183,0.08); border-radius: 10px; overflow: hidden;">
            <thead>
                <tr style="background: linear-gradient(90deg, #337ab7 0%, #5bc0de 100%);">
                    <th style="border: none; font-size: 18px; letter-spacing: 1px; padding: 16px;">#</th>
                    <th style="border: none; font-size: 18px; letter-spacing: 1px; padding: 16px;">DESCRIPTION</th>
                    <th style="border: none; font-size: 18px; letter-spacing: 1px; padding: 16px;">UNIT PRICE</th>
                    <th style="border: none; font-size: 18px; letter-spacing: 1px; padding: 16px;">QTY</th>
                    <th style="border: none; font-size: 18px; letter-spacing: 1px; padding: 16px;">AMOUNT</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($purchaseOrderData->purchaseOrderItems as $index => $item)
                    <tr style="background: {{ $index % 2 == 0 ? '#f9f9f9' : '#eaf4fb' }};">
                        <td style="text-align: center; font-weight: 600; color: #337ab7;">{{ $index + 1 }}</td>
                        <td style="font-weight: 500; color: #222;">{{ $item->product->product }}</td>
                        <td style="text-align: right; color: #337ab7;">TZS {{ number_format($item->price, 2) }}</td>
                        <td style="text-align: center;">{{ $item->qty }} <span
                                style="color: #888; font-size: 13px;">{{ $item->unit->name }}</span></td>
                        <td style="text-align: right; font-weight: 600; color: #5cb85c;">TZS
                            {{ number_format($item->price * $item->qty, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{-- Totals --}}
        <div class="total-section"
            style="background: linear-gradient(90deg, #337ab7 0%, #5bc0de 100%); padding: 24px 32px; border-radius: 12px; box-shadow: 0 2px 12px rgba(51,122,183,0.10); color: #fff; margin-bottom: 30px;">
            <h2 style="margin: 0; font-size: 32px; letter-spacing: 2px;">
                <strong>TOTAL:</strong>
                <span style="color: #ffd700;">TZS {{ number_format($purchaseOrderData->total, 2) }}</span>
            </h2>
        </div>

        {{-- Signature --}}
        <div class="signature" style="margin-top: 60px; text-align: right;">
            <span
                style="display: inline-block; border-bottom: 2px solid #337ab7; padding-bottom: 6px; font-family: 'Brush Script MT', cursive; font-size: 32px; color: #337ab7;">
                {{ $profileData->selling->location->name }}
            </span>
            <div style="font-size: 14px; color: #888; margin-top: 4px;">
                {{ Auth::user()->name }} (Authorized Signature)
            </div>
        </div>

        {{-- Terms --}}
        <div class="terms"
            style="background: #f2f8fc; border-left: 6px solid #337ab7; padding: 24px 32px; border-radius: 8px; margin-top: 40px; box-shadow: 0 2px 8px rgba(51,122,183,0.06);">
            <p style="font-size: 16px; font-weight: bold; color: #337ab7; letter-spacing: 1px; margin-bottom: 10px;">
                TERMS & CONDITIONS
            </p>
            <ul style="padding-left: 18px; color: #444; font-size: 15px; margin-bottom: 0;">
                <li>Payment is due within <strong>15 days</strong> of invoice date.</li>
                <li>Please make checks payable to: <strong>{{ $profileData->selling->location->name }}.</strong></li>
                <li>Goods remain property of the seller until paid in full.</li>
                <li>For any queries, contact us via {{ $profileData->phone }}</a></li>
            </ul>
        </div> <br>

        <center>
            <div class="btn-group" role="group" aria-label="Unit Actions">
                <button class="btn btn-primary btn-sm" onclick="window.print()">
                    <i class="fa fa-print"></i> Print
                </button>
                <a href="{{ route('purchase.order.view') }}" class="btn btn-secondary btn-sm"><i
                        class="fa fa-arrow-left"></i> Back</a>
            </div>
        </center>
    </div>
@endsection
