<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery Note</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }

        .delivery-note {
            width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
        }

        header {
            display: flex;
            justify-content: space-between;
            border-bottom: 2px solid #47667e;
            padding-bottom: 10px;
        }

        .header-left h1 {
            margin: 0;
            color: #47667e;
        }

        .header-left p {
            margin: 5px 0;
        }

        .logo {
            border: 1px solid #ddd;
            padding: 10px;
            width: 200px;
            text-align: center;
            margin-top: 10px;
        }

        .header-right h2 {
            margin: 0;
            color: #47667e;
            ;
        }

        .header-right p {
            margin: 5px 0;
        }

        .addresses {
            display: flex;
            justify-content: space-between;
            margin: 20px 0;
        }

        .address h3 {
            margin: 0;
            background: #47667e;
            ;
            color: #fff;
            padding: 5px;
        }

        main {
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table thead {
            background: #47667e;
            ;
            color: #fff;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
        }

        .notice {
            text-align: left;
            font-size: 0.9em;
            color: #555;
        }

        footer {
            border-top: 2px solid #47667e;
            ;
            padding-top: 10px;
            text-align: center;
        }

        footer p {
            margin: 5px 0;
        }
    </style>
</head>

<body id="body">
    <div class="delivery-note">
        <header>
            <div class="header-left">
                <h1>
                    <p>{{ $profileData->name }}</p>
                </h1>
                <p>
                <p>{{ $profileData->slogan }}</p>
                </p>
                <div class="logo">
                    <p>Insert Your Logo</p>
                </div>
            </div>
            <div class="header-right">
                <h2>Delivery Note</h2>
                <p>Order Date: [{{ $sale->date }}]</p>
                <p>Order #: [#00{{ $sale->id }}]</p>
                <p>Delivery Note #: [#00{{ $sale->id }}]</p>
                <p>Customer ID: [#00{{ $sale->id }}]</p>
                <p>Despatch Date: [{{ $currentDate }}]</p>
                <p>Delivery Method: [{{ $vehicle }}]</p>
            </div>
        </header>
        <section class="addresses">
            <div class="address">
                <h3>From</h3>
                <p>[{{ $profileData->name }}]<br>
                    [{{ $profileData->address }}]<br>
                    [{{ $profileData->phone }}]<br>
                    {{ $profileData->email ? "[{$profileData->email}]" : '' }}</p>
            </div>
            <div class="address">
                <h3>To</h3>
                <p>[{{ $sale->customer->name }}]<br>
                    [{{ $sale->customer->address }}]<br>
                    [{{ $sale->customer->phone }}]<br>
                    {{ $sale->customer->email ? "[{$sale->customer->email}]" : '' }}</p>
            </div>
        </section>
        <main>
            <table>
                <thead>
                    <tr>
                        <th>Item #</th>
                        <th>Description</th>
                        <th>Ordered</th>
                        <th>Delivered</th>
                        <th>Outstanding</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($items as $item)
                        <tr>
                            <td>{{ $item->loop + 1 }}</td>
                            <td>{{ $item->product->product }}</td>
                            <td>{{ $item->qty }}</td>
                            <td>{{ $deliveredItems[$loop->index] }}</td>
                            <td>{{ $deliveredItems[$loop->index] - $item->qty }}</td>
                        </tr>
                    @endforeach
                    <!-- Repeat rows as needed -->
                    <tr>
                        <td colspan="5" class="notice">
                            Notice must be given to us of any goods not received within 2 days taken from the date of
                            despatch stated on invoice. Any Shortage or damage must be notified within 72 hours of
                            receipt of goods. Complaints can only be accepted if made in writing within 30 days of
                            receipt of goods. No goods may be returned without prior authorization from company name.
                        </td>
                    </tr>
                </tbody>
            </table>
        </main>
        <footer>
            {{-- <p>Thank you for your business! Should you have any enquiries concerning this delivery note, please contact
                John Doe on 000-000-0000</p> --}}
            {{-- <p>1111 Street, Town/City, Country, ST, 00000</p>
                <p>Tel: 000-000-0000 Fax: 000-000-0000 Email: info@yourcompanysite.com Web: www.yourcompanysite.com</p> --}}
                <p>Thank you for your business!</p>
            <p>Powered by Dukamax Business Software (0757 290 359)</p>

        </footer>
    </div>

    <script>
        window.print();

        window.onload = function() {
            document.getElementById("body").onclick = function() {
                window.location.href = "{{ route('sales.reciept') }}";
            }
        };
    </script>
</body>

</html>
