@extends('layouts.master')

@section('content')
    <div class="container py-5">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Our Pricing Plans</h2>
            <p class="text-muted">Choose the plan that fits your business needs. Transparent pricing, no hidden fees.</p>
        </div>

        <style>
            body {
                background: #f8f9fa;
                color: #333;
            }

            .pricing-plan {
                margin-bottom: 2rem;
                background: #fff;
                border-radius: 12px;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
                transition: transform 0.3s, box-shadow 0.3s;
                overflow: hidden;
            }

            .pricing-plan:hover {
                transform: translateY(-10px);
                box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            }

            .pricing-header {
                text-align: center;
                padding: 2rem 1rem;
                color: #fff;
            }

            .pricing-title {
                font-size: 1.4rem;
                font-weight: 700;
                text-transform: uppercase;
                margin-bottom: 0.5rem;
                text-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
            }

            .pricing-cost {
                font-size: 2.5rem;
                font-weight: 800;
                margin-bottom: 0.3rem;
            }

            .pricing-save {
                font-size: 1rem;
                font-weight: 600;
            }

            .pricing-header.primary {
                background: linear-gradient(135deg, #00b5fd 0%, #0047b1 100%);
            }

            .pricing-header.red {
                background: linear-gradient(135deg, #ff3434 0%, #a50000 100%);
            }

            .pricing-header.secondary {
                background: linear-gradient(135deg, #c0d64a 0%, #35690f 100%);
            }

            .pricing-features {
                list-style: none;
                padding: 2rem 1.5rem;
                margin: 0;
            }

            .pricing-features li {
                padding: 0.8rem 0;
                position: relative;
                font-size: 0.95rem;
                border-bottom: 1px solid #f1f1f1;
            }

            .pricing-features li:last-child {
                border-bottom: none;
            }

            .pricing-footer {
                padding: 1.5rem;
                text-align: center;
                background: #f9f9f9;
            }

            .pricing-footer a.btn {
                padding: 0.8rem 2rem;
                font-size: 1rem;
                font-weight: 600;
                border-radius: 50px;
                transition: all 0.3s;
            }

            .pricing-footer a.btn:hover {
                transform: translateY(-3px);
            }

            @media (max-width: 767px) {
                .pricing-features {
                    padding: 1.5rem 1rem;
                }
            }
        </style>

        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="pricing-plan">
                    <div class="pricing-header primary">
                        <h4 class="pricing-title">Shop Module</h4>
                        <div class="pricing-cost">Tshs 700k</div>
                    </div>
                    <ul class="pricing-features">
                        <li>Installation</li>
                        <li>Data Entry</li>
                        <li>Training</li>
                        <li>Software Updates</li>
                        <li>Support: 24/7 Online Free, Onsite 35k</li>
                        <li>@ Additional Selling Location 350k</li>
                        <li>Annual Domain + Hosting + SSL Fee 250k</li>
                        <li>Annual maintanance + Support + Updates & License fee 300k @ Selling Location 150K</li>
                    </ul>
                    <div class="pricing-footer">
                        <a href="#" class="btn btn-primary btn-lg">Select Plan</a>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="pricing-plan">
                    <div class="pricing-header red">
                        <h4 class="pricing-title">Bar & Restaurant Module</h4>
                        <div class="pricing-cost">Tsh 1M</div>
                    </div>
                    <ul class="pricing-features">
                        <li>Installation</li>
                        <li>Data Entry</li>
                        <li>Training</li>
                        <li>Software Updates</li>
                        <li>Support: 24/7 Online Free, Onsite 35k</li>
                        <li>Annual Domain + Hosting + SSL Fee 300k</li>
                        <li>Annual maintanance + Support + Updates & License fee 350k</li>
                    </ul>
                    <div class="pricing-footer">
                        <a href="#" class="btn btn-danger btn-lg">Select Plan</a>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-12">
                <div class="pricing-plan">
                    <div class="pricing-header secondary">
                        <h4 class="pricing-title">Hotel Module</h4>
                        <div class="pricing-cost">Tshs 1.5M</div>
                    </div>
                    <ul class="pricing-features">
                        <li>Installation</li>
                        <li>Data Entry</li>
                        <li>Training</li>
                        <li>Software Updates</li>
                        <li>Support: 24/7 Online Free, Onsite 50k</li>
                        <li>Annual Domain + Hosting + SSL Fee 300k</li>
                        <li>Annual maintanance + Support + Updates & License fee 350k</li>
                    </ul>
                    <div class="pricing-footer">
                        <a href="#" class="btn btn-success btn-lg">Select Plan</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
