<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>License & Hosting Expired</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }

        .card {
            background: white;
            max-width: 800px;
            width: 90%;
            border: 1px solid #dc3545;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(220, 53, 69, 0.3);
            overflow: hidden;
        }

        .card-header {
            background-color: #dc3545;
            color: white;
            text-align: center;
            padding: 20px;
            font-size: 1.5em;
        }

        .card-body {
            padding: 25px;
            text-align: center;
        }

        .card-body p {
            margin-bottom: 20px;
            font-size: 1.1em;
            color: #555;
        }

        .list {
            text-align: left;
            margin: 0 auto 20px auto;
            width: 90%;
        }

        .list-item {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #eee;
            font-size: 1em;
        }

        .alert-box {
            background-color: #e9f7fe;
            padding: 20px;
            border-left: 5px solid #17a2b8;
            text-align: left;
            font-size: 0.95em;
            color: #333;
        }

        .card-footer {
            background-color: #f1f1f1;
            padding: 15px;
            text-align: center;
            font-size: 0.9em;
            color: #dc3545;
        }

        strong {
            font-weight: bold;
        }

        @media (max-width: 600px) {
            .list-item {
                flex-direction: column;
                align-items: flex-start;
            }
        }
    </style>
</head>

<body>
    <div class="card">
        <div class="card-header">
            🚫 License & Hosting Expired
        </div>
        <div class="card-body">
            <p>Your <strong>system license</strong> and <strong>hosting service</strong> have expired.</p>
            <p>To continue enjoying our services, please make the following payments:</p>

            @php
                $now = now();
                $hostingFee = 250000;
                $licenseFeePerLocation = 300000;
                $showHostingFee = $licenseData->h_expires_at !== null && $licenseData->h_expires_at <= $now;
                $showLicenseFee = $licenseData->expires_at <= $now;

                $total = 0;
                if ($showLicenseFee) {
                    $total += $licenseData->location * $licenseFeePerLocation;
                }
                if ($showHostingFee) {
                    $total += $hostingFee;
                }
            @endphp

            <div class="list">
                {{-- Hosting Fee --}}
                @if ($showHostingFee)
                    <div class="list-item">
                        <span>✅ Annual Domain & Hosting Fee:</span>
                        <strong>Tsh {{ number_format($hostingFee) }}</strong>
                    </div>
                @endif

                {{-- License & Maintenance --}}
                @if ($showLicenseFee)
                    <div class="list-item">
                        <span>✅ Annual System License & Maintenance @ selling location
                            ({{ number_format($licenseFeePerLocation) }} * {{ $licenseData->location }}):</span>
                        <strong>Tsh {{ number_format($licenseData->location * $licenseFeePerLocation) }}</strong>
                    </div>
                @endif

                {{-- Total --}}
                @if ($showHostingFee || $showLicenseFee)
                    <div class="list-item">
                        <span><strong>Total Amount Due:</strong></span>
                        <strong>Tsh {{ number_format($total) }}</strong>
                    </div>
                @endif
            </div>


            <div class="alert-box">
                <p><strong>Payment Instructions:</strong></p>
                <p><strong>M-PESA LIPA #: </strong>5750484</p>
                <p><strong>Agent Name:</strong> Universal Software Solution</p>
                <hr>
                <p><strong>Bank Account (NMB)</strong></p>
                <p><strong>Account Name:</strong> Burton Balele Derefa</p>
                <p><strong>Account Number:</strong> 50510074121</p>
                <p><strong>Account Type:</strong> NMB</p>
            </div>
        </div>
        <div class="card-footer">
            Access will remain restricted until payment is confirmed.
        </div>
    </div>

</body>

</html>
