@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h3 class="card-title">Customers whose return date has passed</h3>
            </div>

            <div class="card-body">

                <table id="example1" class="table table-bordered table-striped" style="text-align: center;">

                    @php
                        $penaltyEnabled = App\Models\BusinessProfile::first()->installment_penalty;
                    @endphp
                    <thead>

                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Due amount</th>

                            @if ($penaltyEnabled)
                                <th>Penalt</th>
                                <th>Net amount</th>
                            @endif
                            <th>Action</th>
                        </tr>

                    </thead>

                    <tbody>

                        @foreach ($passedReturnDate as $data)
                            <tr>
                                <td>{{ $data->loan->date }}</td>
                                <td>{{ $data->loan->customer }}</td>
                                <td>{{ $data->loan->dueamount }}</td>

                                @if ($penaltyEnabled)
                                    <td> {{ $data->loan->penalt * date_diff(date_create($data->return_date), date_create(date('Y-m-d')))->days }}
                                    </td>
                                    <td>{{ $data->loan->dueamount + $data->loan->penalt * date_diff(date_create($data->return_date), date_create(date('Y-m-d')))->days }}
                                    </td>
                                @endif

                                <td>

                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Due amount</th>
                            @if ($penaltyEnabled)
                                <th>Penalt</th>
                                <th>Net amount</th>
                            @endif
                            <th>Action</th>
                        </tr>

                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}
    

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
    </script>
@endsection

@endsection
