<div class="modal fade" id="exampleModal{{ $cart->id }}" tabindex="-1"
    aria-labelledby="exampleModalLabel{{ $cart->id }}" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg glass-modal">
            <!-- Modal Header -->
            <div class="modal-header text-white border-0"
                style="background: linear-gradient(90deg, #0d6efd, #0b5ed7);">
                <h5 class="modal-title fw-bold d-flex align-items-center"
                    id="exampleModalLabel{{ $cart->id }}">
                    <i class="bi bi-receipt-cutoff me-2"></i>
                    {{ $cart->table->name }} - Order #00{{ $cart->id }}
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <div class="modal-body p-4">
                <div class="table-responsive">
                    <table class="table table-hover table-bordered align-middle cart-table mb-0 text-center">
                        <thead class="table-light">
                            <tr>
                                <th>Image</th>
                                <th>Product</th>
                                <th>Qty</th>
                                <th>Price</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $cartTotal = 0; @endphp
                            @foreach ($cart->cartItems as $item)
                                @php $cartTotal += $item->total; @endphp
                                <tr>
                                    <td>
                                        <img src="{{ $item->image ?? 'https://via.placeholder.com/60' }}"
                                            class="img-thumbnail rounded shadow-sm product-img"
                                            style="width:60px;height:60px;object-fit:cover;">
                                    </td>
                                    <td class="fw-semibold">{{ $item->product_name }}</td>
                                    <td>{{ $item->qty }}</td>
                                    <td>{{ number_format($item->price, 2) }}</td>
                                    <td class="fw-bold text-success">{{ number_format($item->total, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="fw-bold cart-total-row">
                                <td colspan="4" class="text-end fs-6">Order Total:</td>
                                <td class="text-success fs-6">{{ number_format($cartTotal, 2) }}</td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-center bg-warning bg-opacity-25 fst-italic">
                                    <i class="bi bi-chat-dots me-1"></i>
                                    {{ $cart->comment ?? 'No Comment...' }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="modal-footer border-0">
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-1"></i> Close
                    </button>
                    <a href="{{ route('mark.order.as.seen', $cart->id) }}" class="btn btn-success btn-sm">
                        <i class="bi bi-eye me-1"></i> Mark as Seen.
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
