@extends('layouts.master')

@php
    // Dummy locations
    $locations = collect([
        (object)['id' => 1, 'name' => 'Main Store'],
        (object)['id' => 2, 'name' => 'Branch A'],
        (object)['id' => 3, 'name' => 'Branch B'],
    ]);

    // Dummy products
    $products = collect([
        (object)[
            'id' => 1,
            'name' => 'Product A',
            'unit' => (object)['name' => 'pcs'],
            'selling' => 1500
        ],
        (object)[
            'id' => 2,
            'name' => 'Product B',
            'unit' => (object)['name' => 'kg'],
            'selling' => 2200
        ],
        (object)[
            'id' => 3,
            'name' => 'Product C',
            'unit' => (object)['name' => 'liters'],
            'selling' => 1800
        ],
    ]);

    // Dummy data for testing
    $opening = 0;
    $purchase = 10;
    $purchaseReturn = 0;
    $damage = 1;
    $salesReturn = 0;
    $adjustment = 0;
    $closing = 3;
@endphp

@section('content')
<div class="container-fluid">
    <h6>Opening & Closing Stock Report</h6>

    <!-- Filter Form -->
    <form method="GET" action="" class="row mb-3 g-2">
        <div class="col-md-3">
            <label for="from" class="form-label text-white">From Date</label>
            <input type="date" id="from" name="from" class="form-control text-center" value="{{ request('from') }}">
        </div>
        <div class="col-md-3">
            <label for="to" class="form-label text-white">To Date</label>
            <input type="date" id="to" name="to" class="form-control text-center" value="{{ request('to') }}">
        </div>
        <div class="col-md-3">
            <label for="location_id" class="form-label text-white">Location</label>
            <select id="location_id" name="location_id" class="form-control text-center">
                <option value="">-- All Locations --</option>
                @foreach($locations as $loc)
                    <option value="{{ $loc->id }}" {{ request('location_id') == $loc->id ? 'selected' : '' }}>
                        {{ $loc->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button type="submit" class="btn btn-primary"><i class="fa fa-paper-plane"></i> Filter</button>
        </div>
    </form>

    <!-- Stock Table -->
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <div class="table-responsive">
                    <table class="table table-striped table-hover" id="data-table">
                        <thead>
                            <tr>
                                <th style="width: 5%">S/N</th>
                                <th style="text-align: center">Product</th>
                                <th style="text-align: center">Opening</th>
                                <th style="text-align: center">Purchase</th>
                                <th style="text-align: center">Purchase Return</th>
                                <th style="text-align: center">Damage</th>
                                <th style="text-align: center">Sold</th>
                                <th style="text-align: center">Sales Return</th>
                                <th style="text-align: center">Adjustment</th>
                                <th style="text-align: center">Closing</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($products as $product)
                                @php
                                    $total = $purchase - $purchaseReturn - $damage + $adjustment;
                                    $sold = $total - $closing - $salesReturn;
                                @endphp
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $product->name }}</td>
                                    <td>{{ $opening }} {{ $product->unit->name }}</td>
                                    <td>{{ $purchase }}</td>
                                    <td>{{ $purchaseReturn }}</td>
                                    <td>{{ $damage }}</td>
                                    <td>{{ $sold }}</td>
                                    <td>{{ $salesReturn }}</td>
                                    <td>{{ $adjustment }}</td>
                                    <td>{{ $closing }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- .table-responsive -->
            </div> <!-- .p-4 -->
        </div>
    </div>
</div>
@endsection

@section('scripts')
<!-- Still no JS needed for dummy data -->
@endsection
