@extends('layouts.master')

@section('content')

    <input type="hidden" value="{{ Auth::user()->role }}" id="user">

    <div class="card">

        <div class="card-header">
            <p> Create new purchase order</p>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <div class="row align-items-center">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group shadow-sm">
                            <span class="input-group-text bg-info text-white">
                                <i class="fas fa-store"></i>
                            </span>
                            <select name="location" id="location" class="form-control" style="text-align: center" required>
                                <option disabled selected value="">-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <form
                action="{{ route('print.purchase.order', [
                    'flag' => session('flag', $flag),
                    'id' => session('purchaseOrderData')?->id, // null-safe
                ]) }}"
                onsubmit="showSpinner()" method="post">
                @csrf
                <div class="row">
                    <div class="col-9">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle"
                                style="text-align: center; background-color: #fff;">
                                <thead class="thead-light">
                                    <tr>
                                        <th style="width: 25%">Product</th>
                                        <th style="width: 10%">Unit</th>
                                        <th style="width: 12%">Price</th>
                                        <th style="width: 20%">Qty</th>
                                        <th style="width: 12%">Amount</th>
                                        <th style="width: 10%">Action</th>
                                    </tr>
                                </thead>

                                <tbody id="tbody">
                                    @php
                                        $iteration = 200;
                                    @endphp
                                    @if (session()->has('purchaseOrderItems'))
                                        @foreach (session('purchaseOrderItems') as $index => $item)
                                            @php
                                                $iteration += $index;
                                            @endphp

                                            <tr id="tr{{ $iteration }}">
                                                <td>
                                                    <input type="hidden" name="id[]" value="{{ $item['product_id'] }}"
                                                        id="id{{ $iteration }}" class="form-control id"
                                                        style="text-align: center" readonly>

                                                    <input type="text" name="product[]"
                                                        value="{{ $item['product']->product }}"
                                                        id="product{{ $iteration }}" class="form-control product"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <select class="form-control unit" style="text-align: center"
                                                        name="unit[]" id="unit{{ $iteration }}">
                                                        {{-- Selected unit first --}}
                                                        <option selected value="{{ $item->unit->id }}">
                                                            {{ $item->unit->name }}
                                                        </option>

                                                        {{-- Loop through all units assigned to the product --}}
                                                        @foreach ($item->product->unit as $unitAssigned)
                                                            @if ($unitAssigned->unit->id != $item->unit->id)
                                                                <option value="{{ $unitAssigned->unit->id }}">
                                                                    {{ $unitAssigned->unit->name }}
                                                                </option>
                                                            @endif
                                                        @endforeach
                                                    </select>

                                                    <input type="hidden" value="1" name="cont[]"
                                                        id="cont{{ $iteration }}" class="form-control cont"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <input type="text" name="price[]" value="{{ $item['price'] }}"
                                                        id="price{{ $iteration }}" class="form-control price"
                                                        style="text-align: center">
                                                </td>

                                                <td style="display:flex">
                                                    <button type="button"
                                                        class="btn btn-outline-warning btn-block decrement"
                                                        id="{{ $iteration }}"><i class="fa fa-minus"></i></button>
                                                    <input type="text" value="{{ $item['qty'] }}" name="qty[]"
                                                        id="qty{{ $iteration }}" class="form-control qty"
                                                        style="text-align: center;" required>
                                                    <button type="button"
                                                        class="btn btn-outline-success btn-block increment"
                                                        id="increment{{ $iteration }}"><i
                                                            class="fa fa-plus"></i></button>
                                                </td>

                                                <td>
                                                    <input type="text" name="amount[]" value="{{ $item['amount'] }}"
                                                        id="amount{{ $iteration }}" class="form-control amount"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <button type="button" id="{{ $iteration }}"
                                                        class="btn btn-outline-danger removeRow"><i
                                                            class="fa fa-trash-alt"></i></button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif

                                    <!-- Dynamic rows will be appended here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col was-validated">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="text" name="total" id="total" class="form-control"
                            style="text-align: center" placeholder="Total" readonly
                            value="{{ old('total', session('purchaseOrderData.total') ? session('purchaseOrderData.total') : '') }}">

                        <input type="search" name="supplier" id="supplier" class="form-control"
                            style="text-align: center" placeholder="supplier" required
                            value="{{ old('supplier', session('supplierName')) }}">
                        <div id="supplierlist1" style="display:none">
                            <ol id="supplierlist2"></ol>
                        </div>

                        <input type="hidden" name="location" id="location1" class="form-control"
                            style="text-align: center">

                        <br>

                        <button class="btn btn-primary btn-block"><i class="fas fa-paper-plane"></i> Confirm</button>

                        <a href="{{ route('clear.purchase.order') }}" onclick="showSpinner()"
                            class="btn btn-danger btn-block">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {

            $("#location").focus();

            //Global variables
            var index = 0
            var query;
            var location;
            var ajaxResults;
            var productId;
            var paid;
            var total;
            var price;
            var qty;
            var unit;
            var id;

            $("#location").on("change", function() {
                location = $(this).val();
                $("#location1").val(location);
            });

            let lastKeyTime = 0;
            let barcodeBuffer = "";

            // =========================
            // Fetch products (manual or barcode)
            function fetchProducts(query, isBarcode = false) {
                if (!query || !location) {
                    $("#results").empty();
                    $("#list").hide();
                    return;
                }

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId: location
                    },
                    success: function(response) {
                        ajaxResults = response; // global storage
                        console.log(ajaxResults);

                        $("#results").empty();
                        let displayedIds = [];

                        // Barcode scan: if exactly 1 product, add directly
                        if (isBarcode && response.length === 1) {
                            const product = response[0];
                            addProductToTable(product);
                            $("#search").val("").focus();
                            return;
                        }

                        // Manual typing: show suggestion list
                        if (!isBarcode) {
                            if (response.length === 0) {
                                $("#results").append(
                                    '<li class="list-group-item text-center text-muted">No suggestions...</li>'
                                );
                            } else {
                                response.forEach((item, i) => {
                                    if (!displayedIds.includes(item.id)) {
                                        displayedIds.push(item.id);
                                        $("#results").append(
                                            `<li class="list-group-item product-items" data-index="${i}" id="${i}" style="cursor:pointer;">
                                    ${item.product} | Stock: ${item.totalQty} ${item.unit[0]?.name ?? ''}
                                </li>`
                                        );
                                    }
                                });
                            }
                            $("#list").fadeIn("fast");
                        }
                    }
                });
            }

            // =========================
            // Manual typing (keyup)
            $("#search").on("keyup", function(e) {
                const query = $(this).val();

                // Skip Enter key (barcode handled separately)
                if (e.which === 13) return;

                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return; // very fast typing may be barcode
                lastKeyTime = currentTime;

                if (query.length > 0) {
                    fetchProducts(query, false); // manual search
                }
            });

            // =========================
            // Barcode scan detection (Enter key)
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    const barcode = $(this).val().trim();
                    if (barcode !== "") {
                        fetchProducts(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            // =========================
            // Manual click on suggestions
            $(document).on("click", ".product-items", function() {
                let id = $(this).attr("id");
                let productData = ajaxResults[id];
                $("#list").fadeOut("slow");

                addProductToTable(productData);
            });

            // =========================
            // Add product to table (original structure preserved)
            function addProductToTable(productData) {
                let units = '';
                let unitprice = 0;

                for (let i = 0; i < (productData.unit?.length || 0); i++) {
                    units += `<option value="${productData.unit[i].id}">${productData.unit[i].name}</option>`;
                    if (i === 0) unitprice = productData.unit[0].selling;
                }

                let tr = `
                                <tr id="tr${index}">
                                    <td>
                                        <input type="hidden" name="id[]" value="${productData.id}" class="form-control id" readonly>
                                        <input type="hidden" name="product[]" value="${productData.product}" class="form-control product" readonly>
                                        <span>${productData.product}</span>
                                    </td>
                                    <td>
                                        <select class="form-control unit" name="unit[]" style="text-align:center">
                                            ${units}
                                        </select>
                                        <input type="hidden" value="1" name="cont[]" class="form-control cont" readonly>
                                    </td>
                                    <td>
                                        <input type="text" name="price[]" value="${productData.buying}" id="price${index}" class="form-control price" style="text-align:center">
                                    </td>
                                    <td style="display:flex; align-items:center;">
                                        <button type="button" class="btn btn-outline-warning decrement" id="${index}">
                                            <i class="fa fa-minus"></i>
                                        </button>
                                        <input type="text" value="1" name="qty[]" id="qty${index}" class="form-control qty" style="text-align:center;" required>
                                        <button type="button" class="btn btn-outline-success increment" id="increment${index}">
                                            <i class="fa fa-plus"></i>
                                        </button>
                                    </td>
                                    <td>
                                        <input type="text" name="amount[]" value="${productData.buying}" id="amount${index}" class="form-control amount" style="text-align:center" readonly>
                                    </td>
                                    <td>
                                        <button type="button" id="${index}" class="btn btn-outline-danger removeRow">
                                            <i class="fa fa-trash-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            `;

                $("#tbody").append(tr);
                index++;
                total();
                $("#search").val("").focus();
                $("#list").fadeOut("slow");
            }


            $(document).on("click", ".removeRow", function() {
                var id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
                $("#search").val("");
                $("#search").focus();
            });

            $(document).on("click", ".increment", function() {
                var id = $(this).attr("id").replace("increment", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);

            });

            $(document).on("click", ".decrement", function() {
                var id = $(this).attr("id").replace("decrement", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                var priceInput = $("#price" + id);
                var price = parseFloat(priceInput.val());
                var amountInput = $("#amount" + id);
                var amount = qty * price;
                amountInput.val(amount);
                total();
                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("change", ".unit", function() {
                unit = $(this).val();
                id = $(this).attr("id").replace("unit", "");
                productId = $("#id" + id).val();
                qty = $("#qty" + id).val();
                location = $("#location1").val();
                console.log(unit, productId, location, qty);

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unit,
                        'productId': productId,
                        'locationId': location,
                    },
                    success: function(data) {
                        //console.log(data);
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(data.selling);
                        $("#amount" + id).val(data.selling * qty);
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });
            $(document).on("keyup", ".price", function() {
                let id = $(this).attr("id").replace("price", "");
                let price = parseFloat($(this).val()) || 0;
                let qty = parseFloat($("#qty" + id).val()) || 0;

                $("#amount" + id).val(price * qty);
                total();
            });

            $(document).on("keyup", ".qty", function() {
                let id = $(this).attr("id").replace("qty", "");
                let qty = parseFloat($(this).val()) || 0;
                let price = parseFloat($("#price" + id).val()) || 0;

                $("#amount" + id).val(price * qty);
                total();
            });

            function total() {
                var amount = 0;
                $(".amount").each(function() {
                    amount += Number($(this).val());
                });
                $("#total").val(amount);
            }

            $("#supplier").on("keyup", function() {

                var ujumbe = "No suggestion..";
                var query = $(this).val();

                $.ajax({

                    url: "{{ route('get.supplier') }}",
                    method: "get",
                    data: {
                        'query': query,
                    },
                    success: function(data) {
                        $("#supplierlist2").empty();

                        console.log(data);

                        if (query != "") {

                            if (data.length == 0) {
                                $("#supplierlist1").fadeIn("slow");
                                $("#supplierlist2").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }

                            for (var i = 0; i < data.length; i++) {
                                $("#supplierlist1").fadeIn("slow");
                                $("#supplierlist2").append(
                                    '<li><button type="button" class="form-control supplier btn btn-outline-secondary" id="' +
                                    index++ + '" >' + data[i].name + '</button></li>');

                                $(".supplier").on("click", function() {
                                    var supplier = $(this).html();
                                    $("#supplier").val(supplier);
                                    $("#supplierlist2").fadeOut("slow");
                                });
                            }
                        }
                    }
                });
            });
        });
    </script>
@endsection

@endsection
