@extends('layouts.master')

@section('content')

    <input type="hidden" value="{{ Auth::user()->role }}" id="user">

    <div class="card">

        <div class="card-header">
            <p> Create new profoma invoice</p>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <div class="row align-items-center">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group shadow-sm">
                            <span class="input-group-text bg-info text-white">
                                <i class="fas fa-store"></i>
                            </span>
                            <select name="location" id="location" class="form-control" style="text-align: center" required>
                                <option disabled selected>-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <form action="{{ route('print.profoma.invoice', ['status' => $status]) }}" method="post">
                @csrf
                <div class="row">
                    <div class="col-9">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle"
                                style="text-align: center; background-color: #fff;">
                                <thead class="thead-light">
                                    <tr>
                                        <th style="width: 3%">#</th>
                                        <th style="width: 25%">Product</th>
                                        <th style="width: 10%">Unit</th>
                                        <th style="width: 12%">Price</th>
                                        <th style="width: 20%">Qty</th>
                                        <th style="width: 12%">Amount</th>
                                        <th style="width: 10%">Action</th>
                                    </tr>
                                </thead>

                                <tbody id="tbody">
                                    @if (session()->has('profomaItems'))
                                        @foreach (session('profomaItems') as $index => $item)
                                            @php
                                                $iteration += $index;
                                                $units = App\Models\UnitAssigned::where('product_id', $item->product_id)
                                                    ->with('unit')
                                                    ->get();
                                            @endphp

                                            <tr id="tr{{ $iteration }}">
                                                <td>
                                                    <input type="hidden" name="id[]" value="{{ $item['product_id'] }}"
                                                        id="id{{ $iteration }}" class="form-control id"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <input type="text" name="product[]"
                                                        value="{{ $item['product']->product }}"
                                                        id="product{{ $iteration }}" class="form-control product"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <select class="form-control unit" style="text-align: center"
                                                        name="unit[]" id="unit{{ $iteration }}">
                                                        <option selected value="{{ $item['unit']->id }}">
                                                            {{ $item['unit']->name }}</option>
                                                        @foreach ($units as $unit)
                                                            <option value="{{ $unit->unit->id }}">{{ $unit->unit->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <input type="hidden" value="1" name="cont[]"
                                                        id="cont{{ $iteration }}" class="form-control cont"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <input type="text" name="price[]" value="{{ $item['price'] }}"
                                                        id="price{{ $iteration }}" class="form-control price"
                                                        style="text-align: center">
                                                </td>

                                                <td style="display:flex">
                                                    <button type="button"
                                                        class="btn btn-outline-warning btn-block decrement"
                                                        id="{{ $iteration }}"><i class="fa fa-minus"></i></button>
                                                    <input type="text" value="{{ $item['qty'] }}" name="qty[]"
                                                        id="qty{{ $iteration }}" class="form-control qty"
                                                        style="text-align: center;" required>
                                                    <button type="button"
                                                        class="btn btn-outline-success btn-block increment"
                                                        id="increment{{ $iteration }}"><i
                                                            class="fa fa-plus"></i></button>
                                                </td>

                                                <td>
                                                    <input type="text" name="amount[]" value="{{ $item['amount'] }}"
                                                        id="amount{{ $iteration }}" class="form-control amount"
                                                        style="text-align: center" readonly>
                                                </td>

                                                <td>
                                                    <button type="button" id="{{ $iteration }}"
                                                        class="btn btn-outline-danger removeRow"><i
                                                            class="fa fa-trash-alt"></i></button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif

                                    <!-- Dynamic rows will be appended here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col was-validated">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="text" name="total" id="total" class="form-control"
                            style="text-align: center" placeholder="Total" readonly
                            value="{{ old('total', session('profomaData.total') ? session('profomaData.total') : '') }}">

                        {{-- <input type="search" name="customer" id="customer" class="form-control"
                            style="text-align: center" placeholder="Customer" required
                            value="{{ old('customer', session('customerName')) }}">
                        <div id="customerlist1" style="display:none">
                            <ol id="customerlist2"></ol>
                        </div> --}}

                        <div id="mteja">
                            <input type="text" id="customer" name="customer" class="form-control customer"
                                placeholder="Enter Customer Name..." style="text-align: center" required>
                            <div id="customer-list" style="display:none">
                                <ol id="customers"></ol>
                            </div>

                            <input type="text" id="phone" name="phone" class="form-control phone"
                                placeholder="Enter Customer Contacts" style="text-align: center" required>

                            <input type="text" id="address" name="address" class="form-control phone"
                                placeholder="Enter Customer Adress" style="text-align: center" required>
                        </div>

                        <input type="hidden" name="location" id="location1" class="form-control"
                            style="text-align: center">

                        <br>

                        <button class="btn btn-primary btn-block"><i class="fa fa-paper-plane"></i> Confirm</button>

                        <a href="{{ route('cancel.profoma.invoice') }}" class="btn btn-danger btn-block">
                            <i class="fa fa-times"></i> Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#location").focus();

            //Global variables
            var index = 0
            var query;
            var location;
            var ajaxResults;
            var productId;
            var paid;
            var total;
            var price;
            var qty;
            var unit;
            var id;

            $("#location").on("change", function() {
                location = $(this).val();
                $("#location1").val(location);
            });


            let lastKeyTime = 0;
            let barcodeBuffer = "";

            // =========================
            // Fetch products (manual or barcode)
            // =========================
            function fetchProducts(query, isBarcode = false) {
                if (!query || !location) {
                    $("#results").empty();
                    $("#list").hide();
                    return;
                }

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "GET",
                    data: {
                        query: isBarcode ? null : query,
                        barcode: isBarcode ? query : null,
                        locationId: location
                    },
                    success: function(response) {
                        ajaxResponse = response;
                        console.log(ajaxResponse);

                        $("#results").empty();
                        displayedIds = [];

                        // Barcode scan (expect 1 product)
                        if (isBarcode && response.length === 1) {
                            const product = response[0];
                            addProductToTable(product);
                            $("#search").val("").focus();
                            return;
                        }

                        // Manual typing: show suggestions
                        if (!isBarcode) {
                            if (response.length === 0) {
                                $("#results").append(
                                    '<li class="list-group-item text-center text-muted">No suggestions...</li>'
                                );
                            } else {
                                response.forEach((item, i) => {
                                    if (!displayedIds.includes(item.id)) {
                                        displayedIds.push(item.id);
                                        $("#results").append(
                                            `<li class="list-group-item product-items" data-index="${i}" style="cursor:pointer;">
                                    ${item.product} | Stock: ${item.totalQty} ${item.unit[0]?.name ?? ''}
                                </li>`
                                        );
                                    }
                                });
                            }
                            $("#list").fadeIn("fast");
                        }
                    }
                });
            }

            // =========================
            // Manual typing (keyup)
            $("#search").on("keyup", function(e) {
                const query = $(this).val();

                // Skip Enter key (barcode handled separately)
                if (e.which === 13) return;

                const currentTime = new Date().getTime();
                if (currentTime - lastKeyTime < 30) return; // very fast typing may be barcode
                lastKeyTime = currentTime;

                if (query.length > 0) {
                    fetchProducts(query, false); // manual search
                }
            });

            // =========================
            // Barcode scan detection (Enter key)
            $("#search").on("keydown", function(e) {
                const currentTime = new Date().getTime();
                const char = e.key;

                if (currentTime - lastKeyTime < 30) {
                    barcodeBuffer += char;
                } else {
                    barcodeBuffer = char;
                }
                lastKeyTime = currentTime;

                if (e.key === "Enter") {
                    e.preventDefault();
                    const barcode = $(this).val().trim();
                    if (barcode !== "") {
                        fetchProducts(barcode, true); // barcode search
                    }
                    barcodeBuffer = "";
                }
            });

            // =========================
            // Product click for manual selection
            $(document).on("click", ".product-items", function() {
                let indexInResponse = $(this).data("index");
                let product = ajaxResponse[indexInResponse];
                addProductToTable(product);
            });

            // =========================
            // Add product to table
            function addProductToTable(product) {
                let units = '';
                let unitprice = product.unit?.[0]?.selling ?? 0;

                for (let i = 0; i < (product.unit?.length || 0); i++) {
                    units += `<option value="${product.unit[i].id}">${product.unit[i].name}</option>`;
                }

                let tr = `
                                <tr id="tr${index}">
                                    <td><input type="hidden" name="id[]" value="${product.id}" id="id${index}" class="form-control id text-center" readonly></td>
                                    <td class="text-center">
                                        <input type="hidden" name="product[]" value="${product.product}" id="product${index}" class="form-control product text-center" readonly>
                                        ${product.product}
                                    </td>
                                    <td>
                                        <select class="form-control unit text-center" name="unit[]" id="unit${index}">
                                            ${units}
                                        </select>
                                        <input type="hidden" value="1" name="cont[]" class="form-control cont text-center" readonly>
                                    </td>
                                    <td><input type="text" name="price[]" id="price${index}" value="${unitprice}" class="form-control price text-center"></td>
                                    <td style="display:flex">
                                        <button type="button" class="btn btn-outline-warning btn-block decrement" id="decrement${index}"><i class="fa fa-minus"></i></button>
                                        <input type="text" value="1" name="qty[]" id="qty${index}" class="form-control qty text-center" required>
                                        <button type="button" class="btn btn-outline-success btn-block increment" id="increment${index}"><i class="fa fa-plus"></i></button>
                                    </td>
                                    <td><input type="text" name="amount[]" id="amount${index}" value="${unitprice}" class="form-control amount text-center" readonly></td>
                                    <td><button type="button" class="btn btn-danger removeRow" data-index="${index}"><i class="fa fa-trash-alt"></i></button></td>
                                </tr>
                            `;

                $("#tbody").append(tr);
                index++;
                total();
                $("#search").val("").focus();
                $("#list").fadeOut("slow");
            }


            $(document).on("click", ".removeRow", function() {
                var id = $(this).data("index");
                $("#tr" + id).remove();
                total();
                $("#search").val("").focus();
            });

            $(document).on("click", ".increment", function() {
                var id = $(this).attr("id").replace("increment", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            $(document).on("click", ".decrement", function() {
                var id = $(this).attr("id").replace("decrement", "");
                var qtyInput = $("#qty" + id);
                var qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                var row = $("#tr" + id);
                var qty = parseInt(row.find(".qty").val());
                var price = parseFloat(row.find(".price").val());
                var amount = qty * price;
                row.find(".amount").val(amount);
                total();
                $("#search").val("").focus();
            }

            $(document).on("change", ".unit", function() {
                unit = $(this).val();
                id = $(this).attr("id").replace("unit", "");
                productId = $("#id" + id).val();
                qty = $("#qty" + id).val();
                location = $("#location1").val();
                console.log(unit, productId, location, qty);

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unit,
                        'productId': productId,
                        'locationId': location,
                    },
                    success: function(data) {
                        //console.log(data);
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(data.selling);
                        $("#amount" + id).val(data.selling * qty);
                        total();
                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("keyup", ".price", function() {
                price = $(this).val();
                id = $(this).attr("id").replace("price", "");
                qty = $("#qty" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            $(document).on("keyup", ".qty", function() {
                qty = $(this).val();
                id = $(this).attr("id").replace("qty", "");
                price = $("#price" + id).val();
                $("#amount" + id).val(price * qty);
                total();
            });

            function total() {
                var amount = 0;
                $(".amount").each(function() {
                    amount += Number($(this).val());
                });
                $("#total").val(amount);
            }

            $("#customer").on("keyup", function() {
                let ujumbe = "No suggestions...";
                let query = $(this).val();

                if (query == "") {
                    $("#phone").val("");
                }

                $.ajax({
                    url: "{{ route('get.customer') }}",
                    method: "get",
                    data: {
                        'query': query
                    },
                    success: function(response) {
                        console.log(response);
                        $("#customers").empty();

                        // If somthing is typed.
                        if (query != "") {
                            // If ajax response returns nothing.
                            if (response.length === 0) {
                                $("#customer-list").fadeIn("slow");
                                $("#customers").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');

                                // Hide after 2 seconds
                                setTimeout(function() {
                                    $("#customer-list").fadeOut("slow", function() {
                                        $("#customers")
                                            .empty(); // Optional: clear the message
                                    });
                                }, 2000);
                            }
                            // If ajax response returns sothing.
                            for (var i = 0; i < response.length; i++) {
                                $("#customer-list").fadeIn("slow");
                                $("#customers").append(
                                    '<li><button type="button" class="form-control customernames btn btn-outline-secondary" id="' +
                                    response[i].id + '" phone="' + response[i].phone +
                                    '" address="' + response[i].address + '">' +
                                    response[i].name + '</button></li>');
                            }
                        }
                    }
                });
            });

            $(document).on("click", ".customernames", function() {
                let customerId = $(this).attr('id');
                let customerPhone = $(this).attr('phone');
                let customerAddress = $(this).attr('address');
                let customerName = $(this).html();
                let amount = $("#net").val();
                $("#customer-list").fadeOut("slow");

                $("#customer").val(customerName);
                $("#phone").val(customerPhone);
                $("#address").val(customerAddress);
            });
        });
    </script>
@endsection

@endsection
