@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <div class="card-header">

                <p>Items missing buying price</p>

            </div>

            <div class="card-body">

                <table class="table table-stripped" style="text-align: center" id="customer">
                    <thead>
                        <tr>
                            <th style="width: 1%">#</th>
                            <th style="width: 45%">Products</th>
                            <th>Buying</th>
                            <th>Location</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($products as $product)
                            <tr>
                                <td>{{ $loop->index + 1 }}</td>
                                <td>{{ $product->product }}</td>
                                <td>{{ $product->buying }}</td>
                                <td>{{ optional($product->location)->name }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Products</th>
                            <th>Buying</th>
                            <th>Location</th>
                        </tr>
                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
    </script>
@endsection

@endsection
