@extends('layouts.master')

@section('content')
    <div class="container">
        <div class="card shadow">
            <div class="card-header bg-danger text-white">
                <h4 class="mb-0">📉 Products Below Minimum Level</h4>
            </div>
            <div class="card-body p-0">
                @if ($minimumLevelProducts->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0 table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Current Qty</th>
                                    <th>Minimum Qty</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($minimumLevelProducts as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $item->product->product ?? 'N/A' }}</td>
                                        <td><span class="badge bg-danger">{{ $item->qty }} {{ $item->unit->name ?? 'N/A' }}</span></td>
                                        <td>{{ $item->min_qty }}</td>
                                        <td>{{ $item->product->location->name ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="p-3 mb-0">✅ All products are above their minimum stock levels.</p>
                @endif
            </div>
        </div>
    </div>
@section('scripts')
    <script>
        $(document).ready(function() {
            // Any additional JavaScript can go here
        });
    </script>
@endsection

@endsection
