@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            <h5 class="text-black-50">Waiters with pending bills</h5>
        </center>
    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-body">

                <table id="example1" class="table table-bordered table-striped" style="text-align: center;">
                    @php
                        $sum = 0;
                    @endphp
                    <thead>

                        <tr>
                            <th>Date</th>
                            <th>Waiter</th>
                            <th>Amount due</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>

                    </thead>

                    <tbody>

                        @foreach ($madeni as $deni)
                            @php
                                $sum += $deni->due;
                            @endphp
                            <tr>
                                <td>{{ $deni->date }}</td>
                                <td>{{ $deni->waiter }}</td>
                                <td><a href="{{ route('fetch.waiter.debt', $deni->id) }}">{{ $deni->due }}</a>
                                </td>
                                <td>{{ $deni->duedate }}</td>
                                <td>{{ $deni->user }}</td>
                            </tr>

                            {{-- @endforeach --}}
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Date</th>
                            <th>Waiter</th>
                            <th>Total ({{ $sum }})</th>
                            <th>Due date</th>
                            <th>User</th>
                        </tr>

                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
    </script>
@endsection

@endsection
